/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.publishing;

import com.schneide.werp.domain.publishing.QRCode;
import com.schneide.werp.domain.publishing.ReportLogo;
import com.schneide.werp.domain.publishing.ReportSection;
import com.schneide.werp.domain.publishing.detail.Seitengr\u00f6\u00dfe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class Report {
    private final Seitengr\u00f6\u00dfe format;
    private final List<ReportSection> sections;
    private final Optional<ReportLogo> logo;
    private final Optional<QRCode> code;
    private boolean mitSeitenzahlen;
    private boolean mitDatum;

    public Report(Seitengr\u00f6\u00dfe format, Optional<ReportLogo> logo, Optional<QRCode> code) {
        this.format = format;
        this.logo = logo;
        this.code = code;
        this.sections = new ArrayList<ReportSection>();
        this.mitSeitenzahlen = false;
        this.mitDatum = false;
    }

    public void mitSeitenzahlen() {
        this.mitSeitenzahlen = true;
    }

    public void mitDatum() {
        this.mitDatum = true;
    }

    public boolean isMitSeitenzahlen() {
        return this.mitSeitenzahlen;
    }

    public boolean isMitDatum() {
        return this.mitDatum;
    }

    public void add(ReportSection section) {
        this.sections.add(section);
    }

    public Seitengr\u00f6\u00dfe format() {
        return this.format;
    }

    public Optional<ReportLogo> logo() {
        return this.logo;
    }

    public Optional<QRCode> qrCode() {
        return this.code;
    }

    public Stream<ReportSection> sections() {
        return this.sections.stream();
    }

    public String toString() {
        return "Report [sectionCount=" + this.sections.size() + ";sections=" + String.valueOf(this.sections) + "]";
    }
}

