/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.oberfl\u00e4che.filebased;

import com.schneide.base.configuration.domain.Settings;
import com.schneide.base.io.virtual.VirtualFile;
import com.schneide.base.logging.LoggedObject;
import com.schneide.base.properties.Configuration;
import com.schneide.base.properties.Property;
import com.schneide.base.properties.performance.\u00c4nderungs\u00fcberwachteConfiguration;
import com.schneide.base.text.parsing.StringChunker;
import com.schneide.werp.domain.oberfl\u00e4che.Oberfl\u00e4che;
import com.schneide.werp.domain.oberfl\u00e4che.Oberfl\u00e4chenbehandlung;
import com.schneide.werp.domain.oberfl\u00e4che.Oberfl\u00e4chenbehandlungRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ConfigFileBasedOberfl\u00e4chenbehandlungRepository
extends LoggedObject
implements Oberfl\u00e4chenbehandlungRepository {
    private static final String sektionentyp = "Oberfl\u00e4chenbehandlung";
    private final \u00c4nderungs\u00fcberwachteConfiguration konfiguration;
    private final List<Oberfl\u00e4chenbehandlung> behandlungenCache;
    private final Map<String, List<Oberfl\u00e4che>> oberfl\u00e4chenCache;

    public static ConfigFileBasedOberfl\u00e4chenbehandlungRepository standard() {
        return new ConfigFileBasedOberfl\u00e4chenbehandlungRepository(new Configuration(new VirtualFile[]{Settings.inFileAt((String)"application/oberfl\u00e4chen.config")}));
    }

    protected ConfigFileBasedOberfl\u00e4chenbehandlungRepository(Configuration konfiguration) {
        this.konfiguration = \u00c4nderungs\u00fcberwachteConfiguration.derErstenDateiVon((Configuration)konfiguration);
        this.behandlungenCache = new ArrayList<Oberfl\u00e4chenbehandlung>();
        this.oberfl\u00e4chenCache = new HashMap<String, List<Oberfl\u00e4che>>();
        this.konfiguration.bei\u00c4nderung(() -> {
            Object object = this.behandlungenCache;
            synchronized (object) {
                this.behandlungenCache.clear();
            }
            object = this.oberfl\u00e4chenCache;
            synchronized (object) {
                this.oberfl\u00e4chenCache.clear();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Oberfl\u00e4chenbehandlung> oberfl\u00e4chenbehandlungen() {
        List<Oberfl\u00e4chenbehandlung> list = this.behandlungenCache;
        synchronized (list) {
            if (this.behandlungenCache.isEmpty()) {
                Iterable sektionen = this.konfiguration.sections(sektionentyp);
                sektionen.forEach(cs -> {
                    Oberfl\u00e4chenbehandlung behandlung = new Oberfl\u00e4chenbehandlung(cs.getIdentifier());
                    this.behandlungenCache.add(behandlung);
                });
            }
            return this.behandlungenCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Oberfl\u00e4che> oberfl\u00e4chenF\u00fcr(Oberfl\u00e4chenbehandlung behandlung) {
        String key = behandlung.bezeichnung();
        Map<String, List<Oberfl\u00e4che>> map = this.oberfl\u00e4chenCache;
        synchronized (map) {
            if (!this.oberfl\u00e4chenCache.containsKey(key)) {
                ArrayList eintr\u00e4ge = new ArrayList();
                this.oberfl\u00e4chenCache.put(key, eintr\u00e4ge);
                Optional maybeSektion = this.konfiguration.sectionFor(sektionentyp, key);
                maybeSektion.ifPresent(cs -> {
                    for (Property each : cs.properties()) {
                        StringChunker parts = new StringChunker(each.getValue(), "[");
                        parts.setCanReturnNull(false);
                        Oberfl\u00e4che neu = new Oberfl\u00e4che(each.getKey(), parts.next().trim());
                        eintr\u00e4ge.add(neu);
                    }
                });
            }
            return this.oberfl\u00e4chenCache.get(key);
        }
    }

    public static void main(String[] args) {
        ConfigFileBasedOberfl\u00e4chenbehandlungRepository demo = ConfigFileBasedOberfl\u00e4chenbehandlungRepository.standard();
        demo.oberfl\u00e4chenbehandlungen().forEach(ofb -> {
            System.out.println("### " + ofb.bezeichnung());
            Iterable<Oberfl\u00e4che> oberfl\u00e4chen = demo.oberfl\u00e4chenF\u00fcr((Oberfl\u00e4chenbehandlung)ofb);
            for (Oberfl\u00e4che each : oberfl\u00e4chen) {
                System.out.println("  - " + each.kennung() + ": " + each.bezeichnung());
            }
        });
    }
}

