/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.oberfl\u00e4che;

import com.schneide.base.datatypes.collections.iterable.IterableUtil;
import com.schneide.werp.domain.artikel.Artikeleigenschaft;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsartikel;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionslisteneintrag;
import com.schneide.werp.domain.oberfl\u00e4che.Oberfl\u00e4che;
import com.schneide.werp.domain.oberfl\u00e4che.Oberfl\u00e4chenbehandlung;
import com.schneide.werp.domain.oberfl\u00e4che.Oberfl\u00e4chenbehandlungRepository;
import com.schneide.werp.domain.oberfl\u00e4che.Oberfl\u00e4chenspezifikation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Oberfl\u00e4cheF\u00fcr {
    private static final Artikeleigenschaft behandlung = Artikeleigenschaft.Oberfl\u00e4chenbehandlung;
    private static final Artikeleigenschaft farbe = Artikeleigenschaft.Oberfl\u00e4che;
    private final Produktionsartikel artikel;
    private final Iterable<Produktionsartikel> alleDrunter;
    private final Oberfl\u00e4chenbehandlungRepository repository;

    public Oberfl\u00e4cheF\u00fcr(Produktionslisteneintrag eintrag, Oberfl\u00e4chenbehandlungRepository repository) {
        this(eintrag.artikel(), IterableUtil.asStream(eintrag.alleUntergeordneten()).map(Produktionslisteneintrag::artikel).collect(Collectors.toList()), repository);
    }

    public Oberfl\u00e4cheF\u00fcr(Produktionsartikel artikel, Oberfl\u00e4chenbehandlungRepository repository) {
        this(artikel, List.of(), repository);
    }

    public Oberfl\u00e4cheF\u00fcr(Produktionsartikel artikel, Iterable<Produktionsartikel> alleDrunter, Oberfl\u00e4chenbehandlungRepository repository) {
        this.artikel = artikel;
        this.alleDrunter = alleDrunter;
        this.repository = repository;
    }

    public boolean hat\u00c4nderbareOberfl\u00e4che() {
        boolean f\u00fcrDenArtikelFestSpezifiziert = this.artikel.spezifikation().eigenschaft(behandlung).isPresent() && this.artikel.spezifikation().eigenschaft(farbe).isPresent();
        return !f\u00fcrDenArtikelFestSpezifiziert;
    }

    public String bezeichnung() {
        return this.aktuellGew\u00e4hlt().map(Oberfl\u00e4chenspezifikation::bezeichnung).orElse("");
    }

    public Optional<Oberfl\u00e4chenspezifikation> aktuellGew\u00e4hlt() {
        Optional<String> maybeBehandlung = this.artikel.eigenschaft(behandlung);
        if (maybeBehandlung.isEmpty()) {
            return Optional.empty();
        }
        Optional<String> maybeFarbe = this.artikel.eigenschaft(farbe);
        if (maybeFarbe.isEmpty()) {
            return Optional.empty();
        }
        Optional<Oberfl\u00e4chenbehandlung> maybeOberfl\u00e4chenbehandlung = this.repository.oberfl\u00e4chenbehandlungF\u00fcr(maybeBehandlung.get());
        if (maybeOberfl\u00e4chenbehandlung.isEmpty()) {
            return Optional.empty();
        }
        Optional<Oberfl\u00e4che> maybeOberfl\u00e4che = this.repository.oberfl\u00e4cheF\u00fcr(maybeOberfl\u00e4chenbehandlung.get(), maybeFarbe.get());
        if (maybeOberfl\u00e4che.isEmpty()) {
            return Optional.empty();
        }
        Oberfl\u00e4chenspezifikation result = new Oberfl\u00e4chenspezifikation(maybeOberfl\u00e4chenbehandlung.get(), maybeOberfl\u00e4che.get());
        return Optional.of(result);
    }

    public void setzeAuf(Optional<Oberfl\u00e4chenspezifikation> neu) {
        Oberfl\u00e4cheF\u00fcr.setze(this.artikel, neu);
    }

    private static void setze(Produktionsartikel ziel, Optional<Oberfl\u00e4chenspezifikation> wert) {
        ziel.mitEigenschaft(Artikeleigenschaft.Oberfl\u00e4chenbehandlung, wert.map(Oberfl\u00e4chenspezifikation::behandlung).map(Oberfl\u00e4chenbehandlung::kennung).orElse(""));
        ziel.mitEigenschaft(Artikeleigenschaft.Oberfl\u00e4che, wert.map(Oberfl\u00e4chenspezifikation::farbe).map(Oberfl\u00e4che::kennung).orElse(""));
    }

    public void setzeF\u00fcrGesamtenBaumAuf(Optional<Oberfl\u00e4chenspezifikation> neu) {
        this.setzeAuf(neu);
        this.alleDrunter.forEach(zpa -> Oberfl\u00e4cheF\u00fcr.setze(zpa, neu));
    }
}

