/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.material;

import com.schneide.base.logging.LoggedObject;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import java.util.Optional;

public class Masse {
    public static final BigDecimal kilo = BigDecimal.valueOf(1000L);
    public static final Masse keine = new Masse(0L);
    private final long gramm;

    public Masse(long gramm) {
        this.gramm = gramm;
    }

    public static Optional<Masse> ausKilogrammangabe(String angabe) {
        try {
            BigDecimal wert = new BigDecimal(angabe.replace(',', '.'), MathContext.DECIMAL128);
            BigDecimal inGramm = wert.multiply(kilo);
            Masse result = new Masse(inGramm.longValue());
            return Optional.of(result);
        }
        catch (NumberFormatException e) {
            LoggedObject.getStaticLogger().error((Object)("Kann " + angabe + " nicht als Masse interpretieren."), (Throwable)e);
            return Optional.empty();
        }
    }

    public long inGramm() {
        return this.gramm;
    }

    public BigDecimal inKilogramm() {
        return BigDecimal.valueOf(this.gramm).divide(kilo);
    }

    public int hashCode() {
        return Objects.hash(this.gramm);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Masse other = (Masse)obj;
        return this.gramm == other.gramm;
    }

    public String toString() {
        return "Masse [kilogramm=" + String.valueOf(this.inKilogramm()) + "]";
    }
}

