/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.format.excel;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public interface Exceldatei {
    public String name();

    public Exceldatei mitKopfzeilen(int var1);

    public Iterable<Exceltabelle> alleTabellen();

    public Exceltabelle ersteTabelle();

    public Iterable<String> alleTabellennamen();

    public Optional<Exceltabelle> tabelleF\u00fcr(String var1);

    public record Zellenkoordinate(int zeile, int spalte) {
        public static final Zellenkoordinate linksOben = new Zellenkoordinate(0, 0);

        public Zellenkoordinate rechtsDaneben() {
            return this.horizontalVersetzt(1);
        }

        public Zellenkoordinate linksDaneben() {
            return this.horizontalVersetzt(-1);
        }

        public Zellenkoordinate horizontalVersetzt(int spaltenoffset) {
            return new Zellenkoordinate(this.zeile, this.spalte + spaltenoffset);
        }

        public Zellenkoordinate dar\u00fcber() {
            return this.vertikalVersetzt(-1);
        }

        public Zellenkoordinate darunter() {
            return this.vertikalVersetzt(1);
        }

        public Zellenkoordinate vertikalVersetzt(int zeilenoffset) {
            return new Zellenkoordinate(this.zeile + zeilenoffset, this.spalte);
        }
    }

    public record Tabellengr\u00f6\u00dfe(int zeilen, int spalten) {
        public Iterable<Zellenkoordinate> alleZellen() {
            ArrayList<Zellenkoordinate> result = new ArrayList<Zellenkoordinate>();
            for (int zeile = 0; zeile < this.zeilen; ++zeile) {
                for (int spalte = 0; spalte < this.spalten; ++spalte) {
                    result.add(new Zellenkoordinate(zeile, spalte));
                }
            }
            return result;
        }
    }

    public static interface Excelzeile {
        public String tabellenname();

        public String name();

        public String stringIn(int var1);

        public int spalten();

        default public String stringIn(String spaltenkennung) {
            return this.stringIn(Excelzeile.spaltenindexF\u00fcr(spaltenkennung));
        }

        default public List<String> alsTextliste() {
            ArrayList<String> result = new ArrayList<String>();
            for (int spalte = 0; spalte < this.spalten(); ++spalte) {
                result.add(this.stringIn(spalte));
            }
            return result;
        }

        default public Optional<Integer> integerIn(String spaltenkennung) {
            return this.integerIn(Excelzeile.spaltenindexF\u00fcr(spaltenkennung));
        }

        default public Optional<Integer> integerIn(int spalte) {
            try {
                return Optional.of(this.intIn(spalte));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }

        default public int intIn(int spalte) {
            try {
                return Integer.parseInt(this.stringIn(spalte));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(e.getMessage() + " in row " + this.name() + " and column " + spalte + " in Tabelle " + this.tabellenname());
            }
        }

        public static int spaltenindexF\u00fcr(String spaltenkennung) {
            if (null == spaltenkennung || spaltenkennung.isBlank()) {
                return -1;
            }
            char ersterBuchstabe = spaltenkennung.toUpperCase().charAt(0);
            return ersterBuchstabe - 65;
        }
    }

    public static interface Exceltabelle {
        public String name();

        public Tabellengr\u00f6\u00dfe gr\u00f6\u00dfe();

        public Iterable<Excelzeile> zeilenNachKopfzeilen();

        public Optional<Excelzeile> zeile(int var1);

        public Optional<String> zellentext(Zellenkoordinate var1);

        default public String zellentextOderLeer(Zellenkoordinate koordinate) {
            return this.zellentext(koordinate).orElse("");
        }

        default public Optional<String> zellentext(int zeile, int spalte) {
            return this.zellentext(new Zellenkoordinate(zeile, spalte));
        }

        default public boolean zellentextIst(String erwartet, Zellenkoordinate koordinate) {
            return erwartet.equals(this.zellentextOderLeer(koordinate).trim());
        }

        default public boolean zelleIstLeer(Zellenkoordinate koordinate) {
            boolean result = this.zellentextIst("", koordinate);
            return result;
        }
    }
}

