/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste;

import com.schneide.base.text.transformation.Fillup;
import com.schneide.werp.domain.artikel.Artikel;
import com.schneide.werp.domain.erf\u00fcllung.st\u00fcckliste.St\u00fccklisteneintrag;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import java.util.Optional;

public interface St\u00fccklistenbehaftet {
    public Iterable<? extends St\u00fccklisteneintrag> st\u00fccklisteneintr\u00e4ge();

    public Optional<Produktionsnummer> maybeProduktionsnummer();

    default public String bezeichnung() {
        return this.maybeProduktionsnummer().map(Produktionsnummer::alsText).orElse("UNBEKANNT");
    }

    public static String alsText(St\u00fccklistenbehaftet st\u00fcckliste) {
        StringBuilder result = new StringBuilder();
        result.append(st\u00fcckliste.bezeichnung() + ":\n");
        result.append(St\u00fccklistenbehaftet.alsText("", st\u00fcckliste));
        return result.toString();
    }

    private static String alsText(String pr\u00e4fix, St\u00fccklistenbehaftet st\u00fcckliste) {
        StringBuilder result = new StringBuilder();
        for (St\u00fccklisteneintrag st\u00fccklisteneintrag : st\u00fcckliste.st\u00fccklisteneintr\u00e4ge()) {
            StringBuilder text = new StringBuilder();
            text.append(pr\u00e4fix);
            text.append(St\u00fccklistenbehaftet.aufgef\u00fcllt(st\u00fccklisteneintrag.position()));
            text.append(" - ");
            text.append(St\u00fccklistenbehaftet.aufgef\u00fcllt(st\u00fccklisteneintrag.anzahl()));
            text.append("x ");
            Optional<Artikel<?>> maybeArtikel = st\u00fccklisteneintrag.artikel();
            if (maybeArtikel.isEmpty()) {
                text.append("UNBEKANNT");
                result.append(text.toString() + "\n");
                continue;
            }
            Artikel<?> artikel = maybeArtikel.get();
            text.append(artikel.artikelnummerMitRevision());
            text.append(": ");
            text.append(artikel.benennung());
            result.append(text.toString() + "\n");
            result.append(St\u00fccklistenbehaftet.alsText(pr\u00e4fix + St\u00fccklistenbehaftet.aufgef\u00fcllt(st\u00fccklisteneintrag.position()) + ".", artikel));
        }
        return result.toString();
    }

    private static String aufgef\u00fcllt(int zahl) {
        return Fillup.leadingWith((String)" ", (int)2, (String)String.valueOf(zahl));
    }
}

