/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.erf\u00fcllung.schritt;

import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsartikel;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionskoordinate;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import java.util.ArrayList;
import java.util.List;

public class AngewendeterErf\u00fcllungsschritt {
    private final List<AngewendeterErf\u00fcllungsschritt> voraussetzungen;
    private final Produktionskoordinate produktionskoordinate;
    private final int produktionsanzahl;
    private final Produktionsartikel artikel;
    private final Arbeitsschritt t\u00e4tigkeit;
    private final boolean istLetzterAufErf\u00fcllungsweg;
    private final String kommentar;

    public AngewendeterErf\u00fcllungsschritt(Produktionskoordinate produktionskoordinate, int produktionszahl, Produktionsartikel artikel, Arbeitsschritt t\u00e4tigkeit, boolean istLetzterAufErf\u00fcllungsweg, String kommentar) {
        this.produktionskoordinate = produktionskoordinate;
        this.produktionsanzahl = produktionszahl;
        this.artikel = artikel;
        this.kommentar = kommentar;
        this.voraussetzungen = new ArrayList<AngewendeterErf\u00fcllungsschritt>();
        this.t\u00e4tigkeit = t\u00e4tigkeit;
        this.istLetzterAufErf\u00fcllungsweg = istLetzterAufErf\u00fcllungsweg;
    }

    public Produktionskoordinate produktionskoordinate() {
        return this.produktionskoordinate;
    }

    public int produktionsanzahl() {
        return this.produktionsanzahl;
    }

    public Produktionsartikel artikel() {
        return this.artikel;
    }

    public Arbeitsschritt t\u00e4tigkeit() {
        return this.t\u00e4tigkeit;
    }

    public String t\u00e4tigkeitsbeschreibung() {
        return this.t\u00e4tigkeit.nummerMitT\u00e4tigkeit();
    }

    public boolean istLetzterAufErf\u00fcllungsweg() {
        return this.istLetzterAufErf\u00fcllungsweg;
    }

    public boolean istVorziehbar() {
        return this.t\u00e4tigkeit.istVorziehbar();
    }

    public void hatVoraussetzung(AngewendeterErf\u00fcllungsschritt neu) {
        this.voraussetzungen.add(neu);
    }

    public String kommentar() {
        return this.kommentar;
    }

    public void etabliereAlsNachfolger(AngewendeterErf\u00fcllungsschritt nachfolger) {
        this.anschlusspunkteF\u00fcrNachfolger().forEach(nachfolger::hatVoraussetzung);
    }

    protected Iterable<AngewendeterErf\u00fcllungsschritt> anschlusspunkteF\u00fcrNachfolger() {
        if (this.t\u00e4tigkeit.istPlatzhalter()) {
            return this.voraussetzungen();
        }
        return List.of(this);
    }

    public Iterable<AngewendeterErf\u00fcllungsschritt> voraussetzungen() {
        return this.voraussetzungen;
    }
}

