/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.erf\u00fcllung.produktion;

import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsartikel;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionskoordinate;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntBinaryOperator;
import java.util.stream.Collectors;

public class Produktionslisteneintrag {
    public static final String bezeichnung = "Produktionslisteneintrag";
    private final Optional<Produktionslisteneintrag> \u00fcbergeordnet;
    private final int position;
    private final int anzahl;
    private final Produktionsartikel artikel;
    private final List<Produktionslisteneintrag> untergeordnet;
    private final Produktionsnummer kontext;

    protected Produktionslisteneintrag(Produktionsnummer kontext, Optional<Produktionslisteneintrag> \u00fcbergeordnet, int position, int anzahl, Produktionsartikel artikel) {
        this.kontext = kontext;
        this.\u00fcbergeordnet = \u00fcbergeordnet;
        this.position = position;
        this.anzahl = anzahl;
        this.artikel = artikel;
        this.untergeordnet = new ArrayList<Produktionslisteneintrag>();
        \u00fcbergeordnet.ifPresent(\u00fcber -> \u00fcber.mitUnterposition(this));
    }

    public void mitUnterposition(Produktionslisteneintrag unter) {
        this.untergeordnet.add(unter);
    }

    public Produktionsnummer produktion() {
        return this.kontext;
    }

    public int position() {
        return this.position;
    }

    public int eigeneAnzahl() {
        return this.anzahl;
    }

    public Produktionsartikel artikel() {
        return this.artikel;
    }

    public int gesamtanzahl() {
        IntBinaryOperator multiplication = (x, y) -> x * y;
        return this.eintragsketteNachOben().stream().mapToInt(Produktionslisteneintrag::eigeneAnzahl).reduce(1, multiplication);
    }

    public int ebene() {
        return this.eintragsketteNachOben().size();
    }

    public Produktionskoordinate koordinate() {
        return new Produktionskoordinate(this.kontext, this.eintragsketteNachOben().stream().map(Produktionslisteneintrag::position).collect(Collectors.toList()));
    }

    public Optional<Produktionslisteneintrag> \u00fcbergeordnet() {
        return this.\u00fcbergeordnet;
    }

    public Iterable<Produktionslisteneintrag> untergeordnet() {
        return List.copyOf(this.untergeordnet);
    }

    public Iterable<Produktionslisteneintrag> alleUntergeordneten() {
        ArrayList<Produktionslisteneintrag> result = new ArrayList<Produktionslisteneintrag>();
        this.eachHierarchically(result::add);
        return result;
    }

    public void eachDepthFirst(Consumer<Produktionslisteneintrag> aktion) {
        for (Produktionslisteneintrag each : this.untergeordnet) {
            each.eachDepthFirst(aktion);
        }
        aktion.accept(this);
    }

    public void eachHierarchically(Consumer<Produktionslisteneintrag> aktion) {
        aktion.accept(this);
        for (Produktionslisteneintrag each : this.untergeordnet) {
            each.eachHierarchically(aktion);
        }
    }

    public Iterable<Produktionslisteneintrag> eintragspfad() {
        return this.eintragsketteNachOben();
    }

    protected List<Produktionslisteneintrag> eintragsketteNachOben() {
        ArrayList<Produktionslisteneintrag> result = new ArrayList<Produktionslisteneintrag>();
        Optional<Produktionslisteneintrag> aktuell = Optional.of(this);
        while (aktuell.isPresent()) {
            result.add(aktuell.get());
            aktuell = aktuell.flatMap(Produktionslisteneintrag::\u00fcbergeordnet);
        }
        Collections.reverse(result);
        return result;
    }

    public String beschreibung() {
        return this.koordinate().alsText() + " - " + this.eigeneAnzahl() + "x " + this.artikel().artikelnummerMitRevision() + ": " + this.artikel().bezeichnung();
    }
}

