/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.erf\u00fcllung.produktion;

import com.schneide.base.datatypes.collections.iterable.TransformingIterable;
import com.schneide.base.text.transformation.Fillup;
import com.schneide.werp.domain.produktion.Produktionsnummer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class Produktionskoordinate {
    private final Produktionsnummer kontext;
    private final List<Integer> absolutePosition;

    public Produktionskoordinate(Produktionsnummer kontext, List<Integer> absolutePosition) {
        this.kontext = kontext;
        this.absolutePosition = absolutePosition;
    }

    public Produktionsnummer nummer() {
        return this.kontext;
    }

    public Optional<Produktionskoordinate> \u00fcbergeordnet() {
        if (this.absolutePosition.size() <= 1) {
            return Optional.empty();
        }
        Produktionskoordinate result = new Produktionskoordinate(this.kontext, this.absolutePosition.subList(0, this.absolutePosition.size() - 1));
        return Optional.of(result);
    }

    public int ebene() {
        return this.absolutePosition.size();
    }

    public String alsSpaltentext(int spaltenbreite) {
        return this.alsBearbeiteterText(s -> Fillup.leadingWith((String)" ", (int)spaltenbreite, (String)s));
    }

    public String alsText() {
        return this.alsBearbeiteterText(Function.identity());
    }

    public Iterable<Integer> alsZahlenfolge() {
        return List.copyOf(this.absolutePosition);
    }

    private String alsBearbeiteterText(Function<String, String> spaltenbearbeitung) {
        return String.join((CharSequence)".", (Iterable<? extends CharSequence>)new TransformingIterable(i -> (String)spaltenbearbeitung.apply(String.valueOf(i)), this.absolutePosition));
    }

    public int hashCode() {
        return Objects.hash(this.absolutePosition, this.kontext.alsText());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Produktionskoordinate other = (Produktionskoordinate)obj;
        return Objects.equals(this.absolutePosition, other.absolutePosition) && Objects.equals(this.kontext.alsText(), other.kontext.alsText());
    }

    public String toString() {
        return this.alsText();
    }
}

