/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.domain.erf\u00fcllung.auftrag;

import com.schneide.base.io.reader.LineBuilder;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragIdentifikation;
import com.schneide.werp.domain.erf\u00fcllung.auftrag.ArbeitsauftragRepository;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionsartikel;
import com.schneide.werp.domain.erf\u00fcllung.produktion.Produktionskoordinate;
import com.schneide.werp.domain.erf\u00fcllung.schritt.Arbeitsschritt;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Arbeitsauftrag {
    public static final String bezeichnung = "Arbeitsauftrag";
    private final ArbeitsauftragIdentifikation identifikation;
    private final Produktionskoordinate listenkoordinate;
    private final Produktionsartikel f\u00fcrArtikel;
    private final int anzahl;
    private final Arbeitsschritt t\u00e4tigkeit;
    private final List<ArbeitsauftragIdentifikation> vorarbeiten;
    private final List<ArbeitsauftragIdentifikation> nacharbeiten;
    private final String kommentar;

    public Arbeitsauftrag(ArbeitsauftragIdentifikation identifikation, Produktionsartikel f\u00fcrArtikel, Produktionskoordinate listenkoordinate, int anzahl, Arbeitsschritt t\u00e4tigkeit, String kommentar) {
        this.identifikation = identifikation;
        this.f\u00fcrArtikel = f\u00fcrArtikel;
        this.listenkoordinate = listenkoordinate;
        this.anzahl = anzahl;
        this.t\u00e4tigkeit = t\u00e4tigkeit;
        this.kommentar = kommentar;
        this.vorarbeiten = new ArrayList<ArbeitsauftragIdentifikation>();
        this.nacharbeiten = new ArrayList<ArbeitsauftragIdentifikation>();
    }

    public ArbeitsauftragIdentifikation identifikation() {
        return this.identifikation;
    }

    public Produktionskoordinate listenkoordinate() {
        return this.listenkoordinate;
    }

    public boolean istLetzterAufErf\u00fcllungsweg() {
        return false;
    }

    public Arbeitsschritt t\u00e4tigkeit() {
        return this.t\u00e4tigkeit;
    }

    public String t\u00e4tigkeitsbeschreibung() {
        return this.t\u00e4tigkeit.nummerMitT\u00e4tigkeit();
    }

    public Produktionsartikel f\u00fcrArtikel() {
        return this.f\u00fcrArtikel;
    }

    public int anzahl() {
        return this.anzahl;
    }

    public Optional<LocalDate> produktionsbeginn() {
        return Optional.of(LocalDate.now());
    }

    public LocalDate geplanteFertigstellung() {
        return LocalDate.now().plusWeeks(2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ArbeitsauftragIdentifikation> vorarbeiten() {
        List<ArbeitsauftragIdentifikation> list = this.vorarbeiten;
        synchronized (list) {
            return List.copyOf(this.vorarbeiten);
        }
    }

    public Iterable<Arbeitsauftrag> vorarbeiten(ArbeitsauftragRepository auftr\u00e4ge) {
        return this.arbeitenAus(this.vorarbeiten, auftr\u00e4ge).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ArbeitsauftragIdentifikation> nacharbeiten() {
        List<ArbeitsauftragIdentifikation> list = this.nacharbeiten;
        synchronized (list) {
            return List.copyOf(this.nacharbeiten);
        }
    }

    public Iterable<Arbeitsauftrag> nacharbeiten(ArbeitsauftragRepository auftr\u00e4ge) {
        return this.arbeitenAus(this.nacharbeiten, auftr\u00e4ge).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Stream<Arbeitsauftrag> arbeitenAus(List<ArbeitsauftragIdentifikation> ids, ArbeitsauftragRepository repository) {
        List<ArbeitsauftragIdentifikation> list = ids;
        synchronized (list) {
            return ids.stream().map(repository::f\u00fcr).filter(Optional::isPresent).map(Optional::get);
        }
    }

    public String kommentar() {
        return this.kommentar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean istJoin() {
        List<ArbeitsauftragIdentifikation> list = this.vorarbeiten;
        synchronized (list) {
            return this.vorarbeiten.size() > 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean istStartpunkt() {
        List<ArbeitsauftragIdentifikation> list = this.vorarbeiten;
        synchronized (list) {
            return this.vorarbeiten.isEmpty();
        }
    }

    public boolean folgtAufFork(ArbeitsauftragRepository repository) {
        return this.arbeitenAus(this.vorarbeiten, repository).filter(aa -> aa.istFork()).findAny().isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean istFork() {
        List<ArbeitsauftragIdentifikation> list = this.nacharbeiten;
        synchronized (list) {
            return this.nacharbeiten.size() > 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean istEndpunkt() {
        List<ArbeitsauftragIdentifikation> list = this.nacharbeiten;
        synchronized (list) {
            return this.nacharbeiten.isEmpty();
        }
    }

    public void h\u00e4ngtAbVon(Arbeitsauftrag vorarbeit) {
        this.h\u00e4ngtAbVon(vorarbeit.identifikation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void h\u00e4ngtAbVon(ArbeitsauftragIdentifikation vorarbeit) {
        List<ArbeitsauftragIdentifikation> list = this.vorarbeiten;
        synchronized (list) {
            this.vorarbeiten.add(vorarbeit);
        }
    }

    public void vorarbeitVon(Arbeitsauftrag nachfolger) {
        this.vorarbeitVon(nachfolger.identifikation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vorarbeitVon(ArbeitsauftragIdentifikation nachfolger) {
        List<ArbeitsauftragIdentifikation> list = this.nacharbeiten;
        synchronized (list) {
            this.nacharbeiten.add(nachfolger);
        }
    }

    public String einzeiligeBeschreibung() {
        return this.t\u00e4tigkeitsbeschreibung() + " f\u00fcr " + this.anzahl() + "x " + this.artikelbeschreibung();
    }

    public String artikelbeschreibung() {
        return this.f\u00fcrArtikel().artikelnummerMitRevision() + ": " + this.f\u00fcrArtikel().bezeichnung();
    }

    public String toString() {
        LineBuilder result = new LineBuilder();
        result.addLine("--------------");
        result.addLine("Arbeitsauftrag " + String.valueOf(this.identifikation));
        result.addLine("f\u00fcr Artikel: " + String.valueOf(this.f\u00fcrArtikel));
        result.addLine("Anzahl: " + this.anzahl);
        result.addLine("Arbeitsvorgang: " + String.valueOf(this.t\u00e4tigkeit));
        this.vorarbeiten.forEach(vorher -> result.addLine("* Ben\u00f6tigt: " + String.valueOf(vorher)));
        return result.toString();
    }

    public Arbeitsauftrag mit\u00c4nderungen(int neueAnzahl, String neuerKommentar) {
        Arbeitsauftrag result = new Arbeitsauftrag(this.identifikation, this.f\u00fcrArtikel, this.listenkoordinate, neueAnzahl, this.t\u00e4tigkeit, neuerKommentar);
        this.vorarbeiten().forEach(result::h\u00e4ngtAbVon);
        this.nacharbeiten().forEach(result::vorarbeitVon);
        return result;
    }

    public static Map<String, Arbeitsauftrag> alsDictionary(Iterable<Arbeitsauftrag> auftr\u00e4ge) {
        HashMap<String, Arbeitsauftrag> result = new HashMap<String, Arbeitsauftrag>();
        auftr\u00e4ge.forEach(aa -> result.put(aa.identifikation().alsText(), (Arbeitsauftrag)aa));
        return result;
    }
}

