/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.persistence.binary.types;

import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.persistence.binary.exceptions.BinaryPersistenceException;
import org.eclipse.serializer.persistence.binary.types.Binary;
import org.eclipse.serializer.persistence.types.PersistenceLoadHandler;

public interface ValidatingBinaryHandler<T, S> {
    default public void validateState(Binary data, T instance, PersistenceLoadHandler handler) {
        this.validateStates(instance, this.getValidationStateFromInstance(instance), this.getValidationStateFromBinary(data));
    }

    public S getValidationStateFromInstance(T var1);

    public S getValidationStateFromBinary(Binary var1);

    default public void validateStates(T instance, S instanceState, S binaryState) {
        if (instanceState.equals(binaryState)) {
            return;
        }
        this.throwInconsistentStateException(instance, instanceState, binaryState);
    }

    default public void throwInconsistentStateException(T instance, Object instanceStateRepresentation, Object binaryStateRepresentation) {
        throw new BinaryPersistenceException("Inconsistent state for instance " + XChars.systemString(instance) + ": \"" + instanceStateRepresentation + "\" not equal to \"" + binaryStateRepresentation + "\"");
    }
}

