/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.render.pdf.detail;

import com.schneide.werp.domain.publishing.detail.Seitengr\u00f6\u00dfe;
import com.schneide.werp.module.render.pdf.detail.Cursor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class Page {
    public final float width;
    public final float height;
    public final float verticalMargin;
    public final float horizontalMargin;
    private Supplier<PDRectangle> pdfboxPage = () -> new PDRectangle(width, height);
    private static final Map<Seitengr\u00f6\u00dfe, Supplier<PDRectangle>> standardformate = Map.of(Seitengr\u00f6\u00dfe.DIN_A5, () -> PDRectangle.A5, Seitengr\u00f6\u00dfe.DIN_A4, () -> PDRectangle.A4);

    public static Page f\u00fcr(Seitengr\u00f6\u00dfe gr\u00f6\u00dfe) {
        Page result = new Page(gr\u00f6\u00dfe.breiteInMillimetern(), gr\u00f6\u00dfe.hH\u00f6heInMillimetern());
        Optional.ofNullable(standardformate.get(gr\u00f6\u00dfe)).ifPresent(result::withPdfboxPage);
        return result;
    }

    private Page(float width, float height) {
        this(width, height, 20.0f, 20.0f);
    }

    private Page(float width, float height, float verticalMargin, float horizontalMargin) {
        this.width = width;
        this.height = height;
        this.verticalMargin = verticalMargin;
        this.horizontalMargin = horizontalMargin;
    }

    private void withPdfboxPage(Supplier<PDRectangle> pdfbox) {
        this.pdfboxPage = pdfbox;
    }

    public PDPage neueSeite() {
        return new PDPage(this.pdfboxPage.get());
    }

    public List<Cursor> acrossAtHeightOf(Cursor reference) {
        return Arrays.asList(reference.horizontallyAt(0.0f), reference.horizontallyAt(this.width - 2.0f * this.verticalMargin));
    }

    public Page withVerticalMargin(float newVerticalMargin) {
        return new Page(this.width, this.height, newVerticalMargin, this.horizontalMargin);
    }
}

