/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.render.pdf.detail;

import com.schneide.werp.domain.publishing.detail.FontStyle;
import com.schneide.werp.module.render.pdf.engine.RenderEngine;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class FontSpecification {
    public final PDFont font;
    public final float size;

    public FontSpecification(PDFont font, float size) {
        this.font = font;
        this.size = size;
    }

    public void applyTo(RenderEngine rendering) throws IOException {
        rendering.changeFontTo(this.font, this.size);
    }

    public static FontSpecification from(FontStyle style) {
        if (FontStyle.normal == style) {
            return new FontSpecification((PDFont)PDType1Font.HELVETICA, 10.0f);
        }
        if (FontStyle.emphasized == style) {
            return new FontSpecification((PDFont)PDType1Font.HELVETICA_BOLD, 10.0f);
        }
        if (FontStyle.important == style) {
            return new FontSpecification((PDFont)PDType1Font.HELVETICA, 12.0f);
        }
        if (FontStyle.primaryInformation == style) {
            return new FontSpecification((PDFont)PDType1Font.HELVETICA_BOLD, 12.0f);
        }
        if (FontStyle.sectionHeadline == style) {
            return new FontSpecification((PDFont)PDType1Font.HELVETICA_BOLD, 14.0f);
        }
        if (FontStyle.reportHeadline == style) {
            return new FontSpecification((PDFont)PDType1Font.HELVETICA_BOLD, 18.0f);
        }
        return new FontSpecification((PDFont)PDType1Font.HELVETICA, 10.0f);
    }
}

