/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.render.pdf.detail;

import com.schneide.werp.module.render.pdf.detail.Page;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public final class Cursor {
    public static final float millimetersPerInch = 25.4f;
    public static final float renderPixelPerInch = 72.0f;
    private final float vertical;
    private final float horizontal;
    private final Page context;

    private Cursor(float horizontal, float vertical, Page context) {
        this.vertical = vertical;
        this.horizontal = horizontal;
        this.context = context;
    }

    public static Cursor topLeftOn(Page context) {
        return new Cursor(0.0f, 0.0f, context);
    }

    public static Cursor bottomRightOn(Page context) {
        return new Cursor(context.width, context.height, context);
    }

    public Cursor startOfNettoArea() {
        return this.at(this.context.verticalMargin, this.context.horizontalMargin);
    }

    public Cursor at(float absoluteHorizontal, float absoluteVertical) {
        return new Cursor(absoluteHorizontal, absoluteVertical, this.context);
    }

    public void applyTo(PDPageContentStream pdf) throws IOException {
        this.perform((arg_0, arg_1) -> ((PDPageContentStream)pdf).moveTo(arg_0, arg_1));
    }

    public void applyForTextIn(PDPageContentStream pdf) throws IOException {
        this.perform((arg_0, arg_1) -> ((PDPageContentStream)pdf).newLineAtOffset(arg_0, arg_1));
    }

    public void perform(PositionBasedPDFOperation operation) throws IOException {
        float pdfPositionHorizontal = this.asRenderPixel(this.horizontal);
        float pdfPositionVertical = this.asRenderPixel(this.context.height - this.vertical);
        operation.applyAt(pdfPositionHorizontal, pdfPositionVertical);
    }

    private float asRenderPixel(float millimeter) {
        return millimeter / 25.4f * 72.0f;
    }

    public Cursor with(Offset offset) {
        return this.at(this.horizontal + offset.horizontally, this.vertical + offset.vertically);
    }

    public Cursor down(float verticalDistance) {
        return this.at(this.horizontal, this.vertical + verticalDistance);
    }

    public Cursor up(float verticalDistance) {
        return this.at(this.horizontal, this.vertical - verticalDistance);
    }

    public Cursor right(float horizontalDistance) {
        return this.at(this.horizontal + horizontalDistance, this.vertical);
    }

    public Cursor left(float horizontalDistance) {
        return this.at(this.horizontal - horizontalDistance, this.vertical);
    }

    public Cursor leftmostSide() {
        return this.at(0.0f, this.vertical);
    }

    public Cursor atBottom() {
        return this.at(this.horizontal, this.context.height - this.context.horizontalMargin);
    }

    public Cursor horizontallyAt(float newHorizontal) {
        return this.at(this.context.verticalMargin + newHorizontal, this.vertical);
    }

    public Cursor verticallyAt(float newVertical) {
        return this.at(this.horizontal, this.context.horizontalMargin + newVertical);
    }

    public List<Cursor> encloseAreaWith(Cursor other) {
        return Arrays.asList(this.at(this.horizontal, other.vertical), other, this.at(other.horizontal, this.vertical), this);
    }

    public String toString() {
        return "Cursor [horizontal=" + this.horizontal + ", vertical=" + this.vertical + "]";
    }

    public boolean below(Page pageFormat) {
        return this.vertical > pageFormat.height - pageFormat.horizontalMargin;
    }

    public static interface PositionBasedPDFOperation {
        public void applyAt(float var1, float var2) throws IOException;
    }

    public static class Offset {
        private final float vertically;
        private final float horizontally;

        public Offset(float horizontally, float vertically) {
            this.vertically = vertically;
            this.horizontally = horizontally;
        }

        public Offset plus(Offset other) {
            return new Offset(this.horizontally + other.horizontally, this.vertically + other.vertically);
        }

        public float vertically() {
            return this.vertically;
        }
    }
}

