/*
 * Decompiled with CFR 0.152.
 */
package com.schneide.werp.module.render.pdf;

import com.schneide.werp.domain.publishing.LineSection;
import com.schneide.werp.domain.publishing.Report;
import com.schneide.werp.domain.publishing.ReportEntry;
import com.schneide.werp.domain.publishing.ReportImage;
import com.schneide.werp.domain.publishing.ReportLine;
import com.schneide.werp.domain.publishing.ReportSection;
import com.schneide.werp.domain.publishing.ReportTable;
import com.schneide.werp.domain.publishing.SectionClosure;
import com.schneide.werp.module.render.pdf.ColumnLayout;
import com.schneide.werp.module.render.pdf.detail.Cursor;
import com.schneide.werp.module.render.pdf.detail.FontSpecification;
import com.schneide.werp.module.render.pdf.detail.PageCount;
import com.schneide.werp.module.render.pdf.engine.PDFBoxRenderEngine;
import com.schneide.werp.module.render.pdf.engine.RenderEngine;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.imgscalr.Scalr;

public final class RenderAsPDF {
    private final OutputStream target;

    private RenderAsPDF(OutputStream target) {
        this.target = target;
    }

    public static RenderAsPDF to(OutputStream target) {
        return new RenderAsPDF(target);
    }

    public PageCount given(Report report) throws IOException {
        System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
        try (PDDocument document = new PDDocument();){
            PDFBoxRenderEngine rendering = new PDFBoxRenderEngine(report.format(), document);
            report.logo().ifPresent(rl -> rendering.stampWith(new RenderedLogo(this, rl.asImage(), rl.skalierung().getAsFactor())));
            report.qrCode().ifPresent(qr -> rendering.stampWith(new RenderedQRCode(this, qr.asImage(), qr.skalierung().getAsFactor())));
            rendering.start();
            this.render(report, rendering);
            rendering.stop(report.isMitSeitenzahlen(), report.isMitDatum());
            PageCount result = new PageCount(document.getNumberOfPages());
            document.save(this.target);
            PageCount pageCount = result;
            return pageCount;
        }
    }

    private void render(Report report, RenderEngine pdf) throws IOException {
        Optional firstSection = report.sections().findFirst();
        if (!firstSection.isPresent()) {
            System.out.println("Leeren Bericht angefordert?");
            return;
        }
        this.setPageHeaderFor(report, pdf);
        for (ReportSection each : RenderAsPDF.of(report.sections())) {
            this.renderSection(each, pdf);
        }
    }

    private void setPageHeaderFor(Report report, RenderEngine pdf) {
        List repeatedHeaders = report.sections().filter(ReportSection::repeated).collect(Collectors.toList());
        pdf.changePageHeaderTo(render -> {
            for (ReportSection each : repeatedHeaders) {
                this.renderSection(each, render);
            }
        });
    }

    private void renderSection(ReportSection section, RenderEngine pdf) throws IOException {
        ArrayList<ReportLine> renderGroup = new ArrayList<ReportLine>();
        for (ReportEntry each : RenderAsPDF.of(section.entries())) {
            if (each instanceof ReportLine) {
                ReportLine line = (ReportLine)each;
                if (line.needsGrouping()) {
                    renderGroup.add(line);
                    continue;
                }
                List<OffsetProvider> previous = this.renderLineGroup(renderGroup, pdf);
                this.renderLines(Arrays.asList(line), Optional.of(previous), pdf);
                continue;
            }
            if (each instanceof ReportTable) {
                ReportTable table = (ReportTable)each;
                this.renderLineGroup(renderGroup, pdf);
                this.renderTable(table, pdf);
                continue;
            }
            if (each instanceof ReportImage) {
                ReportImage image = (ReportImage)each;
                this.renderLineGroup(renderGroup, pdf);
                this.renderImage(image, pdf);
                continue;
            }
            System.err.println("Unbekanntes PDF-Berichtelement: " + each.getClass().getSimpleName());
        }
        this.renderLineGroup(renderGroup, pdf);
        this.renderSectionClosureOf(section, pdf);
    }

    private List<OffsetProvider> renderLineGroup(List<ReportLine> renderGroup, RenderEngine pdf) throws IOException {
        List<OffsetProvider> result = this.renderLines(renderGroup, Optional.empty(), pdf);
        renderGroup.clear();
        return result;
    }

    private void renderSectionClosureOf(ReportSection section, RenderEngine pdf) throws IOException {
        if (SectionClosure.none == section.closure()) {
            return;
        }
        if (SectionClosure.line == section.closure()) {
            pdf.printHorizontalLine();
        }
        if (SectionClosure.boldLine == section.closure()) {
            pdf.printHorizontalLine();
        }
        if (SectionClosure.pageBreak == section.closure()) {
            pdf.feedPage();
        }
    }

    private void renderImage(ReportImage image, RenderEngine pdf) throws IOException {
        pdf.returnToLeft();
        pdf.feedLine(2.5f);
        pdf.feedPaper(2.0f * image.height());
        pdf.printImage(image.asImage());
        pdf.rewindPaper(5.0f);
        pdf.nothingOnPageBreak();
    }

    private void renderTable(ReportTable table, RenderEngine pdf) throws IOException {
        pdf.returnToLeft();
        pdf.feedLine(2.5f);
        FixedCellWidths columnWidths = new FixedCellWidths(this);
        for (ReportTable.Cell each : table.titles()) {
            columnWidths.add(this.renderCell(each, ReportTable.ColumnAlignment.left, pdf, text -> pdf.widthOf(text) + 6.0f));
        }
        pdf.onPageBreak(render -> {
            pdf.returnToLeft();
            pdf.feedLine(2.5f);
            for (ReportTable.Cell each : table.titles()) {
                this.renderCell(each, ReportTable.ColumnAlignment.left, pdf, text -> pdf.widthOf(text) + 6.0f);
            }
            pdf.returnToLeft();
            pdf.feedLine();
        });
        for (List row : table.content()) {
            pdf.returnToLeft();
            pdf.feedLine();
            Iterator alignments = table.alignments().iterator();
            for (ReportTable.Cell each : row) {
                this.renderCell(each, (ReportTable.ColumnAlignment)alignments.next(), pdf, columnWidths);
            }
        }
        pdf.nothingOnPageBreak();
        pdf.feedLine(1.5f);
    }

    private float renderCell(ReportTable.Cell cell, ReportTable.ColumnAlignment alignment, RenderEngine pdf, CellWidthSupplier cellWidth) throws IOException {
        this.triggerPageBreakIfNecessary(pdf);
        Cursor topLeft = pdf.currentPosition();
        float totalCellWidth = cellWidth.widthOf(cell.text());
        Cursor bottomRight = topLeft.right(totalCellWidth).down(pdf.lineSpacing());
        pdf.printBoxFrom(topLeft, bottomRight);
        pdf.relativeTo(bottomRight.left(totalCellWidth).right(3.0f).up(pdf.lineSpacing()).up(pdf.lineSpacing()).up(2.0f));
        float textWidth = pdf.widthOf(cell.text(), FontSpecification.from(cell.style()));
        if (ReportTable.ColumnAlignment.right == alignment) {
            pdf.relativeTo(pdf.currentPosition().right(totalCellWidth - 6.0f - textWidth));
        }
        if (ReportTable.ColumnAlignment.centered == alignment) {
            pdf.relativeTo(pdf.currentPosition().right((totalCellWidth - 6.0f) / 2.0f - 0.5f * textWidth));
        }
        FontSpecification.from(cell.style()).applyTo(pdf);
        pdf.printText(cell.text(), 1.0);
        pdf.relativeTo(topLeft.right(totalCellWidth));
        return totalCellWidth;
    }

    private void triggerPageBreakIfNecessary(RenderEngine pdf) throws IOException {
        Cursor bottomLine = pdf.currentPosition().down(pdf.lineSpacing());
        if (pdf.wouldTriggerPageBreak(bottomLine)) {
            pdf.feedPage();
        }
    }

    private List<OffsetProvider> renderLines(List<ReportLine> lines, Optional<List<OffsetProvider>> previousFit, RenderEngine pdf) throws IOException {
        if (lines.isEmpty()) {
            return Collections.emptyList();
        }
        List multilinesExpanded = lines.stream().flatMap(ReportLine::expanded).collect(Collectors.toList());
        pdf.returnToLeft();
        ArrayList<List<LineSection>> content = new ArrayList<List<LineSection>>();
        boolean orientedAtPrevious = true;
        for (ReportLine each : multilinesExpanded) {
            if (!each.wantsToFitToPreviousGrouping()) {
                orientedAtPrevious = false;
            }
            List list = RenderAsPDF.of(each.sections());
            content.add(list);
        }
        List<OffsetProvider> horizontalColumnOffsets = orientedAtPrevious && previousFit.isPresent() ? previousFit.get() : new ColumnLayout().columnize(pdf, content);
        for (List list : content) {
            int columnIndex = 0;
            float verticalOffset = 0.0f;
            for (LineSection each : list) {
                FontSpecification.from(each.style()).applyTo(pdf);
                float horizontalPosition = horizontalColumnOffsets.size() > columnIndex ? horizontalColumnOffsets.get(columnIndex).offsetFor(each) : 0.0f;
                pdf.relativeTo(pdf.currentPosition().horizontallyAt(horizontalPosition));
                Cursor.Offset offset = pdf.printText(each.text(), each.lineHeight());
                verticalOffset = Math.max(verticalOffset, offset.vertically());
                pdf.rewindPaper(offset.vertically());
                ++columnIndex;
            }
            pdf.feedPaper(verticalOffset);
        }
        return horizontalColumnOffsets;
    }

    private static <T> List<T> of(Stream<T> stream) {
        return stream.collect(Collectors.toList());
    }

    private class FixedCellWidths
    implements CellWidthSupplier {
        private final List<Float> columnWidths = new ArrayList<Float>();
        private volatile int currentIndex = 0;

        public FixedCellWidths(RenderAsPDF renderAsPDF) {
        }

        public void add(float fixedWidth) {
            this.columnWidths.add(Float.valueOf(fixedWidth));
        }

        @Override
        public float widthOf(String cellWithText) {
            float result = this.columnWidths.get(this.currentIndex).floatValue();
            this.currentIndex = (this.currentIndex + 1) % this.columnWidths.size();
            return result;
        }
    }

    private static interface CellWidthSupplier {
        public float widthOf(String var1) throws IOException;
    }

    public static interface OffsetProvider {
        public float offsetFor(LineSection var1) throws IOException;
    }

    private class RenderedQRCode
    extends RenderedImage {
        private static final float horizontalOffsetFactor = 6.5f;
        private static final float verticalOffset = -0.1f;

        public RenderedQRCode(RenderAsPDF renderAsPDF, BufferedImage image, double scalingFactor) {
            super(renderAsPDF, image, scalingFactor);
        }

        @Override
        protected RenderedImage.Offset offset() {
            return new RenderedImage.Offset(6.5f, -0.1f);
        }
    }

    private class RenderedLogo
    extends RenderedImage {
        private static final float horizontalOffsetFactor = 6.5f;
        private static final float verticalOffset = 15.0f;

        public RenderedLogo(RenderAsPDF renderAsPDF, BufferedImage image, double scalingFactor) {
            super(renderAsPDF, image, scalingFactor);
        }

        @Override
        protected RenderedImage.Offset offset() {
            return new RenderedImage.Offset(6.5f, 15.0f);
        }
    }

    private abstract class RenderedImage
    implements PDFBoxRenderEngine.ReportContent {
        private final BufferedImage scaledLogo;

        public RenderedImage(RenderAsPDF renderAsPDF, BufferedImage image, double scalingFactor) {
            this.scaledLogo = this.scaleTo(image, scalingFactor);
        }

        @Override
        public void addTo(RenderEngine rendering) throws IOException {
            Offset offset = this.offset();
            float rightAligned = rendering.fromRight((float)this.scaledLogo.getWidth() / offset.horizontalFromRight());
            float verticalDistance = offset.vertically();
            Cursor current = rendering.currentPosition();
            if (verticalDistance < 0.0f) {
                current = current.atBottom();
            }
            rendering.relativeTo(current.down(offset.vertically()).right(rightAligned));
            rendering.printImage(this.scaledLogo, 0.5f);
        }

        protected abstract Offset offset();

        private BufferedImage scaleTo(BufferedImage original, double scalingFactor) {
            int newWidth = (int)((double)original.getWidth() * scalingFactor);
            int newHeight = (int)((double)original.getHeight() * scalingFactor);
            return Scalr.resize((BufferedImage)original, (Scalr.Method)Scalr.Method.QUALITY, (int)newWidth, (int)newHeight, (BufferedImageOp[])new BufferedImageOp[0]);
        }

        protected record Offset(float horizontalFromRight, float vertically) {
        }
    }
}

