/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.xcsv;

import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.ConstList;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XImmutableSequence;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.xcsv.XCsvRowAssembler;

public interface XCsvEntityAssembler<T>
extends XCsvRowAssembler<T> {
    public XImmutableSequence<String> columnHeader();

    public VarString createCollector(int var1);

    default public VarString assemble(XGettingCollection<T> entities) {
        return this.assembleInto(this.createCollector(XTypes.to_int(entities.size())), this.columnHeader(), entities);
    }

    public VarString assembleInto(VarString var1, XGettingSequence<String> var2, XGettingCollection<T> var3);

    default public VarString assembleInto(VarString vs, XGettingCollection<T> entities) {
        this.assembleInto(vs, this.columnHeader(), entities);
        return vs;
    }

    public static abstract class Abstract<T>
    implements XCsvEntityAssembler<T> {
        private static final int DEFAULT_ROW_COUNT_ESTIAMTE = 100;
        private final XImmutableSequence<String> columnHeader;
        private final int rowCharCountEstimate;

        protected Abstract(XGettingSequence<String> columnHeader) {
            this(columnHeader, 100);
        }

        protected Abstract(XGettingSequence<String> columnHeader, int rowCharCountEstimate) {
            this.columnHeader = columnHeader.immure();
            this.rowCharCountEstimate = rowCharCountEstimate;
        }

        protected Abstract(String ... columnHeader) {
            this(ConstList.New(columnHeader));
        }

        protected Abstract(int rowCharCountEstimate, String ... columnHeader) {
            this(ConstList.New(columnHeader), rowCharCountEstimate);
        }

        @Override
        public final XImmutableSequence<String> columnHeader() {
            return this.columnHeader;
        }

        @Override
        public VarString createCollector(int entityCount) {
            return VarString.New(entityCount * this.rowCharCountEstimate);
        }

        @Override
        public abstract VarString assembleInto(VarString var1, XGettingSequence<String> var2, XGettingCollection<T> var3);
    }
}

