/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.xcsv;

import org.eclipse.serializer.chars.EscapeHandler;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.typing.Immutable;
import org.eclipse.serializer.util.InstanceDispatcher;
import org.eclipse.serializer.util.xcsv.XCSV;

public interface XCsvConfiguration {
    public char valueSeparator();

    public char lineSeparator();

    public char literalDelimiter();

    public char escaper();

    public char terminator();

    public char segmentStarter();

    public char segmentTerminator();

    public char headerStarter();

    public char headerTerminator();

    public char commentSignal();

    public char commentSimpleStarter();

    public char commentFullStarter();

    public String commentFullTerminator();

    public int skipLineCount();

    public int postColumnHeaderSkipLineCount();

    public int trailingLineCount();

    public EscapeHandler escapeHandler();

    public EscapeHandler valueEscapeHandler();

    public String valueSeparator(String var1, String var2);

    public String lineSeparator(String var1, String var2);

    public String buildControlCharactersDefinition(char var1);

    public boolean isControlCharacter(char var1);

    default public char[] commentFullTerminatorArray() {
        return this.commentFullTerminator().toCharArray();
    }

    public Boolean hasColumnNamesHeader();

    public Boolean hasColumnTypesHeader();

    public Boolean hasControlCharacterDefinitionHeader();

    public static XCsvConfiguration New() {
        return XCsvConfiguration.Builder().buildConfiguration();
    }

    public static XCsvConfiguration New(char valueSeparator) {
        return XCsvConfiguration.Builder(valueSeparator).buildConfiguration();
    }

    public static Builder Builder(char valueSeparator) {
        return XCsvConfiguration.Builder().setValueSeparator(valueSeparator);
    }

    public static Builder Builder() {
        return new Builder.Default();
    }

    public static interface Builder
    extends InstanceDispatcher {
        public char getLineSeparator();

        public char getTerminator();

        public char getValueSeparator();

        public char getValueDelimiter();

        public char getValueEscaper();

        public char getSegmentStarter();

        public char getSegmentTerminator();

        public char getHeaderStarter();

        public char getHeaderTerminator();

        public char getCommentSignal();

        public char getCommentSimpleStarter();

        public char getCommentFullStarter();

        public String getCommentFullTerminator();

        public int getSkipLineCount();

        public int getSkipLineCountPostHeader();

        public int getTrailingLineCount();

        public Boolean hasColumnNamesHeader();

        public Boolean hasColumnTypesHeader();

        public Boolean hasControlCharacterDefinitionHeader();

        public EscapeHandler getEscapeHandler();

        public Builder setLineSeparator(char var1);

        public Builder setTerminator(char var1);

        public Builder setValueSeparator(char var1);

        public Builder setLiteralDelimiter(char var1);

        public Builder setEscaper(char var1);

        public Builder setSegmentStarter(char var1);

        public Builder setSegmentTerminator(char var1);

        public Builder setHeaderStarter(char var1);

        public Builder setHeaderTerminator(char var1);

        public Builder setCommentSignal(char var1);

        public Builder setCommentSimpleStarter(char var1);

        public Builder setCommentFullStarter(char var1);

        public Builder setCommentFullTerminator(String var1);

        public Builder setSkipLineCount(int var1);

        public Builder setPostColumnHeaderSkipLineCount(int var1);

        public Builder setTrailingLineCount(int var1);

        public Builder setHasColumnNamesHeader(Boolean var1);

        public Builder setHasColumnTypesHeader(Boolean var1);

        public Builder setHasControlCharacterDefinitionHeader(Boolean var1);

        public Builder setEscapeHandler(EscapeHandler var1);

        public Builder copyFrom(XCsvConfiguration var1);

        public XCsvConfiguration buildConfiguration();

        public static final class Default
        extends InstanceDispatcher.Default
        implements Builder {
            private char lineSeparator = (char)10;
            private char terminator = '\u0000';
            private char valueSeparator = (char)9;
            private char valueDelimiter = (char)34;
            private char valueEscaper = (char)92;
            private char segmentStarter = (char)123;
            private char segmentTerminator = (char)125;
            private char headerStarter = (char)40;
            private char headerTerminator = (char)41;
            private char commentSignal = (char)47;
            private char commentSimpleStarter = (char)47;
            private char commentFullStarter = (char)42;
            private String commentFullTerminator = "*/";
            private int skipLineCount = 0;
            private int skipLineCountPostHeader = 0;
            private int trailingLineCount = 0;
            private Boolean hasColumnNamesHeader = XCSV.DEFAULT_HAS_COLUMN_NAMES_HEADER;
            private Boolean hasColumnTypesHeader = XCSV.DEFAULT_HAS_COLUMN_TYPES_HEADER;
            private Boolean hasCtrlCharDefHeader = XCSV.DEFAULT_HAS_CTRLCHAR_DEF_HEADER;
            private EscapeHandler escapeHandler = XCSV.DEFAULT_ESCAPE_HANDLER;

            Default() {
            }

            @Override
            public char getLineSeparator() {
                return this.lineSeparator;
            }

            @Override
            public char getTerminator() {
                return this.terminator;
            }

            @Override
            public char getValueSeparator() {
                return this.valueSeparator;
            }

            @Override
            public char getValueDelimiter() {
                return this.valueDelimiter;
            }

            @Override
            public char getValueEscaper() {
                return this.valueEscaper;
            }

            @Override
            public char getSegmentStarter() {
                return this.segmentStarter;
            }

            @Override
            public char getSegmentTerminator() {
                return this.segmentTerminator;
            }

            @Override
            public char getHeaderStarter() {
                return this.headerStarter;
            }

            @Override
            public char getHeaderTerminator() {
                return this.headerTerminator;
            }

            @Override
            public char getCommentSignal() {
                return this.commentSignal;
            }

            @Override
            public char getCommentSimpleStarter() {
                return this.commentSimpleStarter;
            }

            @Override
            public char getCommentFullStarter() {
                return this.commentFullStarter;
            }

            @Override
            public String getCommentFullTerminator() {
                return this.commentFullTerminator;
            }

            @Override
            public int getSkipLineCount() {
                return this.skipLineCount;
            }

            @Override
            public int getSkipLineCountPostHeader() {
                return this.skipLineCountPostHeader;
            }

            @Override
            public int getTrailingLineCount() {
                return this.trailingLineCount;
            }

            @Override
            public final Boolean hasColumnNamesHeader() {
                return this.hasColumnNamesHeader;
            }

            @Override
            public final Boolean hasColumnTypesHeader() {
                return this.hasColumnTypesHeader;
            }

            @Override
            public final Boolean hasControlCharacterDefinitionHeader() {
                return this.hasCtrlCharDefHeader;
            }

            @Override
            public EscapeHandler getEscapeHandler() {
                return this.escapeHandler;
            }

            @Override
            public Default setLineSeparator(char lineSeparator) {
                this.lineSeparator = lineSeparator;
                return this;
            }

            @Override
            public Default setTerminator(char terminator) {
                this.terminator = terminator;
                return this;
            }

            @Override
            public Default setValueSeparator(char valueSeparator) {
                XCSV.validateValueSeparator(valueSeparator);
                this.valueSeparator = valueSeparator;
                return this;
            }

            @Override
            public Default setLiteralDelimiter(char valueDelimiter) {
                this.valueDelimiter = valueDelimiter;
                return this;
            }

            @Override
            public Default setEscaper(char valueEscaper) {
                this.valueEscaper = valueEscaper;
                return this;
            }

            @Override
            public Default setSegmentStarter(char segmentStarter) {
                this.segmentStarter = segmentStarter;
                return this;
            }

            @Override
            public Default setSegmentTerminator(char segmentTerminator) {
                this.segmentTerminator = segmentTerminator;
                return this;
            }

            @Override
            public Default setHeaderStarter(char headerStarter) {
                this.headerStarter = headerStarter;
                return this;
            }

            @Override
            public Default setHeaderTerminator(char headerTerminator) {
                this.headerTerminator = headerTerminator;
                return this;
            }

            @Override
            public Default setCommentSignal(char commentSignal) {
                this.commentSignal = commentSignal;
                return this;
            }

            @Override
            public Default setCommentSimpleStarter(char commentSimpleStarter) {
                this.commentSimpleStarter = commentSimpleStarter;
                return this;
            }

            @Override
            public Default setCommentFullStarter(char commentFullStarter) {
                this.commentFullStarter = commentFullStarter;
                return this;
            }

            @Override
            public Default setCommentFullTerminator(String commentFullTerminator) {
                this.commentFullTerminator = commentFullTerminator;
                return this;
            }

            @Override
            public Default setSkipLineCount(int skipLineCount) {
                this.skipLineCount = skipLineCount;
                return this;
            }

            @Override
            public Default setPostColumnHeaderSkipLineCount(int skipLineCountPostHeader) {
                this.skipLineCountPostHeader = skipLineCountPostHeader;
                return this;
            }

            @Override
            public Builder setTrailingLineCount(int trailingLineCount) {
                this.trailingLineCount = trailingLineCount;
                return this;
            }

            @Override
            public Builder setHasColumnNamesHeader(Boolean hasColumnNamesHeader) {
                this.hasColumnNamesHeader = hasColumnNamesHeader;
                return this;
            }

            @Override
            public Builder setHasColumnTypesHeader(Boolean hasColumnTypesHeader) {
                this.hasColumnTypesHeader = hasColumnTypesHeader;
                return this;
            }

            @Override
            public Builder setHasControlCharacterDefinitionHeader(Boolean hasControlCharacterDefinitionHeader) {
                this.hasCtrlCharDefHeader = hasControlCharacterDefinitionHeader;
                return this;
            }

            @Override
            public Default setEscapeHandler(EscapeHandler escapeHandler) {
                this.escapeHandler = escapeHandler;
                return this;
            }

            @Override
            public Builder copyFrom(XCsvConfiguration configuration) {
                this.setLineSeparator(configuration.lineSeparator()).setTerminator(configuration.terminator()).setValueSeparator(configuration.valueSeparator()).setLiteralDelimiter(configuration.literalDelimiter()).setEscaper(configuration.escaper()).setSegmentStarter(configuration.segmentStarter()).setSegmentTerminator(configuration.segmentTerminator()).setHeaderStarter(configuration.headerStarter()).setHeaderTerminator(configuration.headerTerminator()).setCommentSignal(configuration.commentSignal()).setCommentSimpleStarter(configuration.commentSimpleStarter()).setCommentFullStarter(configuration.commentFullStarter()).setCommentFullTerminator(configuration.commentFullTerminator()).setSkipLineCount(configuration.skipLineCount()).setPostColumnHeaderSkipLineCount(configuration.postColumnHeaderSkipLineCount()).setTrailingLineCount(configuration.trailingLineCount()).setEscapeHandler(configuration.escapeHandler());
                return this;
            }

            @Override
            public XCsvConfiguration buildConfiguration() {
                return new org.eclipse.serializer.util.xcsv.XCsvConfiguration$Default(this.getLineSeparator(), this.getTerminator(), this.getValueSeparator(), this.getValueDelimiter(), this.getValueEscaper(), this.getSegmentStarter(), this.getSegmentTerminator(), this.getHeaderStarter(), this.getHeaderTerminator(), this.getCommentSignal(), this.getCommentSimpleStarter(), this.getCommentFullStarter(), this.getCommentFullTerminator(), this.getSkipLineCount(), this.getSkipLineCountPostHeader(), this.getTrailingLineCount(), this.hasColumnNamesHeader(), this.hasColumnTypesHeader(), this.hasControlCharacterDefinitionHeader(), this.getEscapeHandler());
            }
        }
    }

    public static final class Default
    implements XCsvConfiguration,
    Immutable {
        private final char lineSeparator;
        private final char terminator;
        private final char valueSeparator;
        private final char literalDelimiter;
        private final char valueEscaper;
        private final char segmentStarter;
        private final char segmentTerminator;
        private final char headerStarter;
        private final char headerTerminator;
        private final char commentSignal;
        private final char commentSimpleStarter;
        private final char commentFullStarter;
        private final String commentFullTerminator;
        private final int skipLineCount;
        private final int skipLineCountPostHeader;
        private final int trailingLineCount;
        private final Boolean hasColumnNamesHeader;
        private final Boolean hasColumnTypesHeader;
        private final Boolean hasMetaCharDefHeader;
        private final EscapeHandler contentEscapeHandler;
        private final EscapeHandler valueEscapeHandler;
        private transient char[] commentFullTerminatorArray;

        Default(char lineSeparator, char terminator, char valueSeparator, char literalDelimiter, char valueEscaper, char segmentStarter, char segmentTerminator, char headerStarter, char headerTerminator, char commentSignal, char commentSimpleStarter, char commentFullStarter, String commentFullTerminator, int skipLineCount, int skipLineCountPostHeader, int trailingLineCount, Boolean hasColumnNamesHeader, Boolean hasColumnTypesHeader, Boolean hasMetaCharDefHeader, EscapeHandler contentEscapeHandler) {
            this.lineSeparator = lineSeparator;
            this.terminator = terminator;
            this.valueSeparator = valueSeparator;
            this.literalDelimiter = literalDelimiter;
            this.valueEscaper = valueEscaper;
            this.segmentStarter = segmentStarter;
            this.segmentTerminator = segmentTerminator;
            this.headerStarter = headerStarter;
            this.headerTerminator = headerTerminator;
            this.commentSignal = commentSignal;
            this.commentSimpleStarter = commentSimpleStarter;
            this.commentFullStarter = commentFullStarter;
            this.commentFullTerminator = commentFullTerminator;
            this.skipLineCount = skipLineCount;
            this.skipLineCountPostHeader = skipLineCountPostHeader;
            this.trailingLineCount = trailingLineCount;
            this.contentEscapeHandler = contentEscapeHandler;
            this.hasColumnNamesHeader = hasColumnNamesHeader;
            this.hasColumnTypesHeader = hasColumnTypesHeader;
            this.hasMetaCharDefHeader = hasMetaCharDefHeader;
            this.valueEscapeHandler = new ValueEscapeHandler(contentEscapeHandler, literalDelimiter, valueEscaper);
        }

        @Override
        public final char[] commentFullTerminatorArray() {
            if (this.commentFullTerminatorArray == null) {
                this.commentFullTerminatorArray = this.commentFullTerminator().toCharArray();
            }
            return this.commentFullTerminatorArray;
        }

        @Override
        public final char lineSeparator() {
            return this.lineSeparator;
        }

        @Override
        public final char terminator() {
            return this.terminator;
        }

        @Override
        public final char segmentStarter() {
            return this.segmentStarter;
        }

        @Override
        public final char segmentTerminator() {
            return this.segmentTerminator;
        }

        @Override
        public final char headerStarter() {
            return this.headerStarter;
        }

        @Override
        public final char headerTerminator() {
            return this.headerTerminator;
        }

        @Override
        public final char commentSignal() {
            return this.commentSignal;
        }

        @Override
        public final char commentSimpleStarter() {
            return this.commentSimpleStarter;
        }

        @Override
        public final char commentFullStarter() {
            return this.commentFullStarter;
        }

        @Override
        public final String commentFullTerminator() {
            return this.commentFullTerminator;
        }

        @Override
        public final char valueSeparator() {
            return this.valueSeparator;
        }

        @Override
        public final char literalDelimiter() {
            return this.literalDelimiter;
        }

        @Override
        public final char escaper() {
            return this.valueEscaper;
        }

        @Override
        public final int skipLineCount() {
            return this.skipLineCount;
        }

        @Override
        public final int postColumnHeaderSkipLineCount() {
            return this.skipLineCountPostHeader;
        }

        @Override
        public final int trailingLineCount() {
            return this.trailingLineCount;
        }

        @Override
        public final EscapeHandler escapeHandler() {
            return this.contentEscapeHandler;
        }

        @Override
        public final EscapeHandler valueEscapeHandler() {
            return this.valueEscapeHandler;
        }

        @Override
        public final Boolean hasColumnNamesHeader() {
            return this.hasColumnNamesHeader;
        }

        @Override
        public final Boolean hasColumnTypesHeader() {
            return this.hasColumnTypesHeader;
        }

        @Override
        public final Boolean hasControlCharacterDefinitionHeader() {
            return this.hasMetaCharDefHeader;
        }

        @Override
        public final String valueSeparator(String prefix, String suffix) {
            return String.valueOf(prefix != null ? prefix : "") + this.valueSeparator() + (suffix != null ? suffix : "");
        }

        @Override
        public final String lineSeparator(String prefix, String suffix) {
            return String.valueOf(prefix != null ? prefix : "") + this.lineSeparator() + (suffix != null ? suffix : "");
        }

        @Override
        public final String buildControlCharactersDefinition(char separator) {
            VarString vs = VarString.New(32);
            EscapeHandler escapeHandler = this.escapeHandler();
            vs.add(separator).add(this.escaper());
            vs.add(separator).add(this.literalDelimiter());
            this.addControlCharacter(vs.add(separator), escapeHandler, this.valueSeparator());
            this.addControlCharacter(vs.add(separator), escapeHandler, this.lineSeparator());
            vs.add(separator).add(this.segmentStarter()).add(separator).add(this.segmentTerminator()).add(separator).add(this.headerStarter()).add(separator).add(this.headerTerminator()).add(separator).add(this.commentSignal()).add(separator).add(this.commentSimpleStarter()).add(separator).add(this.commentFullStarter()).add(separator).add(this.commentFullTerminator());
            return vs.toString();
        }

        private void addControlCharacter(VarString vs, EscapeHandler escapeHandler, char controlCharacter) {
            if (escapeHandler.needsEscaping(controlCharacter)) {
                vs.add(this.escaper()).add(escapeHandler.transformEscapedChar(controlCharacter));
            } else {
                vs.add(controlCharacter);
            }
        }

        @Override
        public final boolean isControlCharacter(char c) {
            return c == this.escaper() || c == this.literalDelimiter() || c == this.valueSeparator() || c == this.lineSeparator() || c == this.segmentStarter() || c == this.segmentTerminator() || c == this.headerStarter() || c == this.headerTerminator() || c == this.commentSignal() || c == this.commentSimpleStarter() || c == this.commentFullStarter();
        }

        static final class ValueEscapeHandler
        implements EscapeHandler {
            private final EscapeHandler contentEscapeHandler;
            private final char delimiter;
            private final char escaper;

            public ValueEscapeHandler(EscapeHandler contentEscapeHandler, char delimiter, char escaper) {
                this.contentEscapeHandler = contentEscapeHandler;
                this.delimiter = delimiter;
                this.escaper = escaper;
            }

            @Override
            public final void handleEscapedChar(char escapedChar, VarString literalBuilder) {
                this.contentEscapeHandler.handleEscapedChar(escapedChar, literalBuilder);
            }

            @Override
            public final boolean needsEscaping(char chr) {
                return chr == this.delimiter || chr == this.escaper || this.contentEscapeHandler.needsEscaping(chr);
            }

            @Override
            public final char transformEscapedChar(char chr) {
                return this.contentEscapeHandler.transformEscapedChar(chr);
            }

            @Override
            public final char unescape(char chr) {
                return this.contentEscapeHandler.unescape(chr);
            }
        }
    }
}

