/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.xcsv;

import java.nio.file.Path;
import java.util.Arrays;
import org.eclipse.serializer.chars.EscapeHandler;
import org.eclipse.serializer.chars.StringTable;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.chars._charArrayRange;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XIterable;
import org.eclipse.serializer.exceptions.XCsvException;
import org.eclipse.serializer.io.XIO;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.xcsv.XCsvAssembler;
import org.eclipse.serializer.util.xcsv.XCsvConfiguration;
import org.eclipse.serializer.util.xcsv.XCsvContent;
import org.eclipse.serializer.util.xcsv.XCsvContentBuilderCharArray;
import org.eclipse.serializer.util.xcsv.XCsvDataType;
import org.eclipse.serializer.util.xcsv.XCsvRowAssembler;

public final class XCSV {
    static final char DEFAULT_LINE_SEPERATOR = '\n';
    static final char DEFAULT_SEPERATOR = '\t';
    static final char DEFAULT_DELIMITER = '\"';
    static final char DEFAULT_ESCAPER = '\\';
    static final char DEFAULT_SEGMENT_STARTER = '{';
    static final char DEFAULT_SEGMENT_TERMINATOR = '}';
    static final char DEFAULT_HEADER_STARTER = '(';
    static final char DEFAULT_HEADER_TERMINATOR = ')';
    static final char DEFAULT_COMMENT_SIGNAL = '/';
    static final char DEFAULT_COMMENT_SIMPLE_STARTER = '/';
    static final char DEFAULT_COMMENT_FULL_STARTER = '*';
    static final String DEFAULT_COMMENT_FULL_TERMINATOR = "*/";
    static final char DEFAULT_TERMINATOR = '\u0000';
    static final int DEFAULT_SKIP_LINE_COUNT = 0;
    static final int DEFAULT_SKIP_LINE_COUNT_POST_HEADER = 0;
    static final int DEFAULT_TRAILING_LINE_COUNT = 0;
    static final Boolean DEFAULT_HAS_COLUMN_NAMES_HEADER = null;
    static final Boolean DEFAULT_HAS_COLUMN_TYPES_HEADER = null;
    static final Boolean DEFAULT_HAS_CTRLCHAR_DEF_HEADER = null;
    static final EscapeHandler DEFAULT_ESCAPE_HANDLER = new EscapeHandler.Default();
    static final char[] VALID_VALUE_SEPARATORS = new char[]{'\t', ';', ',', '|', ':'};

    public static ValueSeparatorWeight ValueSeparatorWeight(char valueSeparator, double weight) {
        return new ValueSeparatorWeight.Default(XCSV.validateValueSeparator(valueSeparator), (float)weight);
    }

    public static char[] getValidValueSeparators() {
        return (char[])VALID_VALUE_SEPARATORS.clone();
    }

    public static XCsvConfiguration configurationDefault() {
        return XCsvDataType.XCSV.configuration();
    }

    public static XCsvConfiguration.Builder ConfigurationBuilder() {
        return new XCsvConfiguration.Builder.Default();
    }

    public static XCsvAssembler.Builder<VarString> AssemblerBuilder() {
        return XCsvAssembler.Builder();
    }

    public static boolean isValidValueSeparator(char c) {
        return XChars.contains(VALID_VALUE_SEPARATORS, c);
    }

    public static char validateValueSeparator(char c) {
        if (XCSV.isValidValueSeparator(c)) {
            return c;
        }
        throw new XCsvException("Invalid " + XCSV.class.getSimpleName() + " value separator '" + c + "'. Valid separators are " + Arrays.toString(VALID_VALUE_SEPARATORS));
    }

    public static <T> void assembleRow(XCsvAssembler assembler, XCsvRowAssembler<T> rowAssembler, XIterable<? extends T> row) {
        row.iterate(e -> rowAssembler.accept(e, assembler));
        assembler.completeRow();
    }

    public static <T> void assembleRows(XCsvAssembler assembler, XCsvRowAssembler<T> rowAssembler, XIterable<? extends T> rows) {
        rows.iterate(e -> {
            rowAssembler.accept(e, assembler);
            assembler.completeRow();
        });
        assembler.completeRows();
    }

    public static StringTable parse(String rawData) {
        return XCSV.parse(rawData, null, null);
    }

    public static StringTable parse(String rawData, char valueSeparator) {
        return XCSV.parse(rawData, XCsvConfiguration.New(valueSeparator), null);
    }

    public static StringTable parse(String rawData, XCsvDataType dataType) {
        return XCSV.parse(rawData, null, dataType);
    }

    public static StringTable parse(String rawData, XCsvConfiguration configuration) {
        return XCSV.parse(rawData, configuration, null);
    }

    public static StringTable parse(String rawData, XCsvConfiguration configuration, XCsvDataType dataType) {
        return XCSV.parse(_charArrayRange.New(XChars.readChars(rawData)), configuration, dataType);
    }

    public static String assembleString(StringTable stringTable) {
        return XCSV.assembleString(stringTable, null);
    }

    public static String assembleString(StringTable stringTable, XCsvConfiguration configuration) {
        VarString vs = VarString.New(XCSV.calculateEstimatedCharCount(stringTable.rows().size()));
        XCSV.assembleString(vs, stringTable, configuration);
        return vs.toString();
    }

    public static StringTable parse(_charArrayRange rawData) {
        return XCSV.parse(rawData, null, null);
    }

    public static StringTable parse(_charArrayRange rawData, XCsvDataType dataType) {
        return XCSV.parse(rawData, null, dataType);
    }

    public static StringTable parse(_charArrayRange rawData, char valueSeparator) {
        return XCSV.parse(rawData, XCsvConfiguration.New(valueSeparator));
    }

    public static StringTable parse(_charArrayRange rawData, XCsvConfiguration csvConfiguration) {
        return XCSV.parse(rawData, csvConfiguration, null);
    }

    public static StringTable parse(_charArrayRange rawData, XCsvConfiguration csvConfiguration, XCsvDataType dataType) {
        XCsvContentBuilderCharArray parser = XCsvContentBuilderCharArray.New(csvConfiguration, dataType);
        XCsvContent content = parser.build((String)null, rawData);
        StringTable data = content.segments().first().value();
        return data;
    }

    public static int estimatedCharCountPerRow() {
        return 100;
    }

    public static int calculateEstimatedCharCount(long rowCount) {
        long estimate = rowCount * (long)XCSV.estimatedCharCountPerRow();
        return estimate >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)estimate;
    }

    public static VarString assembleString(VarString vs, StringTable st) {
        return XCSV.assembleString(vs, st, null);
    }

    public static VarString assembleString(VarString vs, StringTable st, XCsvConfiguration csvConfiguration) {
        if (st.columnNames().isEmpty()) {
            return vs;
        }
        XCsvConfiguration effConfig = XCSV.ensureCsvConfiguration(csvConfiguration);
        char valueSeparator = effConfig.valueSeparator();
        char lineSeparator = effConfig.lineSeparator();
        int vsLength = vs.length();
        if (X.isTrue(effConfig.hasControlCharacterDefinitionHeader())) {
            vs.add(effConfig.buildControlCharactersDefinition(';')).add(lineSeparator);
        }
        if (X.isNotFalse(effConfig.hasColumnNamesHeader())) {
            XCSV.assemble(vs, valueSeparator, st.columnNames()).add(lineSeparator);
        }
        if (X.isNotFalse(effConfig.hasColumnTypesHeader()) && !st.columnTypes().isEmpty()) {
            vs.add(effConfig.headerStarter());
            XCSV.assemble(vs, valueSeparator, st.columnTypes());
            vs.add(effConfig.headerTerminator()).add(lineSeparator);
        }
        if (!st.rows().isEmpty()) {
            for (String[] row : st.rows()) {
                XCSV.assemble(vs, valueSeparator, row);
                vs.add(lineSeparator);
            }
        }
        if (vs.length() != vsLength) {
            vs.deleteLast();
        }
        return vs;
    }

    private static void assemble(VarString vs, char separator, String[] elements) {
        if (elements.length == 0) {
            return;
        }
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            vs.add(s).add(separator);
            ++n2;
        }
        vs.deleteLast();
    }

    private static VarString assemble(VarString vs, char separator, XGettingCollection<String> elements) {
        if (elements.isEmpty()) {
            return vs;
        }
        for (String s : elements) {
            vs.add(s).add(separator);
        }
        vs.deleteLast();
        return vs;
    }

    private static XCsvConfiguration ensureCsvConfiguration(XCsvConfiguration csvConfiguration) {
        return csvConfiguration == null ? XCSV.configurationDefault() : csvConfiguration;
    }

    public static StringTable readFromFile(Path file) {
        String fileSuffix = XIO.getFileSuffix(file);
        String normalized = fileSuffix == null ? null : fileSuffix.trim().toLowerCase();
        XCsvDataType dataType = XCsvDataType.fromIdentifier(normalized);
        return XCSV.readFromFile(file, dataType);
    }

    public static StringTable readFromFile(Path file, XCsvDataType dataType) {
        String fileContent = XIO.unchecked(() -> XIO.readString(file));
        return XCSV.parse(fileContent, dataType);
    }

    public static StringTable readFromFile(Path file, char valueSeparator) {
        return XCSV.readFromFile(file, XCsvConfiguration.New(valueSeparator));
    }

    public static StringTable readFromFile(Path file, XCsvConfiguration xcsvConfiguration) {
        String fileContent = XIO.unchecked(() -> XIO.readString(file));
        return XCSV.parse(fileContent, xcsvConfiguration);
    }

    private XCSV() {
        throw new UnsupportedOperationException();
    }

    public static interface ValueSeparatorWeight {
        public char valueSeparator();

        public float weight();

        public static final class Default
        implements ValueSeparatorWeight {
            private final char valueSeparator;
            private final float weight;

            Default(char valueSeparator, float weight) {
                this.valueSeparator = valueSeparator;
                this.weight = weight;
            }

            @Override
            public char valueSeparator() {
                return this.valueSeparator;
            }

            @Override
            public float weight() {
                return this.weight;
            }
        }
    }
}

