/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.traversing;

import java.util.function.Predicate;
import org.eclipse.serializer.collections.HashEnum;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XGettingSet;

public abstract class AbstractHandlingPredicate
implements Predicate<Object> {
    private final Predicate<Object> customPredicate;
    private final HashEnum<Class<?>> positiveTypes;
    private final HashEnum<Class<?>> negativeTypes;
    private final XGettingSequence<Class<?>> typesPolymorphic;

    protected AbstractHandlingPredicate(Predicate<Object> customPredicate, XGettingSet<Class<?>> positiveTypes, XGettingSequence<Class<?>> typesPolymorphic) {
        this.customPredicate = customPredicate;
        this.positiveTypes = HashEnum.New(positiveTypes);
        this.negativeTypes = HashEnum.New();
        this.typesPolymorphic = typesPolymorphic;
    }

    @Override
    public final boolean test(Object instance) {
        if (this.customPredicate != null && this.customPredicate.test(instance)) {
            return true;
        }
        Class<?> type = instance.getClass();
        if (this.positiveTypes.contains(type)) {
            return true;
        }
        if (this.negativeTypes.contains(type)) {
            return false;
        }
        for (Class clazz : this.typesPolymorphic) {
            if (!clazz.isAssignableFrom(type)) continue;
            this.positiveTypes.add(type);
            return true;
        }
        this.negativeTypes.add(type);
        return false;
    }
}

