/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.similarity;

import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.chars.XChars;
import org.eclipse.serializer.util.similarity.MultiMatchAssembler;

public interface Similarity<E> {
    public E sourceElement();

    public double similarity();

    public E targetElement();

    public static <E> E sourceElement(Similarity<E> instance) {
        return instance != null ? (E)instance.sourceElement() : null;
    }

    public static Double similarity(Similarity<?> instance) {
        return instance != null ? Double.valueOf(instance.similarity()) : null;
    }

    public static double _similarity(Similarity<?> instance) {
        return instance != null ? instance.similarity() : Double.NaN;
    }

    public static <E> E targetElement(Similarity<E> instance) {
        return instance != null ? (E)instance.targetElement() : null;
    }

    public static <E> Similarity<E> New(E sourceElement, double similarity, E targetElement) {
        return new Default<E>(sourceElement, similarity, targetElement);
    }

    public static <E> Similarity<E>[] Array(int length) {
        return new Similarity[length];
    }

    public static class Default<E>
    implements Similarity<E> {
        private final E sourceElement;
        private final double similarity;
        private final E targetElement;

        protected Default(E sourceElement, double similarity, E targetElement) {
            this.sourceElement = sourceElement;
            this.similarity = similarity;
            this.targetElement = targetElement;
        }

        @Override
        public final E sourceElement() {
            return this.sourceElement;
        }

        @Override
        public final double similarity() {
            return this.similarity;
        }

        @Override
        public final E targetElement() {
            return this.targetElement;
        }

        public String toString() {
            VarString vs = VarString.New().add(this.sourceElement, XChars::assembleCautiously).add('<', '-').add(MultiMatchAssembler.Defaults.defaultSimilarityFormatter().format(this.similarity)).add('-', '>').add(this.targetElement, XChars::assembleCautiously);
            return vs.toString();
        }
    }
}

