/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.similarity;

import java.text.DecimalFormat;
import java.util.function.BiConsumer;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.similarity.MultiMatch;
import org.eclipse.serializer.util.similarity.MultiMatchResult;
import org.eclipse.serializer.util.similarity.Similarity;

public interface MultiMatchAssembler<E> {
    public VarString assembleState(VarString var1, DecimalFormat var2, BiConsumer<VarString, ? super E> var3);

    public VarString assembleMappingSchemeHorizontal(VarString var1, DecimalFormat var2, BiConsumer<VarString, ? super E> var3);

    public VarString assembleMappingSchemeVertical(VarString var1, DecimalFormat var2, BiConsumer<VarString, ? super E> var3);

    default public VarString assemble(VarString vs) {
        return this.assembleState(vs, Defaults.defaultSimilarityFormatter(), Defaults.defaultElementAssembler());
    }

    default public VarString assembleMappingSchemeHorizontal(VarString vs) {
        return this.assembleMappingSchemeHorizontal(vs, Defaults.defaultSimilarityFormatter(), Defaults.defaultElementAssembler());
    }

    default public VarString assembleMappingSchemeVertical(VarString vs) {
        return this.assembleMappingSchemeVertical(vs, Defaults.defaultSimilarityFormatter(), Defaults.defaultElementAssembler());
    }

    public static class Default<E>
    implements MultiMatchAssembler<E> {
        private final MultiMatch.Default<E> match;

        public static <E> Default<E> New(MultiMatch.Default<E> match) {
            return new Default<E>(X.notNull(match));
        }

        protected Default(MultiMatch.Default<E> match) {
            this.match = match;
        }

        @Override
        public VarString assembleState(VarString vs, DecimalFormat formatter, BiConsumer<VarString, ? super E> assembler) {
            MultiMatch.Default<E> match = this.match;
            int candidateCount = Math.min(match.sourceCandidateCount, match.targetCandidateCount);
            vs.add("Matching state:").lf().add("[candidateCount = ").add(candidateCount).add(']').lf().add("[matchCount = ").add(match.matchCount).add(']').lf().add("[averageSimilarity = ").add(XMath.round3(match.averageSimilarity)).add(']').lf().add("[lowestSimilarity  = ").add(XMath.round3(match.lowestSimilarity)).add(']').lf().add("[highestSimilarity = ").add(XMath.round3(match.highestSimilarity)).add(']').lf();
            vs.add("s\\t").tab();
            int tLength = match.matrix[0].length;
            int t = 0;
            while (t < tLength) {
                vs.add(t).tab();
                ++t;
            }
            vs.add("s2t").lf();
            int s = 0;
            while (s < match.matrix.length) {
                double[] sTargets = match.matrix[s];
                vs.add(s).tab();
                int t2 = 0;
                while (t2 < sTargets.length) {
                    if (sTargets[t2] > 0.0) {
                        vs.add(formatter.format(sTargets[t2]));
                    }
                    vs.tab();
                    ++t2;
                }
                if (match.srcToTrgMap[s] >= 0) {
                    vs.add("#" + match.srcToTrgMap[s]).tab();
                    assembler.accept(vs, match.inputSource[s]);
                    vs.tab();
                    assembler.accept(vs, match.inputTarget[match.srcToTrgMap[s]]);
                } else if (match.srcCandCount[s] > 0) {
                    vs.add('[').add(match.srcCandCount[s]).add(']');
                } else {
                    vs.tab();
                    assembler.accept(vs, match.inputSource[s]);
                    vs.tab();
                }
                vs.lf();
                ++s;
            }
            vs.add("t2s").tab();
            t = 0;
            while (t < tLength) {
                if (match.trgToSrcMap[t] >= 0) {
                    vs.add("#" + match.trgToSrcMap[t]);
                } else if (match.trgCandCount[t] > 0) {
                    vs.add('[').add(match.trgCandCount[t]).add(']');
                }
                vs.tab();
                ++t;
            }
            vs.lf();
            vs.lf();
            vs.lf();
            return vs;
        }

        @Override
        public VarString assembleMappingSchemeHorizontal(VarString line1Srcs, DecimalFormat formatter, BiConsumer<VarString, ? super E> assembler) {
            MultiMatch.Default<E> match = this.match;
            VarString line2SrcSymbol = VarString.New();
            VarString line3Similaris = VarString.New();
            VarString line4TrgSymbol = VarString.New();
            VarString line5Trgs = VarString.New();
            MultiMatchResult<E> result = match.result();
            for (Object e : result.inputSources()) {
                assembler.accept(line1Srcs, e);
                line1Srcs.tab();
            }
            for (Similarity similarity : result.matchesInSourceOrder()) {
                if (similarity != null) {
                    line2SrcSymbol.append('|');
                    line3Similaris.append(formatter.format(similarity.similarity()));
                    line4TrgSymbol.append('|');
                    assembler.accept(line5Trgs, similarity.targetElement());
                } else {
                    line2SrcSymbol.append('-');
                }
                line2SrcSymbol.tab();
                line3Similaris.tab();
                line4TrgSymbol.tab();
                line5Trgs.tab();
            }
            for (Object e : result.unmatchedTargets()) {
                line4TrgSymbol.append('+').tab();
                assembler.accept(line5Trgs, e);
                line5Trgs.tab();
            }
            return line1Srcs.lf().add(line2SrcSymbol).lf().add(line3Similaris).lf().add(line4TrgSymbol).lf().add(line5Trgs);
        }

        @Override
        public VarString assembleMappingSchemeVertical(VarString vs, DecimalFormat formatter, BiConsumer<VarString, ? super E> assembler) {
            MultiMatch.Default<E> match = this.match;
            int s = 0;
            while (s < match.inputSource.length) {
                assembler.accept(vs, match.inputSource[s]);
                if (match.linkedTargets[s] != null) {
                    vs.add("\t<-");
                    vs.add(formatter.format(match.linkedSourceSimilarities[s]));
                    vs.add("->\t");
                    assembler.accept(vs, match.linkedTargets[s]);
                } else {
                    vs.add("\t[deleted]");
                }
                vs.lf();
                ++s;
            }
            int t = 0;
            while (t < match.target.length) {
                if (match.target[t] != null) {
                    vs.add("\t[new]\t");
                    assembler.accept(vs, match.target[t]);
                    vs.lf();
                }
                ++t;
            }
            return vs;
        }
    }

    public static interface Defaults {
        public static <E> BiConsumer<VarString, ? super E> defaultElementAssembler() {
            return (vs, e) -> {
                VarString varString = vs.add(e);
            };
        }

        public static DecimalFormat defaultSimilarityFormatter() {
            return new DecimalFormat("0.000");
        }
    }
}

