/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.iterables;

import java.util.Iterator;
import org.eclipse.serializer.math.XMath;

public final class RandomArrayIterator<E>
implements Iterator<E> {
    private final E[] array;
    private final int length;
    private int count;
    private int c;

    public static <E> Factory<E> random(int count, E[] array) {
        return new Factory<E>(array, count);
    }

    public RandomArrayIterator(E[] array, int count) {
        this.array = array;
        this.length = array.length;
        this.count = count;
        this.c = 0;
    }

    public int getCount() {
        return this.count;
    }

    public RandomArrayIterator<E> setCount(int count) {
        this.count = count;
        return this;
    }

    public RandomArrayIterator<E> incrementCount(int amount) {
        this.count += amount;
        return this;
    }

    public RandomArrayIterator<E> decrementCount(int amount) {
        this.count -= amount;
        return this;
    }

    public int abort() {
        int c = this.c;
        this.c = this.count;
        return c;
    }

    public int getIterationCount() {
        return this.c;
    }

    @Override
    public boolean hasNext() {
        return this.c < this.count;
    }

    @Override
    public E next() {
        E e = this.array[XMath.random(this.length)];
        ++this.c;
        return e;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static final class Factory<E>
    implements Iterable<E> {
        private final E[] array;
        private int count;

        public Factory(E[] array, int count) {
            this.array = array;
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public Factory<E> setCount(int count) {
            this.count = count;
            return this;
        }

        public Factory<E> incrementCount(int amount) {
            this.count += amount;
            return this;
        }

        public Factory<E> decrementCount(int amount) {
            this.count -= amount;
            return this;
        }

        @Override
        public RandomArrayIterator<E> iterator() {
            return new RandomArrayIterator<E>(this.array, this.count);
        }
    }
}

