/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.iterables;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.serializer.collections.types.XList;
import org.eclipse.serializer.exceptions.IndexBoundsException;
import org.eclipse.serializer.typing.XTypes;

public class GenericListIterator<E>
implements ListIterator<E> {
    private final XList<E> list;
    private int index;
    private int lastReturnedIndex;

    public GenericListIterator(XList<E> list) throws IndexBoundsException {
        this.list = list;
        this.index = 0;
        this.lastReturnedIndex = -1;
    }

    public GenericListIterator(XList<E> list, int index) throws IndexBoundsException {
        this.list = list;
        if (index < 0 || (long)index >= list.size()) {
            throw new IndexBoundsException((long)XTypes.to_int(list.size()), index);
        }
        this.index = index;
        this.lastReturnedIndex = -1;
    }

    @Override
    public void add(E e) throws UnsupportedOperationException {
        this.list.add(e);
    }

    @Override
    public boolean hasNext() {
        return this.index < XTypes.to_int(this.list.size());
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0 && this.index <= XTypes.to_int(this.list.size());
    }

    @Override
    public E next() throws NoSuchElementException {
        try {
            int i = this.index;
            Object e = this.list.at(i);
            this.lastReturnedIndex = i;
            this.index = i + 1;
            return e;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public E previous() throws NoSuchElementException {
        try {
            int i = this.index - 1;
            Object e = this.list.at(i);
            this.lastReturnedIndex = this.index = i;
            return e;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void remove() throws NoSuchElementException, UnsupportedOperationException {
        if (this.lastReturnedIndex == -1) {
            throw new IllegalStateException();
        }
        try {
            this.list.removeAt(this.lastReturnedIndex);
            if (this.lastReturnedIndex < this.index) {
                --this.index;
            }
            this.lastReturnedIndex = -1;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void set(E e) throws NoSuchElementException, UnsupportedOperationException {
        if (this.lastReturnedIndex == -1) {
            throw new IllegalStateException();
        }
        try {
            this.list.setGet(this.lastReturnedIndex, e);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new NoSuchElementException();
        }
    }
}

