/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.iterables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class ChainedIterables<T>
implements Iterable<T> {
    final ArrayList<Iterable<T>> iterables;

    @SafeVarargs
    public ChainedIterables(Iterable<T> ... iterables) {
        ArrayList<Iterable<T>> set = new ArrayList<Iterable<T>>(iterables.length);
        this.iterables = set;
        Iterable<T>[] iterableArray = iterables;
        int n = iterables.length;
        int n2 = 0;
        while (n2 < n) {
            Iterable<T> iterable = iterableArray[n2];
            if (iterable != null) {
                set.add(iterable);
            }
            ++n2;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ChainedIterator();
    }

    public Iterable<T> add(Iterable<T> iterable) {
        this.iterables.add(iterable);
        return this;
    }

    @SafeVarargs
    public final ChainedIterables<T> add(Iterable<T> ... iterables) {
        Collections.addAll(this.iterables, iterables);
        return this;
    }

    public Iterable<T> remove(Iterable<T> iterable) {
        this.iterables.remove(iterable);
        return iterable;
    }

    @SafeVarargs
    public final int remove(Iterable<T> ... iterables) {
        int removedCount = 0;
        Iterable<T>[] iterableArray = iterables;
        int n = iterables.length;
        int n2 = 0;
        while (n2 < n) {
            Iterable<T> i = iterableArray[n2];
            if (this.iterables.remove(i)) {
                ++removedCount;
            }
            ++n2;
        }
        return removedCount;
    }

    public boolean contains(Iterable<T> iterable) {
        return this.iterables.contains(iterable);
    }

    protected class ChainedIterator
    implements Iterator<T> {
        private Iterator<T> currentIterator;
        private int currentIndex;

        ChainedIterator() {
            this.nextIterator();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext()) ** GOTO lbl5
            return true;
lbl-1000:
            // 1 sources

            {
                if (!this.currentIterator.hasNext()) continue;
                return true;
lbl5:
                // 2 sources

                ** while (this.nextIterator())
            }
lbl6:
            // 1 sources

            return false;
        }

        @Override
        public T next() {
            return this.currentIterator.next();
        }

        protected boolean nextIterator() {
            ArrayList iterables = ChainedIterables.this.iterables;
            Iterable loopIterable = null;
            while (loopIterable == null && this.currentIndex < iterables.size()) {
                loopIterable = iterables.get(this.currentIndex++);
            }
            if (loopIterable == null) {
                return false;
            }
            this.currentIterator = loopIterable.iterator();
            return true;
        }

        @Override
        public void remove() {
            this.currentIterator.remove();
        }
    }
}

