/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.iterables;

import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class ArrayListIterator<E>
implements ListIterator<E> {
    private final E[] array;
    private final int length;
    private int index;
    private int lastRet;

    public ArrayListIterator(E[] array) {
        this.array = array;
        this.length = array.length;
        this.index = 0;
        this.lastRet = -1;
    }

    public ArrayListIterator(E[] array, int index) {
        this.array = array;
        this.length = array.length;
        if (index < 0 || index >= this.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.index = index;
        this.lastRet = -1;
    }

    @Override
    public void add(E e) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.index < this.length;
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public E next() {
        try {
            int i = this.index;
            E e = this.array[i];
            this.lastRet = i;
            this.index = i + 1;
            return e;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public E previous() {
        if (this.index == 0) {
            throw new NoSuchElementException();
        }
        int i = this.index - 1;
        E e = this.array[i];
        this.lastRet = this.index = i;
        return e;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(E e) {
        if (this.lastRet == -1) {
            throw new IllegalStateException();
        }
        this.array[this.lastRet] = e;
    }
}

