/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.iterables;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ArrayIterator<E>
implements Iterator<E> {
    private final E[] array;
    private final int length;
    private int index;

    public ArrayIterator(E[] array) {
        this.array = array;
        this.length = array.length;
        this.index = 0;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.length;
    }

    @Override
    public E next() {
        try {
            int i = this.index;
            E e = this.array[i];
            this.index = i + 1;
            return e;
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

