/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util.cql;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.types.XIterable;
import org.eclipse.serializer.functional.Aggregator;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.cql.CQL;
import org.eclipse.serializer.util.cql.CqlProjection;
import org.eclipse.serializer.util.cql.CqlQuery;
import org.eclipse.serializer.util.cql.CqlResultor;
import org.eclipse.serializer.util.cql.CqlTransfer;

public interface CqlAggregation<I, R>
extends CqlQuery<I, I, R> {
    default public CqlAggregation<I, R> skip(Number count) {
        return CqlAggregation.New(this.getSource(), CQL.asLong(count), this.getLimit(), this.getSelector(), this.getOrder(), this.getResultor());
    }

    default public CqlAggregation<I, R> limit(Number count) {
        return CqlAggregation.New(this.getSource(), this.getSkip(), CQL.asLong(count), this.getSelector(), this.getOrder(), this.getResultor());
    }

    default public CqlAggregation<I, R> select(Predicate<? super I> selector) {
        return CqlAggregation.New(this.getSource(), this.getSkip(), this.getLimit(), selector, this.getOrder(), this.getResultor());
    }

    default public CqlAggregation<I, R> orderBy(Comparator<? super I> order) {
        return CqlAggregation.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), order, this.getResultor());
    }

    default public CqlAggregation<I, R> from(XIterable<? extends I> source) {
        return CqlAggregation.New(source, this.getSkip(), this.getLimit(), this.getSelector(), this.getOrder(), this.getResultor());
    }

    @Override
    default public <P> CqlProjection<I, P> project(Function<? super I, P> projector) {
        return CqlProjection.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), projector, null);
    }

    default public <P extends Consumer<I> & XIterable<I>> CqlTransfer<I, P> into(P target) {
        return CqlTransfer.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getOrder(), target);
    }

    default public <X extends XIterable<I>> CqlTransfer<I, X> into(CqlResultor<I, X> resultor) {
        return CqlTransfer.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getOrder(), X.notNull(resultor));
    }

    default public <R1> CqlAggregation<I, R1> over(CqlResultor<I, R1> resultor) {
        return CqlAggregation.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getOrder(), X.notNull(resultor));
    }

    default public <R1> CqlAggregation<I, R1> targeting(Aggregator<I, R1> collector) {
        return CqlAggregation.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getOrder(), CqlResultor.NewFromAggregator(collector));
    }

    @Override
    default public R execute() {
        return this.executeOn(CQL.prepareSource(this.getSource()));
    }

    @Override
    default public R executeOn(XIterable<? extends I> source) {
        return CQL.executeQuery(source, this.getSkip(), this.getLimit(), this.getSelector(), this.getResultor(), this.getOrder());
    }

    public static <I, R> CqlAggregation<I, R> New() {
        return new Default(null, null, null, null, null, null);
    }

    public static <I, R> CqlAggregation<I, R> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Comparator<? super I> order, CqlResultor<I, R> resultor) {
        return new Default<I, R>(source, skip, limit, selector, order, resultor);
    }

    public static final class Default<I, R>
    extends CqlQuery.Abstract<I, I, R>
    implements CqlAggregation<I, R> {
        Default(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Comparator<? super I> order, CqlResultor<I, R> resultor) {
            super(source, skip, limit, selector, null, order, resultor);
        }
    }
}

