/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.eclipse.serializer.branching.ThrowBreak;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.ArrayView;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.ConstHashEnum;
import org.eclipse.serializer.collections.ConstList;
import org.eclipse.serializer.collections.Constant;
import org.eclipse.serializer.collections.Empty;
import org.eclipse.serializer.collections.EmptyTable;
import org.eclipse.serializer.collections.HashEnum;
import org.eclipse.serializer.collections.HashTable;
import org.eclipse.serializer.collections.LimitList;
import org.eclipse.serializer.collections.Singleton;
import org.eclipse.serializer.collections.SynchCollection;
import org.eclipse.serializer.collections.SynchList;
import org.eclipse.serializer.collections.SynchSet;
import org.eclipse.serializer.collections.interfaces.Sized;
import org.eclipse.serializer.collections.old.AbstractBridgeXList;
import org.eclipse.serializer.collections.old.AbstractBridgeXSet;
import org.eclipse.serializer.collections.types.XCollection;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XList;
import org.eclipse.serializer.collections.types.XMap;
import org.eclipse.serializer.collections.types.XReference;
import org.eclipse.serializer.collections.types.XSet;
import org.eclipse.serializer.concurrency.ThreadSafe;
import org.eclipse.serializer.exceptions.ArrayCapacityException;
import org.eclipse.serializer.exceptions.IndexBoundsException;
import org.eclipse.serializer.exceptions.WrapperRuntimeException;
import org.eclipse.serializer.functional.BooleanTerm;
import org.eclipse.serializer.functional._intIndexedSupplier;
import org.eclipse.serializer.functional._intProcedure;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.meta.NotImplementedYetError;
import org.eclipse.serializer.typing.KeyValue;
import org.eclipse.serializer.typing._longKeyValue;
import org.eclipse.serializer.util.UtilStackTrace;

public final class X {
    private static final Empty<?> EMPTY = new Empty();
    private static final EmptyTable<?, ?> EMPTY_TABLE = new EmptyTable();
    private static final ThrowBreak BREAK = new ThrowBreak();
    private static final long INTEGER_RANGE_BOUND = 0x80000000L;

    public static <T> Empty<T> empty() {
        return EMPTY;
    }

    public static <K, V> EmptyTable<K, V> emptyTable() {
        return EMPTY_TABLE;
    }

    public static ThrowBreak BREAK() {
        return BREAK;
    }

    public static int checkArrayRange(long capacity) throws ArrayCapacityException {
        if (capacity >= 0x80000000L) {
            throw new ArrayCapacityException(capacity);
        }
        return (int)capacity;
    }

    public static <T> T notNull(T object) throws NullPointerException {
        if (object == null) {
            throw UtilStackTrace.cutStacktraceByOne(new NullPointerException());
        }
        return object;
    }

    public static <T> T mayNull(T object) {
        return object;
    }

    public static boolean isTrue(Boolean b) {
        return b != null && b != false;
    }

    public static boolean isFalse(Boolean b) {
        return b != null && b == false;
    }

    public static boolean isNotTrue(Boolean b) {
        return b == null || b == false;
    }

    public static boolean isNotFalse(Boolean b) {
        return b == null || b != false;
    }

    public static boolean isNull(Object reference) {
        return reference == null;
    }

    public static boolean isNotNull(Object reference) {
        return reference != null;
    }

    public static <T> T coalesce(T firstElement, T secondElement) {
        return firstElement == null ? secondElement : firstElement;
    }

    @SafeVarargs
    public static <T> T coalesce(T ... elements) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i] != null) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }

    public static <T> boolean equal(T o1, T o2) {
        return Objects.equals(o1, o2);
    }

    public static byte unbox(Byte d) {
        return d == null ? (byte)0 : d;
    }

    public static byte unbox(Byte d, byte nullSubstitute) {
        return d == null ? nullSubstitute : d;
    }

    public static boolean unbox(Boolean d) {
        return d != null && d != false;
    }

    public static boolean unbox(Boolean d, boolean nullSubstitute) {
        return d == null ? nullSubstitute : d;
    }

    public static short unbox(Short d) {
        return d == null ? (short)0 : d;
    }

    public static short unbox(Short d, short nullSubstitute) {
        return d == null ? nullSubstitute : d;
    }

    public static char unbox(Character d) {
        return d == null ? (char)'\u0000' : d.charValue();
    }

    public static int unbox(Integer d) {
        return d == null ? 0 : d;
    }

    public static int unbox(Integer d, int nullSubstitute) {
        return d == null ? nullSubstitute : d;
    }

    public static char unbox(Character d, char nullSubstitute) {
        return d == null ? nullSubstitute : d.charValue();
    }

    public static float unbox(Float d) {
        return d == null ? 0.0f : d.floatValue();
    }

    public static float unbox(Float d, float nullSubstitute) {
        return d == null ? nullSubstitute : d.floatValue();
    }

    public static long unbox(Long d) {
        return d == null ? 0L : d;
    }

    public static long unbox(Long d, long nullSubstitute) {
        return d == null ? nullSubstitute : d;
    }

    public static double unbox(Double d) {
        return d == null ? 0.0 : d;
    }

    public static double unbox(Double d, double nullSubstitute) {
        return d == null ? nullSubstitute : d;
    }

    public static Byte[] box(byte ... values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        Byte[] result = new Byte[length];
        int i = 0;
        while (i < length) {
            result[i] = values[i];
            ++i;
        }
        return result;
    }

    public static Boolean[] box(boolean ... values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        Boolean[] result = new Boolean[length];
        int i = 0;
        while (i < length) {
            result[i] = values[i];
            ++i;
        }
        return result;
    }

    public static Short[] box(short ... values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        Short[] result = new Short[length];
        int i = 0;
        while (i < length) {
            result[i] = values[i];
            ++i;
        }
        return result;
    }

    public static Integer[] box(int ... values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        Integer[] result = new Integer[length];
        int i = 0;
        while (i < length) {
            result[i] = values[i];
            ++i;
        }
        return result;
    }

    public static Character[] box(char ... values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        Character[] result = new Character[length];
        int i = 0;
        while (i < length) {
            result[i] = Character.valueOf(values[i]);
            ++i;
        }
        return result;
    }

    public static Float[] box(float ... values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        Float[] result = new Float[length];
        int i = 0;
        while (i < length) {
            result[i] = Float.valueOf(values[i]);
            ++i;
        }
        return result;
    }

    public static Long[] box(long ... values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        Long[] result = new Long[length];
        int i = 0;
        while (i < length) {
            result[i] = values[i];
            ++i;
        }
        return result;
    }

    public static Double[] box(double ... values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        Double[] result = new Double[length];
        int i = 0;
        while (i < length) {
            result[i] = values[i];
            ++i;
        }
        return result;
    }

    public static int[] unbox(Integer[] array) {
        return X.unbox(array, 0);
    }

    public static int[] unbox(Integer[] array, int nullReplacement) {
        if (array == null) {
            return null;
        }
        int[] result = new int[array.length];
        int i = 0;
        int length = result.length;
        while (i < length) {
            Integer value = array[i];
            result[i] = value == null ? nullReplacement : value;
            ++i;
        }
        return result;
    }

    public static long[] unbox(Long[] array) {
        return X.unbox(array, 0L);
    }

    public static long[] unbox(Long[] array, long nullReplacement) {
        if (array == null) {
            return null;
        }
        long[] result = new long[array.length];
        int i = 0;
        int length = result.length;
        while (i < length) {
            Long value = array[i];
            result[i] = value == null ? nullReplacement : value;
            ++i;
        }
        return result;
    }

    public static int[] unbox(XGettingCollection<Integer> ints) {
        return X.unbox(ints, 0);
    }

    public static int[] unbox(XGettingCollection<Integer> ints, int nullReplacement) {
        if (ints == null) {
            return null;
        }
        int[] returnArray = new int[ints.intSize()];
        int i = 0;
        for (Integer e : ints) {
            int n = returnArray[i++] = e == null ? nullReplacement : e;
        }
        return returnArray;
    }

    public static boolean[] booleans(boolean ... elements) {
        return elements;
    }

    public static byte[] bytes(byte ... elements) {
        return elements;
    }

    public static byte[] toBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return bytes;
    }

    public static byte[] toBytes(long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 56 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return bytes;
    }

    public static short[] shorts(short ... elements) {
        return elements;
    }

    public static int[] ints(int ... elements) {
        return elements;
    }

    public static long[] longs(long ... elements) {
        return elements;
    }

    public static float[] floats(float ... elements) {
        return elements;
    }

    public static double[] doubles(double ... elements) {
        return elements;
    }

    public static char[] chars(char ... elements) {
        return elements;
    }

    @SafeVarargs
    public static <T> T[] array(T ... elements) {
        return elements;
    }

    public static Object[] objects(Object ... elements) {
        return elements;
    }

    public static String[] strings(String ... elements) {
        return elements;
    }

    public static XList<Integer> times(int n) {
        LimitList<Integer> integers = LimitList.New(n);
        int i = 1;
        while (i <= n) {
            integers.add(i);
            ++i;
        }
        return integers;
    }

    public static XList<Integer> range(int firstValue, int lastValue) {
        int direction;
        int high;
        int low;
        if (firstValue <= lastValue) {
            low = firstValue;
            high = lastValue;
            direction = 1;
        } else {
            high = firstValue;
            low = lastValue;
            direction = -1;
        }
        LimitList<Integer> integers = LimitList.New(high - low + 1);
        int i = firstValue - direction;
        while (i != lastValue) {
            integers.add(i += direction);
        }
        return integers;
    }

    @SafeVarargs
    public static <E> XList<E> List(E ... elements) {
        if (elements == null || elements.length == 0) {
            return BulkList.New();
        }
        return BulkList.New(elements);
    }

    public static <E> XList<E> List(Iterable<? extends E> elements) {
        BulkList newInstance = BulkList.New();
        elements.forEach(newInstance);
        return newInstance;
    }

    @SafeVarargs
    public static <E> ConstList<E> ConstList(E ... elements) throws NullPointerException {
        return ConstList.New(elements);
    }

    @SafeVarargs
    public static <E> ArrayView<E> ArrayView(E ... elements) {
        if (elements == null || elements.length == 0) {
            return new ArrayView();
        }
        return new ArrayView<E>(elements);
    }

    public static <E> Singleton<E> Singleton(E element) {
        return Singleton.New(element);
    }

    public static <E> Constant<E> Constant(E element) {
        return new Constant<E>(element);
    }

    @SafeVarargs
    public static <E> HashEnum<E> Enum(E ... elements) {
        if (elements == null || elements.length == 0) {
            return HashEnum.New();
        }
        return HashEnum.New(elements);
    }

    public static <E> HashEnum<E> Enum(Iterable<? extends E> elements) {
        HashEnum newInstance = HashEnum.New();
        elements.forEach(newInstance);
        return newInstance;
    }

    @SafeVarargs
    public static <E> ConstHashEnum<E> ConstEnum(E ... elements) throws NullPointerException {
        if (elements == null || elements.length == 0) {
            return ConstHashEnum.New();
        }
        return ConstHashEnum.New(elements);
    }

    public static <K, V> HashTable<K, V> Table(K key, V value) {
        return HashTable.New(X.KeyValue(key, value));
    }

    @SafeVarargs
    public static <K, V> HashTable<K, V> Table(KeyValue<? extends K, ? extends V> ... elements) {
        if (elements == null || elements.length == 0) {
            return HashTable.New();
        }
        return HashTable.New(elements);
    }

    public static <T> XReference<T> Reference(T object) {
        return Singleton.New(object);
    }

    public static Iterable<?> Iterable(final Object array) {
        return () -> new Iterator(){
            int position = 0;
            final int length;
            {
                this.length = Array.getLength(object);
            }

            @Override
            public boolean hasNext() {
                return this.position < this.length;
            }

            public Object next() {
                return Array.get(array, this.position++);
            }
        };
    }

    public static <T> T[] ArrayForElementType(T sampleInstance, int length) {
        return (Object[])Array.newInstance(sampleInstance.getClass(), length);
    }

    public static <E> E[] ArrayOfSameType(E[] sampleArray, int length) {
        return (Object[])Array.newInstance(sampleArray.getClass().getComponentType(), length);
    }

    public static <E> E[] ArrayOfSameType(E[] sampleArray) {
        return (Object[])Array.newInstance(sampleArray.getClass().getComponentType(), sampleArray.length);
    }

    public static <E> E[] Array(E element) {
        return X.Array(1, element);
    }

    public static <E> E[] Array(int length, E element) {
        Object[] newArray = (Object[])Array.newInstance(element.getClass(), length);
        newArray[0] = element;
        return newArray;
    }

    public static <E> E[] Array(Class<E> componentType, E element) {
        return X.Array(componentType, element, 1);
    }

    public static <E> E[] Array(Class<E> componentType, E element, int length) {
        E[] newArray = X.Array(componentType, length);
        newArray[0] = element;
        return newArray;
    }

    public static <E> E[] Array(Class<E> componentType, int length) {
        return (Object[])Array.newInstance(componentType, length);
    }

    public static <T, E extends T> T[] Array(Class<T> type, XGettingCollection<E> collection) {
        return collection.toArray(type);
    }

    public static <E> E[] Array(Class<E> componentType, int length, Supplier<E> supplier) {
        E[] array = X.Array(componentType, length);
        int i = 0;
        while (i < array.length) {
            array[i] = supplier.get();
            ++i;
        }
        return array;
    }

    public static <E> E[] Array(Class<E> componentType, int length, _intIndexedSupplier<E> supplier) {
        E[] array = X.Array(componentType, length);
        int i = 0;
        while (i < array.length) {
            array[i] = supplier.get(i);
            ++i;
        }
        return array;
    }

    public static <T> WeakReference<T> WeakReference(T referent) {
        return new WeakReference<T>(referent);
    }

    public static <T> WeakReference<T>[] WeakReferences(int length) {
        return new WeakReference[length];
    }

    @SafeVarargs
    public static <T> WeakReference<T>[] WeakReferences(T ... referents) {
        if (referents == null) {
            return null;
        }
        WeakReference<T>[] weakReferences = X.WeakReferences(referents.length);
        int i = 0;
        while (i < referents.length) {
            weakReferences[i] = X.WeakReference(referents[i]);
            ++i;
        }
        return weakReferences;
    }

    public static <T> WeakReference<T>[] consolidateWeakReferences(WeakReference<T>[] array) {
        int liveEntryCount = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                if (array[i].get() == null) {
                    array[i] = null;
                } else {
                    ++liveEntryCount;
                }
            }
            ++i;
        }
        if (liveEntryCount == array.length) {
            return array;
        }
        WeakReference<T>[] newArray = X.WeakReferences(liveEntryCount);
        int i2 = 0;
        int n = 0;
        while (i2 < array.length) {
            if (array[i2] != null) {
                newArray[n++] = array[i2];
            }
            ++i2;
        }
        return newArray;
    }

    public static <E> XList<E> asX(List<E> oldList) {
        if (oldList instanceof AbstractBridgeXList) {
            return ((AbstractBridgeXList)oldList).parent();
        }
        if (oldList instanceof ArrayList) {
            throw new NotImplementedYetError();
        }
        throw new UnsupportedOperationException();
    }

    public static <E> XSet<E> asX(Set<E> oldSet) {
        if (oldSet instanceof AbstractBridgeXSet) {
            return ((AbstractBridgeXSet)oldSet).parent();
        }
        throw new UnsupportedOperationException();
    }

    public static <K, V> XMap<K, V> asX(Map<K, V> oldMap) {
        throw new UnsupportedOperationException();
    }

    public static boolean hasNoContent(XGettingCollection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <S extends Sized> S notEmpty(S sized) {
        if (sized.isEmpty()) {
            throw UtilStackTrace.cutStacktraceByOne(new IllegalArgumentException());
        }
        return sized;
    }

    public static <E> E[] notEmpty(E[] array) {
        if (array.length == 0) {
            throw UtilStackTrace.cutStacktraceByOne(new IllegalArgumentException());
        }
        return array;
    }

    public static <T, K, V> KeyValue<K, V> toKeyValue(T instance, Function<? super T, KeyValue<K, V>> mapper) {
        return mapper.apply(instance);
    }

    public static <K, V> KeyValue<K, V> KeyValue(K key, V value) {
        return KeyValue.New(key, value);
    }

    public static _longKeyValue _longKeyValue(long key, long value) {
        return new _longKeyValue.Default(key, value);
    }

    public static String toString(XGettingCollection<?> collection) {
        return X.assembleString(VarString.New((int)((float)collection.size() * 4.0f)), collection).toString();
    }

    public static <T> VarString assembleString(VarString vs, XGettingCollection<T> collection) {
        if (collection.isEmpty()) {
            return vs.add('[', ']');
        }
        vs.append('[');
        collection.iterate(e -> {
            VarString varString2 = vs.add(e).add(',', ' ');
        });
        vs.deleteLast().setLast(']');
        return vs;
    }

    public static <E> XList<E> synchronize(XList<E> list) {
        if (list instanceof ThreadSafe) {
            return list;
        }
        return new SynchList<E>(list);
    }

    public static <E> XSet<E> synchronize(XSet<E> set) {
        if (set instanceof ThreadSafe) {
            return set;
        }
        return new SynchSet<E>(set);
    }

    public static <E> XCollection<E> synchronize(XCollection<E> collection) {
        if (collection instanceof ThreadSafe) {
            return collection;
        }
        return new SynchCollection<E>(collection);
    }

    public static <E> E[] toArray(Iterable<? extends E> iterable, Class<E> type) {
        if (iterable instanceof XGettingCollection) {
            return ((XGettingCollection)iterable).toArray(type);
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return collection.toArray((Object[])Array.newInstance(type, collection.size()));
        }
        return StreamSupport.stream(iterable.spliterator(), false).toArray(size -> (Object[])Array.newInstance(type, size));
    }

    public static <T extends Throwable> T addSuppressed(T throwable, Throwable suppressed) {
        throwable.addSuppressed(suppressed);
        return throwable;
    }

    public static <T extends Throwable> T addSuppressed(T throwable, Throwable ... suppresseds) {
        Throwable[] throwableArray = suppresseds;
        int n = suppresseds.length;
        int n2 = 0;
        while (n2 < n) {
            Throwable suppressed = throwableArray[n2];
            throwable.addSuppressed(suppressed);
            ++n2;
        }
        return throwable;
    }

    public static RuntimeException asUnchecked(Exception e) {
        return e instanceof RuntimeException ? (RuntimeException)e : new WrapperRuntimeException(e);
    }

    public static <S> S on(S subject, Consumer<? super S> logic) {
        logic.accept(subject);
        return subject;
    }

    public static void check(BooleanTerm condition) throws Error {
        X.check(condition, null, 1);
    }

    public static void check(BooleanTerm condition, String message) throws Error {
        X.check(condition, message, 1);
    }

    public static void check(BooleanTerm condition, String message, int stackLevels) throws Error {
        if (condition.evaluate()) {
            return;
        }
        throw UtilStackTrace.cutStacktraceByN(new Error("Check failed" + (message == null ? "." : ": " + message)), stackLevels + 1);
    }

    public static <T> T validate(T value, Predicate<? super T> validator) throws IllegalArgumentException {
        return (T)X.validate(value, validator, X::illegalArgument);
    }

    public static IllegalArgumentException illegalArgument(Object object) {
        return UtilStackTrace.cutStacktraceByOne(new IllegalArgumentException());
    }

    public static <T, E extends Exception> T validate(T value, Predicate<? super T> validator, Function<? super T, E> exceptor) throws E {
        if (validator.test(value)) {
            return value;
        }
        throw (Exception)exceptor.apply(value);
    }

    public static <P extends _intProcedure> P repeat(int amount, P logic) {
        return X.repeat(0, amount, logic);
    }

    public static <P extends _intProcedure> P repeat(int startValue, int length, P logic) {
        int bound = startValue + XMath.positive(length);
        int i = startValue;
        while (i < bound) {
            logic.accept(i);
            ++i;
        }
        return logic;
    }

    public static <P extends Runnable> P repeat(int amount, P logic) {
        return X.repeat(0, amount, logic);
    }

    public static <P extends Runnable> P repeat(int startValue, int length, P logic) {
        int bound = startValue + XMath.positive(length);
        int i = startValue;
        while (i < bound) {
            logic.run();
            ++i;
        }
        return logic;
    }

    public static long validateIndex(long availableLength, long index) throws IndexBoundsException {
        if (index < 0L) {
            throw X.IndexBoundsException(0L, availableLength, index, "Index < 0", 1);
        }
        if (index >= availableLength) {
            throw X.IndexBoundsException(0L, availableLength, index, "Index >= bound", 1);
        }
        return index;
    }

    public static long validateRange(long bound, long startIndex, long length) {
        if (startIndex < 0L) {
            throw X.IndexBoundsException(0L, bound, startIndex, "StartIndex < 0", 1);
        }
        if (startIndex >= bound) {
            throw X.IndexBoundsException(0L, bound, startIndex, "StartIndex >= bound", 1);
        }
        if (length < 0L) {
            throw X.IndexBoundsException(startIndex, bound, length, "Length < 0", 1);
        }
        if (startIndex + length > bound) {
            throw X.IndexBoundsException(0L, bound, startIndex + length, "Range > bound", 1);
        }
        return startIndex + length;
    }

    public static IndexBoundsException IndexBoundsException(long startIndex, long indexBound, long index, String message, int stackTraceCutDepth) {
        return UtilStackTrace.cutStacktraceByN(new IndexBoundsException(startIndex, indexBound, index, message), stackTraceCutDepth + 1);
    }

    private X() {
        throw new UnsupportedOperationException();
    }
}

