/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util;

public class UtilStackTrace {
    public static final <T extends Throwable> T cutStacktraceTo(T t, Class<?> c, String methodName) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        String cName = c.getName();
        int stackTracesToSkip = 0;
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            if (ste.getClassName().equals(cName) && ste.getMethodName().equals(methodName)) break;
            ++stackTracesToSkip;
            ++n2;
        }
        return UtilStackTrace.cutStacktraceByN(t, stackTracesToSkip);
    }

    public static final <T extends Throwable> T cutStacktraceByOne(T throwable) {
        StackTraceElement[] st1 = throwable.getStackTrace();
        StackTraceElement[] st2 = new StackTraceElement[st1.length - 1];
        System.arraycopy(st1, 1, st2, 0, st1.length - 1);
        throwable.setStackTrace(st2);
        return throwable;
    }

    public static <T extends Throwable> T cutStacktraceByN(T throwable, int n) {
        throwable.setStackTrace(UtilStackTrace.cutStacktraceByN(throwable.getStackTrace(), n));
        return throwable;
    }

    public static StackTraceElement[] cutStacktraceByN(StackTraceElement[] stacktrace, int n) {
        StackTraceElement[] st2 = new StackTraceElement[stacktrace.length - n];
        System.arraycopy(stacktrace, n, st2, 0, stacktrace.length - n);
        return st2;
    }

    public static <T extends Throwable> String getThrowingMethodName(T throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace.length > 0) {
            return stackTrace[0].getMethodName();
        }
        return "unkown method name";
    }
}

