/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util;

public interface Flag {
    public boolean set(boolean var1);

    public boolean on();

    public boolean off();

    public boolean isOn();

    public boolean isOff();

    public boolean toggle();

    public static Flag New() {
        return Flag.New(false);
    }

    public static Flag New(boolean state) {
        return new Simple(state);
    }

    public static final class Simple
    implements Flag {
        private boolean state;

        Simple(boolean state) {
            this.state = state;
        }

        @Override
        public boolean set(boolean state) {
            if (state) {
                this.on();
                return false;
            }
            this.off();
            return true;
        }

        @Override
        public boolean isOn() {
            return this.state;
        }

        @Override
        public boolean isOff() {
            return !this.state;
        }

        @Override
        public boolean on() {
            boolean current = this.state;
            this.state = true;
            return current;
        }

        @Override
        public boolean off() {
            boolean current = this.state;
            this.state = false;
            return current;
        }

        @Override
        public boolean toggle() {
            this.state = !this.state;
            return !this.state;
        }
    }
}

