/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.util;

import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.typing.Immutable;
import org.eclipse.serializer.typing.Stateless;
import org.eclipse.serializer.util.BufferSizeProvider;

public interface BufferSizeProviderIncremental
extends BufferSizeProvider {
    default public long provideIncrementalBufferSize() {
        return this.provideBufferSize();
    }

    public static BufferSizeProviderIncremental New() {
        return new Default();
    }

    public static BufferSizeProviderIncremental New(long bufferSize) {
        return BufferSizeProviderIncremental.New(bufferSize, bufferSize);
    }

    public static BufferSizeProviderIncremental New(long initialBufferSize, long incrementalBufferSize) {
        return new Sized(XMath.positive(initialBufferSize), XMath.positive(incrementalBufferSize));
    }

    public static final class Default
    implements BufferSizeProviderIncremental,
    Stateless {
    }

    public static final class Sized
    implements BufferSizeProviderIncremental,
    Immutable {
        private final long initialBufferSize;
        private final long incrementalBufferSize;

        Sized(long initialBufferSize, long incrementalBufferSize) {
            this.initialBufferSize = initialBufferSize;
            this.incrementalBufferSize = incrementalBufferSize;
        }

        @Override
        public final long provideBufferSize() {
            return this.initialBufferSize;
        }

        @Override
        public final long provideIncrementalBufferSize() {
            return this.incrementalBufferSize;
        }
    }
}

