/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.typing;

import org.eclipse.serializer.typing.Immutable;

public interface KeyValue<K, V> {
    public K key();

    public V value();

    public static <K, V> KeyValue<K, V> New(K key, V value) {
        return new Default<K, V>(key, value);
    }

    public static final class Default<K, V>
    implements KeyValue<K, V>,
    Immutable {
        final K key;
        final V value;

        Default(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return String.valueOf('[') + String.valueOf(this.key) + " -> " + String.valueOf(this.value) + ']';
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }
    }
}

