/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.reference;

import java.lang.ref.WeakReference;
import java.util.function.Consumer;
import org.eclipse.serializer.memory.MemoryStatistics;
import org.eclipse.serializer.monitoring.LazyReferenceManagerMonitor;
import org.eclipse.serializer.monitoring.MonitoringManager;
import org.eclipse.serializer.reference.Lazy;
import org.eclipse.serializer.reference._longReference;
import org.eclipse.serializer.time.XTime;
import org.eclipse.serializer.util.logging.Logging;
import org.slf4j.Logger;

public interface LazyReferenceManager {
    public void register(Lazy<?> var1);

    public LazyReferenceManager registerAll(LazyReferenceManager var1);

    public void cleanUp(long var1);

    default public void cleanUp() {
        this.cleanUp(Long.MAX_VALUE);
    }

    public void cleanUp(long var1, Lazy.Checker var3);

    default public void cleanUp(Lazy.Checker checker) {
        this.cleanUp(Long.MAX_VALUE, checker);
    }

    public void clear();

    public LazyReferenceManager start();

    public LazyReferenceManager stop();

    public LazyReferenceManager addController(Controller var1);

    public boolean removeController(Controller var1);

    public boolean isRunning();

    public <P extends Consumer<? super Lazy<?>>> P iterate(P var1);

    public <P extends Consumer<? super Controller>> P iterateControllers(P var1);

    public static LazyReferenceManager set(LazyReferenceManager referenceManager) {
        return Static.set(referenceManager);
    }

    public static LazyReferenceManager get() {
        return Static.get();
    }

    public static LazyReferenceManager New() {
        return LazyReferenceManager.New(Lazy.Checker());
    }

    public static LazyReferenceManager New(long millisecondTimeout) {
        return LazyReferenceManager.New(Lazy.Checker(millisecondTimeout));
    }

    public static LazyReferenceManager New(Lazy.Check customCheck) {
        return LazyReferenceManager.New(Lazy.Checker(customCheck));
    }

    public static LazyReferenceManager New(Lazy.Checker checker) {
        return LazyReferenceManager.New(checker, 1000L, 1000000L);
    }

    public static LazyReferenceManager New(Lazy.Checker checker, long milliTimeCheckInterval, long nanoTimeBudget) {
        return LazyReferenceManager.New(checker, _longReference.New(milliTimeCheckInterval), _longReference.New(nanoTimeBudget), MonitoringManager.New(null));
    }

    public static LazyReferenceManager New(Lazy.Checker checker, _longReference milliTimeCheckIntervalProvider, _longReference nanoTimeBudgetProvider, MonitoringManager monitoringManager) {
        return new Default(checker, milliTimeCheckIntervalProvider, nanoTimeBudgetProvider, monitoringManager);
    }

    public static final class Clearer
    implements Lazy.Checker {
        @Override
        public boolean check(Lazy<?> lazyReference) {
            lazyReference.clear();
            return true;
        }
    }

    @FunctionalInterface
    public static interface Controller {
        public boolean mayRun();
    }

    @FunctionalInterface
    public static interface CycleEvaluator {
        public void evaluateCycle(MemoryStatistics var1, long var2, double var4);
    }

    public static final class Default
    implements LazyReferenceManager {
        static final Logger logger = Logging.getLogger(Default.class);
        private static final Clearer CLEARER = new Clearer();
        static final long DEFAULT_CHECK_INTERVAL_MS = 1000L;
        static final long DEFAULT_TIME_BUDGET_NS = 1000000L;
        private final Lazy.Checker checker;
        private final _longReference millitimeCheckIntervalProvider;
        private final _longReference nanoTimeBudgetProvider;
        private final Entry head;
        private Entry tail;
        private Entry cursor;
        private boolean running;
        private ControllerEntry headController;
        private long controllerCount;
        private final MonitoringManager monitorManager;
        private final LazyReferenceManagerMonitor monitor;

        Default(Lazy.Checker checker, _longReference checkIntervalProvider, _longReference nanoTimeBudgetProvider, MonitoringManager monitorManager) {
            this.tail = this.head = new Entry(null);
            this.cursor = this.head;
            this.checker = checker;
            this.millitimeCheckIntervalProvider = checkIntervalProvider;
            this.nanoTimeBudgetProvider = nanoTimeBudgetProvider;
            this.monitorManager = monitorManager;
            this.monitor = new LazyReferenceManagerMonitor(this);
            this.monitorManager.registerMonitor(this.monitor);
        }

        private synchronized boolean mayRun() {
            if (this.headController == null) {
                return this.controllerCount == 0L;
            }
            Controller ac = (Controller)this.headController.get();
            if (ac == null) {
                this.headController = this.headController.consolidateSelf();
                return this.mayRun();
            }
            return ac.mayRun() ? true : this.headController.checkChain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void internalCleanUp(long nanoTimeBudget, Lazy.Checker checker) {
            Entry currentTail;
            long timeBudgetBound = XTime.calculateNanoTimeBudgetBound(nanoTimeBudget);
            Default default_ = this;
            synchronized (default_) {
                currentTail = this.tail;
            }
            Entry last = this.cursor;
            Entry e = last.nextLazyManagerEntry;
            if (e == null) {
                return;
            }
            checker.beginCheckCycle();
            do {
                Lazy ref;
                if ((ref = (Lazy)e.get()) != null) {
                    checker.check(ref);
                } else if (e != currentTail) {
                    e = last.nextLazyManagerEntry = e.nextLazyManagerEntry;
                    continue;
                }
                if (e == currentTail) {
                    last = this.head;
                    break;
                }
                last = e;
                e = last.nextLazyManagerEntry;
            } while (System.nanoTime() < timeBudgetBound);
            this.cursor = last;
            checker.endCheckCycle();
            this.updateStatistics();
        }

        private void updateStatistics() {
            int lazyReferences = 0;
            int loadedLazyReferences = 0;
            Entry e = this.head;
            while ((e = e.nextLazyManagerEntry) != null) {
                ++lazyReferences;
                if (!((Lazy)e.get()).isLoaded()) continue;
                ++loadedLazyReferences;
            }
            this.monitor.update(lazyReferences, loadedLazyReferences);
        }

        final void cleanUpBudgeted() {
            this.cleanUp(this.nanoTimeBudgetProvider.get());
        }

        @Override
        public synchronized void register(Lazy<?> lazyReference) {
            this.tail = this.tail.nextLazyManagerEntry = new Entry(lazyReference);
        }

        @Override
        public synchronized LazyReferenceManager registerAll(LazyReferenceManager other) {
            if (other == this) {
                throw new IllegalArgumentException("Other " + LazyReferenceManager.class.getSimpleName() + " may not be this.");
            }
            other.iterate(lr -> this.register((Lazy<?>)lr));
            other.iterateControllers(ac -> {
                LazyReferenceManager lazyReferenceManager = this.addController((Controller)ac);
            });
            return this;
        }

        @Override
        public void clear() {
            this.internalCleanUp(Long.MAX_VALUE, CLEARER);
        }

        @Override
        public void cleanUp(long nanoTimeBudget) {
            this.internalCleanUp(nanoTimeBudget, this.checker);
        }

        @Override
        public void cleanUp(long nanoTimeBudget, Lazy.Checker checker) {
            this.internalCleanUp(nanoTimeBudget, checker);
        }

        @Override
        public final synchronized boolean isRunning() {
            return this.running && this.mayRun();
        }

        @Override
        public synchronized LazyReferenceManager start() {
            if (!this.running && this.mayRun()) {
                this.running = true;
                new LazyReferenceCleanupThread(new WeakReference<Default>(this), this.millitimeCheckIntervalProvider).start();
            }
            return this;
        }

        @Override
        public synchronized LazyReferenceManager stop() {
            this.running = false;
            this.monitorManager.shutdown();
            return this;
        }

        @Override
        public final synchronized LazyReferenceManager addController(Controller controller) {
            if (controller == null) {
                return this;
            }
            if (this.headController == null) {
                this.headController = new ControllerEntry(controller);
                ++this.controllerCount;
                return this;
            }
            ControllerEntry current = this.headController;
            while (current.next != null) {
                if (current.get() == controller) {
                    return this;
                }
                current = current.next;
            }
            current.next = new ControllerEntry(controller);
            ++this.controllerCount;
            return this;
        }

        @Override
        public final synchronized boolean removeController(Controller controller) {
            ControllerEntry e;
            if (this.headController != null && this.headController.get() == controller) {
                this.headController = this.headController.next;
                --this.controllerCount;
                this.stopIfNoControllers();
                return true;
            }
            if (this.headController == null) {
                return false;
            }
            ControllerEntry last = this.headController;
            while ((e = last.next) != null) {
                if (e.get() == controller) {
                    last.next = e.next;
                    --this.controllerCount;
                    this.stopIfNoControllers();
                    return true;
                }
                last = e;
            }
            return false;
        }

        private void stopIfNoControllers() {
            if (this.controllerCount == 0L) {
                this.stop();
            }
        }

        @Override
        public <P extends Consumer<? super Controller>> P iterateControllers(P iterator) {
            ControllerEntry acc = this.headController;
            while (acc != null) {
                Controller ac = (Controller)acc.get();
                if (ac != null) {
                    iterator.accept((Controller)ac);
                }
                acc = acc.next;
            }
            return iterator;
        }

        @Override
        public synchronized <P extends Consumer<? super Lazy<?>>> P iterate(P iterator) {
            Entry e = this.head;
            while ((e = e.nextLazyManagerEntry) != null) {
                Lazy ref = (Lazy)e.get();
                if (ref == null) continue;
                iterator.accept((Lazy)ref);
            }
            return iterator;
        }

        static final class ControllerEntry
        extends WeakReference<Controller> {
            ControllerEntry next;

            ControllerEntry(Controller controller) {
                super(controller);
            }

            final boolean checkChain() {
                return this.next != null && this.next.isEnabled(this);
            }

            final boolean isEnabled(ControllerEntry last) {
                Controller controller = (Controller)this.get();
                if (controller == null) {
                    last.next = this.next;
                    if (last.next == null) {
                        return false;
                    }
                    return this.next.isEnabled(last);
                }
                if (controller.mayRun()) {
                    return true;
                }
                return this.next != null && this.next.isEnabled(this);
            }

            static final ControllerEntry consolidate(ControllerEntry root) {
                ControllerEntry current = root;
                while (current != null && current.get() == null) {
                    current = current.next;
                }
                if (current != null) {
                    current.consolidateTail();
                }
                return current;
            }

            final ControllerEntry consolidateSelf() {
                return ControllerEntry.consolidate(this);
            }

            final ControllerEntry consolidateTail() {
                this.next = ControllerEntry.consolidate(this.next);
                return this;
            }
        }

        static final class Entry
        extends WeakReference<Lazy<?>> {
            Entry nextLazyManagerEntry;

            public Entry(Lazy<?> referent) {
                super(referent);
            }
        }

        static final class LazyReferenceCleanupThread
        extends Thread {
            private final WeakReference<Default> parent;
            private final _longReference checkIntervalProvider;

            LazyReferenceCleanupThread(WeakReference<Default> parent, _longReference checkIntervalProvider) {
                super(String.valueOf(LazyReferenceManager.class.getSimpleName()) + '@' + System.identityHashCode(parent));
                this.parent = parent;
                this.checkIntervalProvider = checkIntervalProvider;
            }

            @Override
            public void run() {
                Default parent;
                logger.debug("LazyReferenceManager started");
                while ((parent = (Default)this.parent.get()) != null) {
                    try {
                        if (!parent.isRunning()) break;
                        parent.cleanUpBudgeted();
                        parent = null;
                        try {
                            Thread.sleep(this.checkIntervalProvider.get());
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                logger.debug("LazyReferenceManager stopped");
            }
        }
    }

    public static final class Static {
        static LazyReferenceManager globalReferenceManager = LazyReferenceManager.New();

        static synchronized LazyReferenceManager set(LazyReferenceManager referenceManager) {
            LazyReferenceManager old = globalReferenceManager;
            referenceManager.registerAll(old);
            globalReferenceManager = referenceManager;
            return old;
        }

        static synchronized LazyReferenceManager get() {
            return globalReferenceManager;
        }

        private Static() {
            throw new UnsupportedOperationException();
        }
    }
}

