/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.memory.android;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.eclipse.serializer.functional.DefaultInstantiator;
import org.eclipse.serializer.memory.DirectBufferDeallocator;
import org.eclipse.serializer.memory.android.AndroidDirectBufferDeallocator;
import org.eclipse.serializer.memory.android.AndroidInstantiatorBlank;
import org.eclipse.serializer.typing.XTypes;
import sun.misc.Unsafe;

public class AndroidInternals {
    static final Unsafe VM = AndroidInternals.getMemoryAccess();
    static final String METHOD_NAME_DirectByteBuffer_free = "free";
    static final Method METHOD_DirectByteBuffer_free = AndroidInternals.tryGetMethod(XTypes.directByteBufferClass(), "free");

    static final String fieldNameUnsafe() {
        return "theUnsafe";
    }

    public static final Unsafe getMemoryAccess() {
        if (AndroidInternals.class.getClassLoader() == null) {
            return Unsafe.getUnsafe();
        }
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField(AndroidInternals.fieldNameUnsafe());
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new Error("Could not obtain access to \"" + AndroidInternals.fieldNameUnsafe() + "\"", e);
        }
    }

    static final Method tryGetMethod(Class<?> type, String declaredMethodName) {
        Method method = null;
        try {
            method = type.getDeclaredMethod(declaredMethodName, new Class[0]);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public static final <T> T instantiateBlank(Class<T> c) {
        try {
            return (T)VM.allocateInstance(c);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final boolean internalDeallocateDirectBuffer(ByteBuffer directBuffer) {
        if (directBuffer == null) {
            return false;
        }
        if (METHOD_DirectByteBuffer_free == null) {
            return false;
        }
        XTypes.guaranteeDirectByteBuffer(directBuffer);
        try {
            METHOD_DirectByteBuffer_free.invoke((Object)directBuffer, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static final DefaultInstantiator InstantiatorBlank() {
        return AndroidInstantiatorBlank.New();
    }

    public static final DirectBufferDeallocator DirectBufferDeallocator() {
        return AndroidDirectBufferDeallocator.New();
    }
}

