/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.memory;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Predicate;
import org.eclipse.serializer.exceptions.InstantiationRuntimeException;
import org.eclipse.serializer.exceptions.UnhandledPlatformError;
import org.eclipse.serializer.memory.MemoryAccessor;
import org.eclipse.serializer.memory.MemorySizeProperties;
import org.eclipse.serializer.memory.android.AndroidAdapter;
import org.eclipse.serializer.memory.sun.JdkMemoryAccessor;
import org.eclipse.serializer.util.X;

public final class XMemory {
    public static MemoryAccessor MEMORY_ACCESSOR;
    public static MemoryAccessor MEMORY_ACCESSOR_REVERSED;
    static MemorySizeProperties MEMORY_SIZE_PROPERTIES;

    static {
        XMemory.initializeMemoryAccess();
    }

    private static VmCheck[] createVmChecks() {
        return X.array(XMemory.VmCheckEquality("Supported Standard Android", AndroidAdapter::setupFull, XMemory.entry("java.vendor", "The Android Project"), XMemory.entry("java.vm.vendor", "The Android Project")), XMemory.VmCheckContained("ERROR: UNHANDLED Android", XMemory::throwUnhandledPlatformException, XMemory.entry("java.vendor", "Android"), XMemory.entry("java.vm.vendor", " Android")), XMemory.VmCheckNotBlank("GraalVM native image", AndroidAdapter::setupFull, XMemory.entry("org.graalvm.nativeimage.imagecode")));
    }

    private static String systemPropertyToString(String key) {
        return String.valueOf(key) + ": " + System.getProperty(key, "[null]");
    }

    static final void throwUnhandledPlatformException() {
        throw new UnhandledPlatformError("Unhandled Java platform: " + XMemory.systemPropertyToString("java.vendor") + ", " + XMemory.systemPropertyToString("java.vm.vendor"));
    }

    private static String entry(String key) {
        return key;
    }

    private static String[] entry(String key, String value) {
        return new String[]{key, value};
    }

    private static void initializeMemoryAccess() {
        VmCheck[] vmChecks;
        VmCheck[] vmCheckArray = vmChecks = XMemory.createVmChecks();
        int n = vmChecks.length;
        int n2 = 0;
        while (n2 < n) {
            VmCheck vmCheck = vmCheckArray[n2];
            if (vmCheck.check()) {
                return;
            }
            ++n2;
        }
        XMemory.setMemoryHandling(JdkMemoryAccessor.New());
    }

    private static VmCheck VmCheckEquality(String name, Runnable action, String[] ... systemPropertyChecksEquality) {
        return new VmCheck(name, XMemory.SystemPropertyCheckEquality(systemPropertyChecksEquality), action);
    }

    private static VmCheck VmCheckContained(String name, Runnable action, String[] ... systemPropertyChecksContained) {
        return new VmCheck(name, XMemory.SystemPropertyCheckContained(systemPropertyChecksContained), action);
    }

    private static VmCheck VmCheckNotBlank(String name, Runnable action, String ... systemPropertyChecksNotNull) {
        return new VmCheck(name, XMemory.systemPropertyCheckNotBlank(systemPropertyChecksNotNull), action);
    }

    private static Predicate<VmCheck> SystemPropertyCheckEquality(String[][] systemPropertyChecksEquality) {
        return XMemory.SystemPropertyCheck(systemPropertyChecksEquality, new String[0][], new String[0]);
    }

    private static Predicate<VmCheck> SystemPropertyCheckContained(String[][] systemPropertyChecksContained) {
        return XMemory.SystemPropertyCheck(new String[0][], systemPropertyChecksContained, new String[0]);
    }

    private static Predicate<VmCheck> systemPropertyCheckNotBlank(String[] systemPropertyChecksNotBlank) {
        return XMemory.SystemPropertyCheck(new String[0][], new String[0][], systemPropertyChecksNotBlank);
    }

    private static Predicate<VmCheck> SystemPropertyCheck(String[][] systemPropertyChecksEquality, String[][] systemPropertyChecksContained, String[] systemPropertyChecksNotBlank) {
        return check -> {
            String[] s;
            String[][] stringArray4 = systemPropertyChecksEquality;
            int n = systemPropertyChecksEquality.length;
            int n2 = 0;
            while (n2 < n) {
                s = stringArray4[n2];
                if (s != null && System.getProperty(s[0], "").equals(s[1])) {
                    return true;
                }
                ++n2;
            }
            stringArray4 = systemPropertyChecksContained;
            n = systemPropertyChecksContained.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray4[n2];
                if (s != null && System.getProperty(s[0], "").toUpperCase().contains(s[1].toUpperCase())) {
                    return true;
                }
                ++n2;
            }
            stringArray4 = systemPropertyChecksNotBlank;
            n = systemPropertyChecksNotBlank.length;
            n2 = 0;
            while (n2 < n) {
                s = stringArray4[n2];
                if (s != null && !System.getProperty((String)s, "").isEmpty()) {
                    return true;
                }
                ++n2;
            }
            return false;
        };
    }

    public static final synchronized <H extends MemoryAccessor & MemorySizeProperties> void setMemoryHandling(H memoryHandler) {
        XMemory.setMemoryHandling(memoryHandler, memoryHandler);
    }

    public static final synchronized void setMemoryAccessor(MemoryAccessor memoryAccessor) {
        XMemory.setMemoryHandling(memoryAccessor, MemorySizeProperties.Unsupported());
    }

    public static final synchronized void setMemoryHandling(MemoryAccessor memoryAccessor, MemorySizeProperties memorySizeProperties) {
        MEMORY_ACCESSOR = X.notNull(memoryAccessor);
        MEMORY_ACCESSOR_REVERSED = X.notNull(memoryAccessor.toReversing());
        MEMORY_SIZE_PROPERTIES = X.notNull(memorySizeProperties);
    }

    public static final synchronized MemoryAccessor memoryAccessor() {
        return MEMORY_ACCESSOR;
    }

    public static final void guaranteeUsability() {
        MEMORY_ACCESSOR.guaranteeUsability();
    }

    public static final long getDirectByteBufferAddress(ByteBuffer directBuffer) {
        return MEMORY_ACCESSOR.getDirectByteBufferAddress(directBuffer);
    }

    public static final boolean deallocateDirectByteBuffer(ByteBuffer directBuffer) {
        return MEMORY_ACCESSOR.deallocateDirectByteBuffer(directBuffer);
    }

    public static final int defaultBufferSize() {
        return 4096;
    }

    public static final int byteSizeInstance(Class<?> c) {
        return MEMORY_SIZE_PROPERTIES.byteSizeInstance(c);
    }

    public static final int byteSizeObjectHeader(Class<?> c) {
        return MEMORY_SIZE_PROPERTIES.byteSizeObjectHeader(c);
    }

    public static final long byteSizeArrayObject(long elementCount) {
        return MEMORY_SIZE_PROPERTIES.byteSizeArrayObject(elementCount);
    }

    public static final int byteSizePrimitive(Class<?> type) {
        if (type == Integer.TYPE) {
            return XMemory.byteSize_int();
        }
        if (type == Long.TYPE) {
            return XMemory.byteSize_long();
        }
        if (type == Double.TYPE) {
            return XMemory.byteSize_double();
        }
        if (type == Character.TYPE) {
            return XMemory.byteSize_char();
        }
        if (type == Boolean.TYPE) {
            return XMemory.byteSize_boolean();
        }
        if (type == Byte.TYPE) {
            return XMemory.byteSize_byte();
        }
        if (type == Float.TYPE) {
            return XMemory.byteSize_float();
        }
        if (type == Short.TYPE) {
            return XMemory.byteSize_short();
        }
        throw new IllegalArgumentException();
    }

    public static final int byteSize_byte() {
        return 1;
    }

    public static final int byteSize_boolean() {
        return 1;
    }

    public static final int byteSize_short() {
        return 2;
    }

    public static final int byteSize_char() {
        return 2;
    }

    public static final int byteSize_int() {
        return 4;
    }

    public static final int byteSize_float() {
        return 4;
    }

    public static final int byteSize_long() {
        return 8;
    }

    public static final int byteSize_double() {
        return 8;
    }

    public static final int byteSizeReference() {
        return MEMORY_SIZE_PROPERTIES.byteSizeReference();
    }

    public static final long objectFieldOffset(Field field) {
        return MEMORY_ACCESSOR.objectFieldOffset(field);
    }

    public static final long[] objectFieldOffsets(Class<?> c, Field[] fields) {
        return MEMORY_ACCESSOR.objectFieldOffsets(c, fields);
    }

    public static final byte get_byte(long address) {
        return MEMORY_ACCESSOR.get_byte(address);
    }

    public static final boolean get_boolean(long address) {
        return MEMORY_ACCESSOR.get_boolean(address);
    }

    public static final short get_short(long address) {
        return MEMORY_ACCESSOR.get_short(address);
    }

    public static final char get_char(long address) {
        return MEMORY_ACCESSOR.get_char(address);
    }

    public static final int get_int(long address) {
        return MEMORY_ACCESSOR.get_int(address);
    }

    public static final float get_float(long address) {
        return MEMORY_ACCESSOR.get_float(address);
    }

    public static final long get_long(long address) {
        return MEMORY_ACCESSOR.get_long(address);
    }

    public static final double get_double(long address) {
        return MEMORY_ACCESSOR.get_double(address);
    }

    public static final byte get_byte(Object instance, long offset) {
        return MEMORY_ACCESSOR.get_byte(instance, offset);
    }

    public static final boolean get_boolean(Object instance, long offset) {
        return MEMORY_ACCESSOR.get_boolean(instance, offset);
    }

    public static final short get_short(Object instance, long offset) {
        return MEMORY_ACCESSOR.get_short(instance, offset);
    }

    public static final char get_char(Object instance, long offset) {
        return MEMORY_ACCESSOR.get_char(instance, offset);
    }

    public static final int get_int(Object instance, long offset) {
        return MEMORY_ACCESSOR.get_int(instance, offset);
    }

    public static final float get_float(Object instance, long offset) {
        return MEMORY_ACCESSOR.get_float(instance, offset);
    }

    public static final long get_long(Object instance, long offset) {
        return MEMORY_ACCESSOR.get_long(instance, offset);
    }

    public static final double get_double(Object instance, long offset) {
        return MEMORY_ACCESSOR.get_double(instance, offset);
    }

    public static final Object getObject(Object instance, long offset) {
        return MEMORY_ACCESSOR.getObject(instance, offset);
    }

    public static final void set_byte(long address, byte value) {
        MEMORY_ACCESSOR.set_byte(address, value);
    }

    public static final void set_boolean(long address, boolean value) {
        MEMORY_ACCESSOR.set_boolean(address, value);
    }

    public static final void set_short(long address, short value) {
        MEMORY_ACCESSOR.set_short(address, value);
    }

    public static final void set_char(long address, char value) {
        MEMORY_ACCESSOR.set_char(address, value);
    }

    public static final void set_int(long address, int value) {
        MEMORY_ACCESSOR.set_int(address, value);
    }

    public static final void set_float(long address, float value) {
        MEMORY_ACCESSOR.set_float(address, value);
    }

    public static final void set_long(long address, long value) {
        MEMORY_ACCESSOR.set_long(address, value);
    }

    public static final void set_double(long address, double value) {
        MEMORY_ACCESSOR.set_double(address, value);
    }

    public static final void set_byte(Object instance, long offset, byte value) {
        MEMORY_ACCESSOR.set_byte(instance, offset, value);
    }

    public static final void set_boolean(Object instance, long offset, boolean value) {
        MEMORY_ACCESSOR.set_boolean(instance, offset, value);
    }

    public static final void set_short(Object instance, long offset, short value) {
        MEMORY_ACCESSOR.set_short(instance, offset, value);
    }

    public static final void set_char(Object instance, long offset, char value) {
        MEMORY_ACCESSOR.set_char(instance, offset, value);
    }

    public static final void set_int(Object instance, long offset, int value) {
        MEMORY_ACCESSOR.set_int(instance, offset, value);
    }

    public static final void set_float(Object instance, long offset, float value) {
        MEMORY_ACCESSOR.set_float(instance, offset, value);
    }

    public static final void set_long(Object instance, long offset, long value) {
        MEMORY_ACCESSOR.set_long(instance, offset, value);
    }

    public static final void set_double(Object instance, long offset, double value) {
        MEMORY_ACCESSOR.set_double(instance, offset, value);
    }

    public static final void setObject(Object instance, long offset, Object value) {
        MEMORY_ACCESSOR.setObject(instance, offset, value);
    }

    public static final void set_shortInBytes(byte[] bytes, int index, short value) {
        MEMORY_ACCESSOR.set_shortInBytes(bytes, index, value);
    }

    public static final void set_charInBytes(byte[] bytes, int index, char value) {
        MEMORY_ACCESSOR.set_charInBytes(bytes, index, value);
    }

    public static final void set_intInBytes(byte[] bytes, int index, int value) {
        MEMORY_ACCESSOR.set_intInBytes(bytes, index, value);
    }

    public static final void set_floatInBytes(byte[] bytes, int index, float value) {
        MEMORY_ACCESSOR.set_floatInBytes(bytes, index, value);
    }

    public static final void set_longInBytes(byte[] bytes, int index, long value) {
        MEMORY_ACCESSOR.set_longInBytes(bytes, index, value);
    }

    public static final void set_doubleInBytes(byte[] bytes, int index, double value) {
        MEMORY_ACCESSOR.set_doubleInBytes(bytes, index, value);
    }

    public static final void copyRange(long sourceAddress, long targetAddress, long length) {
        MEMORY_ACCESSOR.copyRange(sourceAddress, targetAddress, length);
    }

    public static final void copyRangeToArray(long sourceAddress, byte[] target) {
        MEMORY_ACCESSOR.copyRangeToArray(sourceAddress, target);
    }

    public static final void copyRangeToArray(long sourceAddress, boolean[] target) {
        MEMORY_ACCESSOR.copyRangeToArray(sourceAddress, target);
    }

    public static final void copyRangeToArray(long sourceAddress, short[] target) {
        MEMORY_ACCESSOR.copyRangeToArray(sourceAddress, target);
    }

    public static final void copyRangeToArray(long sourceAddress, char[] target) {
        MEMORY_ACCESSOR.copyRangeToArray(sourceAddress, target);
    }

    public static final void copyRangeToArray(long sourceAddress, int[] target) {
        MEMORY_ACCESSOR.copyRangeToArray(sourceAddress, target);
    }

    public static final void copyRangeToArray(long sourceAddress, float[] target) {
        MEMORY_ACCESSOR.copyRangeToArray(sourceAddress, target);
    }

    public static final void copyRangeToArray(long sourceAddress, long[] target) {
        MEMORY_ACCESSOR.copyRangeToArray(sourceAddress, target);
    }

    public static final void copyRangeToArray(long sourceAddress, double[] target) {
        MEMORY_ACCESSOR.copyRangeToArray(sourceAddress, target);
    }

    public static final void copyArrayToAddress(byte[] array, long targetAddress) {
        MEMORY_ACCESSOR.copyArrayToAddress(array, targetAddress);
    }

    public static final void copyArrayToAddress(boolean[] array, long targetAddress) {
        MEMORY_ACCESSOR.copyArrayToAddress(array, targetAddress);
    }

    public static final void copyArrayToAddress(short[] array, long targetAddress) {
        MEMORY_ACCESSOR.copyArrayToAddress(array, targetAddress);
    }

    public static final void copyArrayToAddress(char[] array, long targetAddress) {
        MEMORY_ACCESSOR.copyArrayToAddress(array, targetAddress);
    }

    public static final void copyArrayToAddress(int[] array, long targetAddress) {
        MEMORY_ACCESSOR.copyArrayToAddress(array, targetAddress);
    }

    public static final void copyArrayToAddress(float[] array, long targetAddress) {
        MEMORY_ACCESSOR.copyArrayToAddress(array, targetAddress);
    }

    public static final void copyArrayToAddress(long[] array, long targetAddress) {
        MEMORY_ACCESSOR.copyArrayToAddress(array, targetAddress);
    }

    public static final void copyArrayToAddress(double[] array, long targetAddress) {
        MEMORY_ACCESSOR.copyArrayToAddress(array, targetAddress);
    }

    public static final void ensureClassInitialized(Class<?> c) {
        MEMORY_ACCESSOR.ensureClassInitialized(c);
    }

    public static final void ensureClassInitialized(Class<?> c, Iterable<Field> usedFields) {
        MEMORY_ACCESSOR.ensureClassInitialized(c, usedFields);
    }

    public static final <T> T instantiateBlank(Class<T> c) throws InstantiationRuntimeException {
        return MEMORY_ACCESSOR.instantiateBlank(c);
    }

    public static final ByteOrder nativeByteOrder() {
        return ByteOrder.nativeOrder();
    }

    public static final boolean isBigEndianNativeOrder() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    }

    public static final ByteBuffer allocateDirectNative(int capacity) throws IllegalArgumentException {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    public static final ByteBuffer allocateDirectNative(long capacity) throws IllegalArgumentException {
        return XMemory.allocateDirectNative(X.checkArrayRange(capacity));
    }

    public static final byte[] toArray(ByteBuffer source) {
        int currentSourcePosition = source.position();
        byte[] bytes = new byte[source.remaining()];
        source.get(bytes, 0, bytes.length);
        source.position(currentSourcePosition);
        return bytes;
    }

    public static final byte[] toArray(ByteBuffer[] sources) {
        int overallLength = 0;
        ByteBuffer[] byteBufferArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            ByteBuffer source = byteBufferArray[n2];
            overallLength += source.remaining();
            ++n2;
        }
        byte[] bytes = new byte[overallLength];
        int pos = 0;
        ByteBuffer[] byteBufferArray2 = sources;
        int n3 = sources.length;
        int n4 = 0;
        while (n4 < n3) {
            ByteBuffer source = byteBufferArray2[n4];
            int length = source.remaining();
            int currentSourcePosition = source.position();
            source.get(bytes, pos, length);
            pos += length;
            source.position(currentSourcePosition);
            ++n4;
        }
        return bytes;
    }

    public static final ByteBuffer toDirectByteBuffer(byte[] bytes) {
        ByteBuffer buffer = XMemory.allocateDirectNative(bytes.length);
        buffer.put(bytes);
        buffer.flip();
        return buffer;
    }

    public static final ByteBuffer slice(ByteBuffer source, long position, long limit) {
        ByteBuffer tmp = source.duplicate();
        tmp.limit((int)(position + limit)).position((int)position);
        return tmp.slice();
    }

    public static final long getPositionLimit(ByteBuffer buffer) {
        return ((long)buffer.position() << 32) + (long)buffer.limit();
    }

    public static final ByteBuffer setPositionLimit(ByteBuffer buffer, long positionLimit) {
        return XMemory.setPositionLimit(buffer, (int)(positionLimit >>> 32), (int)positionLimit);
    }

    public static final ByteBuffer setPositionLimit(ByteBuffer buffer, int position, int limit) {
        buffer.limit(limit);
        buffer.position(position);
        return buffer;
    }

    public static final void free(long address) {
        MEMORY_ACCESSOR.freeMemory(address);
    }

    public static final ByteBuffer allocateDirectNativeDefault() {
        return XMemory.allocateDirectNative(XMemory.defaultBufferSize());
    }

    public static final long allocate(long bytes) {
        return MEMORY_ACCESSOR.allocateMemory(bytes);
    }

    public static final ByteOrder parseByteOrder(String name) {
        if (name.equals(ByteOrder.BIG_ENDIAN.toString())) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (name.equals(ByteOrder.LITTLE_ENDIAN.toString())) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw new IllegalArgumentException("Unknown ByteOrder: \"" + name + "\"");
    }

    public static final byte[] toArray(ByteBuffer source, int position, int length) {
        long plState = XMemory.getPositionLimit(source);
        XMemory.setPositionLimit(source, position, position + length);
        byte[] bytes = new byte[length];
        source.get(bytes, 0, length);
        XMemory.setPositionLimit(source, plState);
        return bytes;
    }

    private XMemory() {
        throw new UnsupportedOperationException();
    }

    static final class VmCheck {
        final String name;
        final Predicate<VmCheck> tester;
        final Runnable action;

        VmCheck(String name, Predicate<VmCheck> tester, Runnable action) {
            this.name = name;
            this.tester = tester;
            this.action = action;
        }

        final boolean test() {
            return this.tester.test(this);
        }

        final boolean check() {
            if (this.test()) {
                this.action.run();
                return true;
            }
            return false;
        }
    }
}

