/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.functional;

import java.util.function.Predicate;
import org.eclipse.serializer.util.X;

public final class LimitedPredicate<E>
implements Predicate<E> {
    private final Predicate<? super E> predicate;
    private int skip;
    private int limit;

    public LimitedPredicate(Predicate<? super E> predicate, int skip, int limit) {
        this.predicate = X.notNull(predicate);
        this.skip = skip;
        this.limit = limit;
    }

    @Override
    public final boolean test(E e) {
        if (!this.predicate.test(e)) {
            return false;
        }
        if (this.skip > 0) {
            --this.skip;
            return false;
        }
        if (this.limit > 0) {
            --this.limit;
            return true;
        }
        throw X.BREAK();
    }
}

