/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.functional;

import java.lang.reflect.Constructor;
import org.eclipse.serializer.exceptions.InstantiationRuntimeException;
import org.eclipse.serializer.util.X;

public interface Instantiator<T> {
    public T instantiate() throws InstantiationRuntimeException;

    public static <T> Instantiator<T> WrapDefaultConstructor(Constructor<T> constructor) {
        return new WrappingDefaultConstructor<T>(X.notNull(constructor));
    }

    public static final class WrappingDefaultConstructor<T>
    implements Instantiator<T> {
        private final Constructor<T> constructor;

        WrappingDefaultConstructor(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        @Override
        public T instantiate() throws InstantiationRuntimeException {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new InstantiationRuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

