/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.exceptions;

public class TypeCastException
extends ClassCastException {
    private final Class<?> type;
    private final Object subject;
    private static final long serialVersionUID = -6986341469122765501L;

    public TypeCastException(Class<?> type, Object subject) {
        this(type, subject, null);
    }

    public TypeCastException(Class<?> type, Object subject, String message) {
        super(message);
        this.type = type;
        this.subject = subject;
    }

    public final Class<?> type() {
        return this.type;
    }

    public final Object subject() {
        return this.subject;
    }

    public final String message() {
        return super.getMessage();
    }

    public String assembleDetailString() {
        return "Cannot cast " + this.subject().getClass().getName() + " to " + this.type().getName();
    }

    protected String assembleExplicitMessageAddon() {
        String explicitMessage = super.getMessage();
        return explicitMessage == null ? "" : " (" + explicitMessage + ")";
    }

    public String assembleOutputString() {
        return String.valueOf(this.assembleDetailString()) + this.assembleExplicitMessageAddon();
    }

    @Override
    public String getMessage() {
        return this.assembleOutputString();
    }
}

