/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.equality;

import java.util.Comparator;
import java.util.function.Predicate;
import org.eclipse.serializer.hashing.XHashing;
import org.eclipse.serializer.util.X;

public interface Equalator<T> {
    public boolean equal(T var1, T var2);

    default public Predicate<T> sample(T sample) {
        return e -> this.equal(e, sample);
    }

    public static <E> Equalator<E> Wrap(Comparator<? super E> comparator) {
        return new ComparatorWrapper<E>(X.notNull(comparator));
    }

    @SafeVarargs
    public static <E> Equalator<E> Chain(Equalator<? super E> ... equalators) {
        return new Sequence<E>(X.notNull(equalators));
    }

    public static <E> Equalator<E> value() {
        return XHashing.hashEqualityValue();
    }

    public static <E> Equalator<E> identity() {
        return XHashing.hashEqualityIdentity();
    }

    public static final class ComparatorWrapper<T>
    implements Equalator<T> {
        private final Comparator<? super T> comparator;

        ComparatorWrapper(Comparator<? super T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public boolean equal(T object1, T object2) {
            return this.comparator.compare(object1, object2) == 0;
        }
    }

    public static interface Provider<T> {
        public Equalator<T> provideEqualator();
    }

    public static final class Sequence<T>
    implements Equalator<T> {
        private final Equalator<? super T>[] equalators;

        Sequence(Equalator<? super T>[] equalators) {
            this.equalators = equalators;
        }

        @Override
        public final boolean equal(T instance1, T instance2) {
            Equalator<? super T>[] equalatorArray = this.equalators;
            int n = this.equalators.length;
            int n2 = 0;
            while (n2 < n) {
                Equalator<T> equalator = equalatorArray[n2];
                if (!equalator.equal(instance1, instance2)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }
}

