/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.entity;

import java.time.Instant;
import org.eclipse.serializer.collections.types.XGettingTable;
import org.eclipse.serializer.entity.Entity;
import org.eclipse.serializer.entity.EntityLayer;
import org.eclipse.serializer.entity.EntityLayerProvider;
import org.eclipse.serializer.entity.EntityLayerProviderProvider;
import org.eclipse.serializer.entity.EntityLayerVersioning;
import org.eclipse.serializer.entity.EntityVersionCleaner;
import org.eclipse.serializer.hashing.HashEqualator;
import org.eclipse.serializer.hashing.XHashing;
import org.eclipse.serializer.util.X;

public interface EntityVersionContext<K>
extends EntityLayerProviderProvider {
    public static <K> EntityVersionContext<K> lookup(Entity entity) {
        EntityLayerVersioning versioningLayer = Entity.searchLayer(entity, EntityLayerVersioning.class);
        return versioningLayer != null ? versioningLayer.context : null;
    }

    public K currentVersion();

    default public K versionForUpdate() {
        return this.currentVersion();
    }

    public HashEqualator<? super K> equalator();

    public EntityVersionCleaner<K> cleaner();

    default public <E extends Entity> XGettingTable<K, E> versions(E entity) {
        Object layer = entity;
        while (layer instanceof EntityLayer) {
            if (layer instanceof EntityLayerVersioning) {
                return ((EntityLayerVersioning)layer).versions();
            }
            layer = ((EntityLayer)layer).inner();
        }
        return null;
    }

    @Override
    default public EntityLayerProvider provideEntityLayerProvider() {
        return e -> new EntityLayerVersioning(e, this);
    }

    public static <K> Mutable<K> Mutable() {
        return new Mutable.Default(null);
    }

    public static <K> Mutable<K> Mutable(EntityVersionCleaner<K> cleaner) {
        return new Mutable.Default<K>(cleaner);
    }

    public static EntityVersionContext<Integer> AutoIncrementingInt() {
        return new AutoIncrementing.IntIncrementor(null);
    }

    public static EntityVersionContext<Integer> AutoIncrementingInt(EntityVersionCleaner<Integer> cleaner) {
        return new AutoIncrementing.IntIncrementor(cleaner);
    }

    public static EntityVersionContext<Long> AutoIncrementingLong() {
        return new AutoIncrementing.LongIncrementor(null);
    }

    public static EntityVersionContext<Long> AutoIncrementingLong(EntityVersionCleaner<Long> cleaner) {
        return new AutoIncrementing.LongIncrementor(cleaner);
    }

    public static EntityVersionContext<Long> AutoIncrementingSystemTimeMillis() {
        return new AutoIncrementing.SystemTimeMillis(null);
    }

    public static EntityVersionContext<Long> AutoIncrementingSystemTimeMillis(EntityVersionCleaner<Long> cleaner) {
        return new AutoIncrementing.SystemTimeMillis(cleaner);
    }

    public static EntityVersionContext<Long> AutoIncrementingSystemNanoTime() {
        return new AutoIncrementing.SystemNanoTime(null);
    }

    public static EntityVersionContext<Long> AutoIncrementingSystemNanoTime(EntityVersionCleaner<Long> cleaner) {
        return new AutoIncrementing.SystemNanoTime(cleaner);
    }

    public static EntityVersionContext<Instant> AutoIncrementingInstant() {
        return new AutoIncrementing.InstantIncrementor(null);
    }

    public static EntityVersionContext<Instant> AutoIncrementingInstant(EntityVersionCleaner<Instant> cleaner) {
        return new AutoIncrementing.InstantIncrementor(cleaner);
    }

    public static abstract class Abstract<K>
    implements EntityVersionContext<K> {
        private final EntityVersionCleaner<K> cleaner;
        protected K key;

        protected Abstract(EntityVersionCleaner<K> cleaner) {
            this.cleaner = X.mayNull(cleaner);
        }

        @Override
        public K currentVersion() {
            return this.key;
        }

        @Override
        public HashEqualator<? super K> equalator() {
            return XHashing.hashEqualityValue();
        }

        @Override
        public EntityVersionCleaner<K> cleaner() {
            return this.cleaner;
        }
    }

    public static interface AutoIncrementing<K>
    extends EntityVersionContext<K> {
        @Override
        public K versionForUpdate();

        public static class InstantIncrementor
        extends Abstract<Instant>
        implements AutoIncrementing<Instant> {
            protected InstantIncrementor(EntityVersionCleaner<Instant> cleaner) {
                super(cleaner);
            }

            @Override
            public Instant versionForUpdate() {
                this.key = Instant.now();
                return this.key;
            }
        }

        public static class IntIncrementor
        extends Abstract<Integer>
        implements AutoIncrementing<Integer> {
            protected IntIncrementor(EntityVersionCleaner<Integer> cleaner) {
                super(cleaner);
            }

            @Override
            public Integer versionForUpdate() {
                this.key = this.key == null ? 0 : (Integer)this.key + 1;
                return this.key;
            }
        }

        public static class LongIncrementor
        extends Abstract<Long>
        implements AutoIncrementing<Long> {
            protected LongIncrementor(EntityVersionCleaner<Long> cleaner) {
                super(cleaner);
            }

            @Override
            public Long versionForUpdate() {
                this.key = this.key == null ? 0L : (Long)this.key + 1L;
                return this.key;
            }
        }

        public static class SystemNanoTime
        extends Abstract<Long>
        implements AutoIncrementing<Long> {
            protected SystemNanoTime(EntityVersionCleaner<Long> cleaner) {
                super(cleaner);
            }

            @Override
            public Long versionForUpdate() {
                this.key = System.nanoTime();
                return this.key;
            }
        }

        public static class SystemTimeMillis
        extends Abstract<Long>
        implements AutoIncrementing<Long> {
            protected SystemTimeMillis(EntityVersionCleaner<Long> cleaner) {
                super(cleaner);
            }

            @Override
            public Long versionForUpdate() {
                this.key = System.currentTimeMillis();
                return this.key;
            }
        }
    }

    public static interface Mutable<K>
    extends EntityVersionContext<K> {
        public EntityVersionContext<K> currentVersion(K var1);

        public static class Default<K>
        extends Abstract<K>
        implements Mutable<K> {
            protected Default(EntityVersionCleaner<K> cleaner) {
                super(cleaner);
            }

            @Override
            public EntityVersionContext<K> currentVersion(K key) {
                this.key = key;
                return this;
            }
        }
    }
}

