/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections.types;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.interfaces.CapacityCarrying;
import org.eclipse.serializer.collections.interfaces.ExtendedCollection;
import org.eclipse.serializer.collections.old.OldCollection;
import org.eclipse.serializer.collections.types.XFactory;
import org.eclipse.serializer.collections.types.XImmutableCollection;
import org.eclipse.serializer.collections.types.XIterable;
import org.eclipse.serializer.collections.types.XJoinable;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.functional.ToArrayAggregator;
import org.eclipse.serializer.typing.Copyable;
import org.eclipse.serializer.util.X;

public interface XGettingCollection<E>
extends XIterable<E>,
XJoinable<E>,
ExtendedCollection<E>,
Iterable<E>,
CapacityCarrying,
Copyable {
    public E get();

    @Override
    public Iterator<E> iterator();

    default public Object[] toArray() {
        return this.iterate(new ToArrayAggregator<Object>(new Object[X.checkArrayRange(this.size())])).yield();
    }

    default public E[] toArray(Class<E> type) {
        return this.iterate(new ToArrayAggregator<E>(X.Array(type, X.checkArrayRange(this.size())))).yield();
    }

    public OldCollection<E> old();

    @Override
    public boolean hasVolatileElements();

    @Override
    public long size();

    default public int intSize() {
        return X.checkArrayRange(this.size());
    }

    public Equalator<? super E> equality();

    public boolean equals(XGettingCollection<? extends E> var1, Equalator<? super E> var2);

    public boolean equalsContent(XGettingCollection<? extends E> var1, Equalator<? super E> var2);

    public XImmutableCollection<E> immure();

    public XGettingCollection<E> view();

    @Override
    public XGettingCollection<E> copy();

    public boolean nullContained();

    public boolean containsId(E var1);

    public boolean contains(E var1);

    public boolean containsSearched(Predicate<? super E> var1);

    default public boolean containsAll(XGettingCollection<? extends E> elements) {
        return elements.applies(this::contains);
    }

    public boolean applies(Predicate<? super E> var1);

    public long count(E var1);

    public long countBy(Predicate<? super E> var1);

    public E search(Predicate<? super E> var1);

    public E seek(E var1);

    public E max(Comparator<? super E> var1);

    public E min(Comparator<? super E> var1);

    public <T extends Consumer<? super E>> T distinct(T var1);

    public <T extends Consumer<? super E>> T distinct(T var1, Equalator<? super E> var2);

    public <T extends Consumer<? super E>> T copyTo(T var1);

    public <T extends Consumer<? super E>> T filterTo(T var1, Predicate<? super E> var2);

    public <T extends Consumer<? super E>> T union(XGettingCollection<? extends E> var1, Equalator<? super E> var2, T var3);

    public <T extends Consumer<? super E>> T intersect(XGettingCollection<? extends E> var1, Equalator<? super E> var2, T var3);

    public <T extends Consumer<? super E>> T except(XGettingCollection<? extends E> var1, Equalator<? super E> var2, T var3);

    @Override
    default public <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        this.iterate(e -> joiner.accept((Object)e, (Object)aggregate));
        return aggregate;
    }

    @Deprecated
    public boolean equals(Object var1);

    @Deprecated
    public int hashCode();

    public static interface Creator<E>
    extends XFactory<E> {
        @Override
        public XGettingCollection<E> newInstance();
    }
}

