/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections.lazy;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Spliterator;
import org.eclipse.serializer.collections.lazy.LazyHashMap;
import org.eclipse.serializer.collections.lazy.LazySegmentUnloader;

public final class LazyHashSet<T>
extends AbstractSet<T> {
    private final LazyHashMap<T, Object> map;
    private static final Object PRESENT = new Object();

    public LazyHashSet() {
        this.map = new LazyHashMap();
    }

    public LazyHashSet(int maxSegmentSize) {
        if (maxSegmentSize < 0) {
            throw new IllegalArgumentException("Illegal maxSegmentSize: " + maxSegmentSize + ". Must be 0 or greater!");
        }
        this.map = new LazyHashMap(maxSegmentSize);
    }

    public LazyHashSet(int maxSegmentSize, LazySegmentUnloader lazySegmentUnloader) {
        if (maxSegmentSize < 0) {
            throw new IllegalArgumentException("Illegal maxSegmentSize: " + maxSegmentSize + ". Must be 0 or greater!");
        }
        this.map = new LazyHashMap(maxSegmentSize, lazySegmentUnloader);
    }

    public long getSegmentCount() {
        return this.map.getSegmentCount();
    }

    public Iterable<? extends LazyHashMap.Segment<?>> segments() {
        return this.map.segments();
    }

    public int getMaxSegmentSize() {
        return this.map.getMaxSegmentSize();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(T e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.map.keySet().spliterator();
    }

    @Override
    public String toString() {
        Iterator<LazyHashMap.Segment<?>> iterator = this.map.segments().iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (iterator.hasNext()) {
            LazyHashMap.Segment<?> segment = iterator.next();
            sb.append("[");
            if (segment.isLoaded()) {
                Iterator entryItertor = ((ArrayList)segment.getData()).iterator();
                while (entryItertor.hasNext()) {
                    LazyHashMap.Entry entry = (LazyHashMap.Entry)entryItertor.next();
                    sb.append(entry.key);
                    if (!entryItertor.hasNext()) continue;
                    sb.append(',').append(' ');
                }
            } else {
                sb.append(" " + segment.size() + " unloaded Elements ");
            }
            sb.append("]");
        }
        return sb.append('}').toString();
    }
}

