/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.exceptions.ArrayCapacityException;
import org.eclipse.serializer.functional._intProcedure;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.typing.Composition;

public final class _intSet
implements Composition {
    private int size;
    private int range;
    private int capLower;
    private int capUpper;
    private int[][] lines;
    private boolean has0;

    public static final _intSet New() {
        return new _intSet();
    }

    public static final _intSet New(int ... values) {
        return _intSet.NewCustom(values.length).addAll(values);
    }

    public static final _intSet NewCustom(int initialCapacity) {
        return new _intSet(XMath.pow2BoundCapped(initialCapacity));
    }

    public static final _intSet NewCustom(int initialCapacity, int ... values) {
        return _intSet.NewCustom(initialCapacity).addAll(values);
    }

    private static void internalIncreaseLine(int[][] lines, int range, int[] line, int value) {
        int[] newLine = new int[line.length << 1];
        System.arraycopy(line, 0, newLine, 0, line.length);
        newLine[line.length] = value;
        lines[value & range] = newLine;
    }

    private static int[][] internalCreateLines() {
        return new int[1][];
    }

    private static int[][] internalCreateLines(int length) {
        return new int[length][];
    }

    private static int[] internalCreateLine(int initialValue) {
        return new int[]{initialValue};
    }

    private _intSet() {
        this.size = 0;
        this.lines = _intSet.internalCreateLines();
        this.range = 0;
        this.capLower = 0;
        this.capUpper = 1;
    }

    private _intSet(int uncheckedInitialCapacity) {
        this.capLower = uncheckedInitialCapacity >>> 1;
        this.capUpper = XMath.isGreaterThanOrEqualHighestPowerOf2(uncheckedInitialCapacity) ? Integer.MAX_VALUE : uncheckedInitialCapacity;
        this.range = uncheckedInitialCapacity - 1;
        this.lines = _intSet.internalCreateLines(uncheckedInitialCapacity);
        this.size = 0;
    }

    private void internalRebuildStorage(int newLength) {
        int[][] oldLines = this.lines;
        int[][] newLines = _intSet.internalCreateLines(newLength);
        int newRange = newLength - 1;
        int[][] nArray = oldLines;
        int n = oldLines.length;
        int n2 = 0;
        while (n2 < n) {
            int[] oldLine = nArray[n2];
            if (oldLine != null) {
                int[] nArray2 = oldLine;
                int n3 = oldLine.length;
                int n4 = 0;
                while (n4 < n3) {
                    block7: {
                        int value = nArray2[n4];
                        int[] newLine = newLines[value & newRange];
                        if (newLine == null) {
                            newLines[value & newRange] = _intSet.internalCreateLine(value);
                        } else {
                            int i = 0;
                            while (i < newLine.length) {
                                if (newLine[i] == 0) {
                                    newLine[i] = value;
                                    break block7;
                                }
                                ++i;
                            }
                            _intSet.internalIncreaseLine(newLines, newRange, newLine, value);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this.lines = newLines;
        this.range = newRange;
        this.capLower = newLength >> 1;
        this.capUpper = XMath.isGreaterThanOrEqualHighestPowerOf2(newLength) ? Integer.MAX_VALUE : newLength;
    }

    private void internalIncreaseLine(int[] line, int value) {
        this.internalCheckSize();
        _intSet.internalIncreaseLine(this.lines, this.range, line, value);
        this.internalIncrementSize();
    }

    private void internalAddToLine(int[] line, int index, int value) {
        this.internalCheckSize();
        line[index] = value;
        this.internalIncrementSize();
    }

    private void internalAddNewLine(int value) {
        this.internalCheckSize();
        this.lines[value & this.range] = _intSet.internalCreateLine(value);
        this.internalIncrementSize();
    }

    private boolean internalAdd0() {
        if (this.has0) {
            return false;
        }
        this.internalCheckSize();
        this.has0 = true;
        this.internalIncrementSize();
        return true;
    }

    private boolean internalRemove0() {
        if (this.has0) {
            this.has0 = false;
            this.internalDecrementSize();
            return true;
        }
        return false;
    }

    private void internalRemoveFromLine(int[] line, int index) {
        if (index < line.length - 1) {
            System.arraycopy(line, index + 1, line, index, line.length - index - 1);
        }
        line[line.length - 1] = 0;
        this.internalDecrementSize();
    }

    private void internalCheckSize() {
        if (this.size >= Integer.MAX_VALUE) {
            throw new ArrayCapacityException();
        }
    }

    private void internalIncrementSize() {
        if (this.size++ >= this.capUpper) {
            this.internalRebuildStorage(this.capUpper << 1);
        }
    }

    private void internalDecrementSize() {
        if (--this.size < this.capLower) {
            this.internalRebuildStorage(this.capLower);
        }
    }

    public final int size() {
        return this.size;
    }

    public final boolean contains(int value) {
        if (value == 0) {
            return this.has0;
        }
        int[] line = this.lines[value & this.range];
        if (line == null) {
            return false;
        }
        int[] nArray = line;
        int n = line.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == value) {
                return true;
            }
            if (i == 0) break;
            ++n2;
        }
        return false;
    }

    public final _intSet addAll(int ... values) {
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.add(i);
            ++n2;
        }
        return this;
    }

    public final boolean add(int value) {
        if (value == 0) {
            return this.internalAdd0();
        }
        int[] line = this.lines[value & this.range];
        if (line == null) {
            this.internalAddNewLine(value);
            return true;
        }
        int[] nArray = line;
        int n = line.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i == value) {
                return false;
            }
            if (i == 0) {
                this.internalAddToLine(line, i, value);
                return true;
            }
            ++n2;
        }
        this.internalIncreaseLine(line, value);
        return true;
    }

    public final boolean remove(int value) {
        if (value == 0) {
            return this.internalRemove0();
        }
        int[] line = this.lines[value & this.range];
        if (line == null) {
            return false;
        }
        int i = 0;
        while (i < line.length) {
            if (line[i] == value) {
                this.internalRemoveFromLine(line, i);
                return true;
            }
            if (line[0] == 0) break;
            ++i;
        }
        return false;
    }

    public final void clear() {
        int[][] lines = this.lines;
        int i = 0;
        while (i < lines.length) {
            lines[i] = null;
            ++i;
        }
        this.size = 0;
    }

    public final _intSet ensureFreeCapacity(int freeCapacity) {
        if (Integer.MAX_VALUE - freeCapacity < this.size) {
            throw new ArrayCapacityException();
        }
        if (this.capUpper - freeCapacity < this.size) {
            this.internalRebuildStorage(XMath.pow2BoundCapped(this.size + freeCapacity));
        }
        return this;
    }

    public final <P extends _intProcedure> P iterate(P procedure) {
        if (this.has0) {
            procedure.accept(0);
        }
        int[][] nArray = this.lines;
        int n = this.lines.length;
        int n2 = 0;
        while (n2 < n) {
            int[] line = nArray[n2];
            if (line != null) {
                int[] nArray2 = line;
                int n3 = line.length;
                int n4 = 0;
                while (n4 < n3) {
                    int value = nArray2[n4];
                    if (value == 0) break;
                    procedure.accept(value);
                    ++n4;
                }
            }
            ++n2;
        }
        return procedure;
    }

    public final int[] toArray() {
        int[] array = new int[this.size];
        int a = 0;
        if (this.has0) {
            array[a++] = 0;
        }
        int[][] nArray = this.lines;
        int n = this.lines.length;
        int n2 = 0;
        while (n2 < n) {
            int[] line = nArray[n2];
            if (line != null) {
                int[] nArray2 = line;
                int n3 = line.length;
                int n4 = 0;
                while (n4 < n3) {
                    int value = nArray2[n4];
                    if (value == 0) break;
                    array[a++] = value;
                    ++n4;
                }
            }
            ++n2;
        }
        return array;
    }

    public final String toString() {
        if (this.size == 0) {
            return "[]";
        }
        VarString vs = VarString.New((int)((float)this.size * 2.0f)).add('[');
        if (this.has0) {
            vs.add(0).add(',');
        }
        int[][] nArray = this.lines;
        int n = this.lines.length;
        int n2 = 0;
        while (n2 < n) {
            int[] line = nArray[n2];
            if (line != null) {
                int[] nArray2 = line;
                int n3 = line.length;
                int n4 = 0;
                while (n4 < n3) {
                    int value = nArray2[n4];
                    if (value == 0) break;
                    vs.add(value).add(',');
                    ++n4;
                }
            }
            ++n2;
        }
        return vs.setLast(']').toString();
    }
}

