/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.serializer.chars.VarString;
import org.eclipse.serializer.collections.AbstractArrayStorage;
import org.eclipse.serializer.collections.AbstractSimpleArrayCollection;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingList;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XMap;
import org.eclipse.serializer.collections.types.XSettingList;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.functional.AggregateMax;
import org.eclipse.serializer.functional.Aggregator;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.functional.IsCustomEqual;
import org.eclipse.serializer.functional.IsGreater;
import org.eclipse.serializer.functional.IsSmaller;
import org.eclipse.serializer.typing.XTypes;

public final class XUtilsArrayCollection {
    public static final <E, A extends AbstractSimpleArrayCollection<E>> A iterate(A a, Predicate<? super E> predicate, Consumer<? super E> procedure) {
        AbstractArrayStorage.forwardConditionalIterate(a.internalGetStorageArray(), XTypes.to_int(((XGettingCollection)((Object)a)).size()), 0, predicate, procedure);
        return a;
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngBinarySearch(A a, int offset, int length, E element, Comparator<? super E> comparator) {
        return AbstractArrayStorage.rangedBinarySearch(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, element, comparator);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> boolean rngHasUniqueValues(A a, int offset, int length) {
        return AbstractArrayStorage.rangedHasUniqueValues(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> boolean rngHasUniqueValues(A a, int offset, int length, Equalator<? super E> equalator) {
        return AbstractArrayStorage.rangedHasUniqueValues(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, equalator);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> boolean rngContainsAll(A a, int offset, int length, XGettingCollection<? extends E> elements) {
        return AbstractArrayStorage.rangedContainsAll(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, elements);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> E rngMax(A a, int offset, int length, Comparator<? super E> comparator) {
        return (E)AbstractArrayStorage.rangedAggregate(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, new AggregateMax<E>(comparator));
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> E rngMin(A a, int offset, int length, Comparator<? super E> comparator) {
        return (E)AbstractArrayStorage.rangedAggregate(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, new AggregateMax<E>(comparator));
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngIndexOf(A a, int offset, int length, E sample, Equalator<? super E> equalator) {
        return AbstractArrayStorage.rangedScan(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, new IsCustomEqual<E>(equalator, sample));
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngIndexOF(A a, int offset, int length, E element) {
        return AbstractArrayStorage.rangedIndexOF(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, element);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngCount(A a, int offset, int length, E sample, Equalator<? super E> equalator) {
        return AbstractArrayStorage.rangedConditionalCount(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, new IsCustomEqual<E>(equalator, sample));
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngCount(A a, int offset, int length, E element) {
        return AbstractArrayStorage.rangedCount(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, element);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> boolean rngIsSorted(A a, int offset, int length, Comparator<? super E> comparator) {
        return AbstractArrayStorage.rangedIsSorted(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, comparator);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>, C extends Consumer<? super E>> C rngCopyTo(A a, int offset, int length, C target) {
        return AbstractArrayStorage.rangedCopyTo(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, target);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> A rngIterate(A a, int offset, int length, Consumer<? super E> procedure) {
        AbstractArrayStorage.rangedIterate(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, procedure);
        return a;
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> A rngIterate(A a, int offset, int length, IndexedAcceptor<? super E> procedure) {
        AbstractArrayStorage.rangedIterate(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, procedure);
        return a;
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> A rngIterate(A a, int offset, int length, Predicate<? super E> predicate, Consumer<? super E> procedure) {
        AbstractArrayStorage.rangedConditionalIterate(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, predicate, procedure);
        return a;
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> E rngFind(A a, int offset, int length, E sample, Equalator<? super E> equalator) {
        return AbstractArrayStorage.rangedQueryElement(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, new IsCustomEqual<E>(equalator, sample), null);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> boolean rngContains(A a, int offset, int length, E element) {
        return AbstractArrayStorage.rangedContainsSame(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, element);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> boolean rngContainsId(A a, int offset, int length, E element) {
        return AbstractArrayStorage.rangedContainsSame(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, element);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> boolean rngContains(A a, int offset, int length, E sample, Equalator<? super E> equalator) {
        return AbstractArrayStorage.rangedContains(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, new IsCustomEqual<E>(equalator, sample));
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> boolean rngContains(A a, int offset, int length, Predicate<? super E> predicate) {
        return AbstractArrayStorage.rangedContains(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, predicate);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> boolean rngContainsNull(A a, int offset, int length) {
        return AbstractArrayStorage.rangedContainsNull(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> boolean rngApplies(A a, int offset, int length, Predicate<? super E> predicate) {
        return AbstractArrayStorage.rangedApplies(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, predicate);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngCount(A a, int offset, int length, Predicate<? super E> predicate) {
        return AbstractArrayStorage.rangedConditionalCount(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, predicate);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngIndexOf(A a, int offset, int length, Predicate<? super E> predicate) {
        return AbstractArrayStorage.rangedConditionalIndexOf(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, predicate);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngScan(A a, int offset, int length, Predicate<? super E> predicate) {
        return AbstractArrayStorage.rangedScan(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, predicate);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> E rngSearch(A a, int offset, int length, Predicate<? super E> predicate) {
        return AbstractArrayStorage.rangedQueryElement(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, predicate, null);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> E[] rngToArray(A a, int offset, int length, Class<E> type) {
        return AbstractArrayStorage.rangedToArray(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, type);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> Object[] rngToArray(A a, int offset, int length) {
        return AbstractArrayStorage.rangedToArray(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> boolean rngEqualsContent(A a, int offset, int length, XGettingList<? extends E> list, Equalator<? super E> equalator) {
        return AbstractArrayStorage.rangedEqualsContent(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, list, equalator);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>, R> R rngAggregate(A a, int offset, int length, Aggregator<? super E, R> aggregate) {
        AbstractArrayStorage.rangedIterate(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, aggregate);
        return aggregate.yield();
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> VarString rngAppendTo(A a, int offset, int length, VarString vc) {
        return AbstractArrayStorage.rangedAppendTo(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, vc);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> VarString rngAppendTo(A a, int offset, int length, VarString vc, String separator) {
        return AbstractArrayStorage.rangedAppendTo(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, vc, separator);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> VarString rngAppendTo(A a, int offset, int length, VarString vc, char separator) {
        return AbstractArrayStorage.rangedAppendTo(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, vc, separator);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> VarString rngAppendTo(A a, int offset, int length, VarString vc, BiConsumer<VarString, ? super E> appender) {
        return AbstractArrayStorage.rangedAppendTo(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, vc, appender);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> VarString rngAppendTo(A a, int offset, int length, VarString vc, BiConsumer<VarString, ? super E> appender, char separator) {
        return AbstractArrayStorage.rangedAppendTo(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, vc, appender, separator);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> VarString rngAppendTo(A a, int offset, int length, VarString vc, BiConsumer<VarString, ? super E> appender, String separator) {
        return AbstractArrayStorage.rangedAppendTo(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, vc, appender, separator);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngMaxIndex(A a, int offset, int length, Comparator<? super E> comparator) {
        return AbstractArrayStorage.rangedScan(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, new IsGreater<E>(comparator));
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngMinIndex(A a, int offset, int length, Comparator<? super E> comparator) {
        return AbstractArrayStorage.rangedScan(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, new IsSmaller<E>(comparator));
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>, C extends Consumer<? super E>> C rngDistinct(A a, int offset, int length, C target) {
        return AbstractArrayStorage.rangedDistinct(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, target);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>, C extends Consumer<? super E>> C rngDistinct(A a, int offset, int length, C target, Equalator<? super E> equalator) {
        return AbstractArrayStorage.rangedDistinct(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, target, equalator);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>, C extends Consumer<? super E>> C rngIntersect(A a, int offset, int length, XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.rangedIntersect(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, samples, equalator, target);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>, C extends Consumer<? super E>> C rngUnion(A a, int offset, int length, XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.rangedUnion(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, samples, equalator, target);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>, C extends Consumer<? super E>> C rngExcept(A a, int offset, int length, XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.rangedExcept(a.internalGetStorageArray(), XTypes.to_int(((XGettingSequence)((Object)a)).size()), offset, length, samples, equalator, target);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngReplaceOne(A a, int offset, int length, E oldElement, E newElement, Equalator<? super E> equalator) {
        return AbstractArrayStorage.rangedReplaceOne(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length, oldElement, newElement, equalator);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngReplaceOne(A a, int offset, int length, E oldElement, E newElement) {
        return AbstractArrayStorage.rangedReplaceOne(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length, oldElement, newElement);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> long rngReplace(A a, int offset, int length, E oldElement, E newElement, Equalator<? super E> equalator) {
        return AbstractArrayStorage.rangedReplace(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length, oldElement, newElement, equalator);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngReplace(A a, int offset, int length, E oldElement, E newElement) {
        return AbstractArrayStorage.rangedReplace(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length, oldElement, newElement);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngReplaceAll(A a, int offset, int length, XMap<E, E> replacementMapping) {
        return AbstractArrayStorage.rangedReplaceAll(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length, replacementMapping);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngReplaceAll(A a, int offset, int length, XGettingCollection<? extends E> oldElements, E newElement) {
        return AbstractArrayStorage.rangedReplaceAll(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length, oldElements, newElement);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngReplaceAll(A a, int offset, int length, XGettingCollection<? extends E> oldElements, E newElement, Equalator<? super E> equalator) {
        return AbstractArrayStorage.rangedReplaceAll(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length, oldElements, newElement, equalator);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngReplaceOne(A a, int offset, int length, Predicate<? super E> predicate, E newElement) {
        return AbstractArrayStorage.rangedReplaceOne(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length, predicate, newElement);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> int rngReplace(A a, int offset, int length, Predicate<? super E> predicate, E newElement) {
        return AbstractArrayStorage.rangedReplace(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length, predicate, newElement);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> XSettingList<E> rngSortQuick(A a, int offset, int length, Comparator<? super E> comparator) {
        AbstractArrayStorage.rangedSortQuick(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length, comparator);
        return (XSettingList)((Object)a);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> XSettingList<E> rngShuffle(A a, int offset, int length) {
        AbstractArrayStorage.rangedShuffle(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length);
        return (XSettingList)((Object)a);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> XSettingList<E> rngSortMerge(A a, int offset, int length, Comparator<? super E> comparator) {
        AbstractArrayStorage.rangedSortMerge(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length, comparator);
        return (XSettingList)((Object)a);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> XSettingList<E> rngSort(A a, int offset, int length, Comparator<? super E> comparator) {
        AbstractArrayStorage.rangedSort(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length, comparator);
        return (XSettingList)((Object)a);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> XSettingList<E> rngSortInsertion(A a, int offset, int length, Comparator<? super E> comparator) {
        AbstractArrayStorage.rangedSortInsertion(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length, comparator);
        return (XSettingList)((Object)a);
    }

    public static final <E, A extends AbstractSimpleArrayCollection<E>> XSettingList<E> rngReverse(A a, int offset, int length) {
        AbstractArrayStorage.rangedReverse(a.internalGetStorageArray(), XTypes.to_int(((XSettingList)((Object)a)).size()), offset, length);
        return (XSettingList)((Object)a);
    }

    private XUtilsArrayCollection() {
        throw new UnsupportedOperationException();
    }
}

