/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.serializer.collections.AbstractArrayStorage;
import org.eclipse.serializer.collections.AbstractSimpleArrayCollection;
import org.eclipse.serializer.collections.BulkList;
import org.eclipse.serializer.collections.HashEnum;
import org.eclipse.serializer.collections.IndexExceededException;
import org.eclipse.serializer.collections.types.XAddingCollection;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.exceptions.IndexBoundsException;
import org.eclipse.serializer.functional.XFunc;
import org.eclipse.serializer.functional._intProcedure;
import org.eclipse.serializer.functional._longProcedure;
import org.eclipse.serializer.math.FastRandom;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.UtilStackTrace;
import org.eclipse.serializer.util.X;

public final class XArrays {
    public static final void validateRange0toUpperBound(int upperBound, int offset, int length) {
        if (offset < 0 || offset >= upperBound) {
            throw new IndexExceededException(upperBound, offset);
        }
        if (length > 0 && offset + length > upperBound) {
            throw new IndexExceededException(upperBound, offset + length);
        }
        if (length < 0 && offset + length < -1) {
            throw new IndexExceededException(-1L, offset + length);
        }
    }

    private static String exceptionRange(int size, int startIndex, int length) {
        return "Range [" + (length < 0 ? String.valueOf(startIndex + length + 1) + ";" + startIndex : String.valueOf(startIndex) + ";" + (startIndex + length - 1)) + "] not in [0;" + (size - 1) + "]";
    }

    private static String exceptionIndexOutOfBounds(int size, int index) {
        return "Index: " + index + ", Size: " + size;
    }

    public static final int validateArrayIndex(int arrayLength, int index) {
        if (index < 0 || index >= arrayLength) {
            throw UtilStackTrace.cutStacktraceByOne(new ArrayIndexOutOfBoundsException(index));
        }
        return index;
    }

    public static final int validIndex(int index, Object[] array) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || array != null && index >= array.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return index;
    }

    public static final int validateArrayRange(Object[] array, int offset, int length) {
        return XArrays.validateArrayRange(array.length, offset, length);
    }

    public static final int validateArrayRange(int arrayLength, int offset, int length) {
        if (length >= 0) {
            if (offset < 0 || offset + length > arrayLength) {
                throw new IndexOutOfBoundsException(XArrays.exceptionRange(arrayLength, offset, length));
            }
            if (length == 0) {
                return 0;
            }
            return 1;
        }
        if (length < 0) {
            if (offset + length < -1 || offset >= arrayLength) {
                throw new IndexOutOfBoundsException(XArrays.exceptionRange(arrayLength, offset, length));
            }
            return -1;
        }
        if (offset < 0 || offset >= arrayLength) {
            throw new IndexOutOfBoundsException(XArrays.exceptionIndexOutOfBounds(arrayLength, offset));
        }
        return 0;
    }

    public static final void checkBounds(Object[] array, int start, int bound) {
        XArrays.checkBounds(array.length, start, bound);
    }

    public static final void checkBounds(int arrayLength, int start, int bound) {
        if (bound < 0 || bound > arrayLength) {
            throw new IndexExceededException(arrayLength, bound);
        }
        if (start < 0 || start >= bound) {
            throw new IndexExceededException(arrayLength, start);
        }
    }

    public static boolean hasNoContent(Object[] array) {
        return array == null || array.length == 0;
    }

    public static final <T> T[] fill(T[] array, Supplier<? extends T> supplier) {
        return XArrays.uncheckedFill(array, 0, array.length, supplier);
    }

    public static final <T> T[] fill(T[] array, int offset, int bound, Supplier<? extends T> supplier) {
        XArrays.checkBounds(array, offset, bound);
        return XArrays.uncheckedFill(array, offset, bound, supplier);
    }

    public static final <T> T[] uncheckedFill(T[] array, int offset, int bound, Supplier<? extends T> supplier) {
        int i = offset;
        while (i < bound) {
            array[i] = supplier.get();
            ++i;
        }
        return array;
    }

    public static final <T> T[] fill(T[] array, T fillElement, int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex >= array.length) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex < 0 || toIndex >= array.length) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        if (fromIndex < toIndex) {
            int i = fromIndex;
            while (i <= toIndex) {
                array[i++] = fillElement;
            }
        } else {
            int i = toIndex;
            while (fromIndex >= toIndex) {
                array[i--] = fillElement;
            }
        }
        return array;
    }

    public static final int[] fill(int[] array, int fillElement) {
        int length = array.length;
        int i = 0;
        while (i < length) {
            array[i] = fillElement;
            ++i;
        }
        return array;
    }

    public static final char[] fill(char[] array, char fillElement) {
        int length = array.length;
        int i = 0;
        while (i < length) {
            array[i] = fillElement;
            ++i;
        }
        return array;
    }

    public static final byte[] fill(byte[] array, byte fillElement) {
        int length = array.length;
        int i = 0;
        while (i < length) {
            array[i] = fillElement;
            ++i;
        }
        return array;
    }

    public static final float[] fill(float[] array, float fillElement) {
        int length = array.length;
        int i = 0;
        while (i < length) {
            array[i] = fillElement;
            ++i;
        }
        return array;
    }

    public static final double[] fill(double[] array, double fillElement) {
        int length = array.length;
        int i = 0;
        while (i < length) {
            array[i] = fillElement;
            ++i;
        }
        return array;
    }

    public static final <T> T[] clear(T[] array) {
        int length = array.length;
        int i = 0;
        while (i < length) {
            array[i] = null;
            ++i;
        }
        return array;
    }

    public static final <T> T[] replicate(T subject, int times) {
        T[] array = X.ArrayForElementType(subject, times);
        int i = 0;
        while (i < times) {
            array[i] = subject;
            ++i;
        }
        return array;
    }

    public static final <T> T[] subArray(T[] array, int offset, int length) {
        T[] newArray = X.ArrayOfSameType(array, length);
        System.arraycopy(array, offset, newArray, 0, length);
        return newArray;
    }

    public static final byte[] subArray(byte[] array, int offset, int length) {
        byte[] newArray = new byte[length];
        System.arraycopy(array, offset, newArray, 0, length);
        return newArray;
    }

    public static final char[] subArray(char[] array, int offset, int length) {
        char[] newArray = new char[length];
        System.arraycopy(array, offset, newArray, 0, length);
        return newArray;
    }

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        int length = array1.length;
        if (array2.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (array1[i] != array2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final <E> boolean equals(E[] array1, int startIndex1, E[] array2, int startIndex2, int length, Equalator<? super E> comparator) {
        int a = startIndex1;
        int b = startIndex2;
        int aBound = startIndex1 + length;
        while (a < aBound) {
            if (!comparator.equal(array1[a], array2[b])) {
                return false;
            }
            ++a;
            ++b;
        }
        return true;
    }

    public static final boolean equals(byte[] a, byte[] a2, int length) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null || a.length < length || a2.length < length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (a[i] != a2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T> T[] add(T[] array, T element) {
        T[] newArray = XArrays.enlarge(array, array.length + 1);
        newArray[array.length] = element;
        return newArray;
    }

    public static <T> T[] remove(T[] array, int i) {
        T[] newArray = X.ArrayOfSameType(array, array.length - 1);
        System.arraycopy(array, 0, newArray, 0, i);
        System.arraycopy(array, i + 1, newArray, i, array.length - i - 1);
        return newArray;
    }

    @SafeVarargs
    public static final <T> T[] add(T[] a1, T ... a2) {
        if (a1 == null) {
            return a2 == null ? null : (Object[])a2.clone();
        }
        if (a2 == null) {
            return (Object[])a1.clone();
        }
        T[] a = X.ArrayOfSameType(a1, a1.length + a2.length);
        System.arraycopy(a1, 0, a, 0, a1.length);
        System.arraycopy(a2, 0, a, a1.length, a2.length);
        return a;
    }

    public static final int[] add(int[] a1, int ... a2) {
        if (a1 == null) {
            return a2 == null ? null : (int[])a2.clone();
        }
        if (a2 == null) {
            return (int[])a1.clone();
        }
        int[] a = new int[a1.length + a2.length];
        System.arraycopy(a1, 0, a, 0, a1.length);
        System.arraycopy(a2, 0, a, a1.length, a2.length);
        return a;
    }

    public static final long[] add(long[] a1, long ... a2) {
        if (a1 == null) {
            return a2 == null ? null : (long[])a2.clone();
        }
        if (a2 == null) {
            return (long[])a1.clone();
        }
        long[] a = new long[a1.length + a2.length];
        System.arraycopy(a1, 0, a, 0, a1.length);
        System.arraycopy(a2, 0, a, a1.length, a2.length);
        return a;
    }

    @SafeVarargs
    public static final <T> T[] combine(T[] ... arrays) {
        if (arrays == null || arrays.length == 0) {
            return null;
        }
        return XArrays.combine(arrays[0].getClass().getComponentType(), arrays);
    }

    public static final <T, S extends T> T[] combine(Class<T> componentType, S[] ... arrays) {
        if (arrays == null || arrays.length == 0) {
            return null;
        }
        if (arrays.length == 1) {
            return (Object[])arrays[0].clone();
        }
        long totalLength = 0L;
        S[][] SArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            S[] array = SArray[n2];
            totalLength += (long)array.length;
            ++n2;
        }
        if (totalLength > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(totalLength));
        }
        Object[] combined = (Object[])Array.newInstance(componentType, (int)totalLength);
        int c = 0;
        int i = 0;
        while (c < arrays.length) {
            System.arraycopy(arrays[c], 0, combined, i, arrays[c].length);
            i += arrays[c].length;
            ++c;
        }
        return combined;
    }

    public static final int[] _intAdd(int[] a1, int ... a2) {
        if (a1 == null) {
            return a2 == null ? null : (int[])a2.clone();
        }
        if (a2 == null) {
            return (int[])a1.clone();
        }
        int[] a = new int[a1.length + a2.length];
        System.arraycopy(a1, 0, a, 0, a1.length);
        System.arraycopy(a2, 0, a, a1.length, a2.length);
        return a;
    }

    @SafeVarargs
    public static final <T> T[] merge(T[] a1, T ... a2) {
        if (a1 == null) {
            return a2 == null ? null : (Object[])a2.clone();
        }
        if (a2 == null) {
            return (Object[])a1.clone();
        }
        int a1Len = a1.length;
        BulkList<T> buffer = new BulkList<T>(a1);
        T[] TArray = a2;
        int n = a2.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                T e = TArray[n2];
                int i = 0;
                while (i < a1Len) {
                    if (e != a1[i]) {
                        ++i;
                        continue;
                    }
                    break block5;
                }
                buffer.add(e);
            }
            ++n2;
        }
        T[] newArray = buffer.toArray(a1.getClass().getComponentType());
        return newArray;
    }

    @SafeVarargs
    public static final <T> T[] ensureContained(T[] a1, T ... a2) {
        X.notNull(a1);
        if (a2 == null) {
            return a1;
        }
        T[] TArray = a2;
        int n = a2.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                T e2 = TArray[n2];
                T[] TArray2 = a1;
                int n3 = a1.length;
                int n4 = 0;
                while (n4 < n3) {
                    T e1 = TArray2[n4];
                    if (e2 != e1) {
                        ++n4;
                        continue;
                    }
                    break block4;
                }
                XAddingCollection merger = HashEnum.New(a1).addAll((Object[])a2);
                ?[] merged = ((HashEnum)merger).toArray(a1.getClass().getComponentType());
                return merged;
            }
            ++n2;
        }
        return a1;
    }

    public static final <T> T[] ensureContained(T[] ts, T t) {
        if (XArrays.contains(ts, t)) {
            return ts;
        }
        return XArrays.add(ts, t);
    }

    public static final <E> boolean contains(E[] array, E element) {
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            if (e == element) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final <E> boolean eqContains(E[] array, E element) {
        if (element == null) {
            E[] EArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                E e = EArray[n2];
                if (e == null) {
                    return true;
                }
                ++n2;
            }
        } else {
            E[] EArray = array;
            int n = array.length;
            int n3 = 0;
            while (n3 < n) {
                E e = EArray[n3];
                if (element.equals(e)) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public static final <T, S extends T> boolean contains(T[] array, S element, Equalator<? super T> cmp) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (cmp.equal(element, t)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final <E> boolean containsId(Collection<E> c, E element) {
        if (c instanceof XGettingCollection) {
            return ((XGettingCollection)((Object)c)).containsId(element);
        }
        for (E t : c) {
            if (t != element) continue;
            return true;
        }
        return false;
    }

    public static final <E> boolean containS(Collection<E> c, E element) {
        if (c instanceof XGettingCollection) {
            return ((XGettingCollection)((Object)c)).contains(element);
        }
        return c.contains(element);
    }

    public static final <E> boolean contains(Collection<? super E> c, E sample, Equalator<? super E> equalator) {
        if (c instanceof XGettingCollection) {
            return ((XGettingCollection)((Object)c)).containsSearched(XFunc.predicate(sample, equalator));
        }
        for (E t : c) {
            if (!equalator.equal(t, sample)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static <E> int removeAllFromArray(E[] array, int start, int bound, E e) throws ArrayIndexOutOfBoundsException {
        i = base = start;
        ** GOTO lbl13
        {
            ++i;
            do {
                if (i < bound && array[i] == e) continue block0;
                moveOffset = i;
                while (i < bound && array[i] != e) {
                    ++i;
                }
                moveLength = i - moveOffset;
                System.arraycopy(array, moveOffset, array, base, moveLength);
                base += moveLength;
lbl13:
                // 2 sources

            } while (i < bound);
        }
        i = base;
        while (i < bound) {
            array[i] = null;
            ++i;
        }
        return bound - base;
    }

    /*
     * Unable to fully structure code
     */
    public static int removeAllFromArray(int[] array, int start, int bound, int e) throws ArrayIndexOutOfBoundsException {
        i = base = start;
        ** GOTO lbl13
        {
            ++i;
            do {
                if (i < bound && array[i] == e) continue block0;
                moveOffset = i;
                while (i < bound && array[i] != e) {
                    ++i;
                }
                moveLength = i - moveOffset;
                System.arraycopy(array, moveOffset, array, base, moveLength);
                base += moveLength;
lbl13:
                // 2 sources

            } while (i < bound);
        }
        i = base;
        while (i < bound) {
            array[i] = -2147483648;
            ++i;
        }
        return bound - base;
    }

    @SafeVarargs
    public static final <E> E[] removeDuplicates(E ... elements) {
        return X.Enum(elements).toArray(elements.getClass().getComponentType());
    }

    public static <E> int removeAllFromArray(XGettingCollection<? extends E> elements, E[] array, int start, int bound) throws ArrayIndexOutOfBoundsException {
        int removeCount;
        if (elements.isEmpty()) {
            return 0;
        }
        E removeMarker = elements.get();
        try {
            elements.iterate(new ArrayElementRemover<E>(array, start, bound, removeMarker));
        }
        finally {
            removeCount = XArrays.removeAllFromArray(array, start, bound, removeMarker);
        }
        return removeCount;
    }

    /*
     * Unable to fully structure code
     */
    public static <E> int removeAllFromArray(E[] array, int start, int bound, E e, Equalator<? super E> equalator) throws ArrayIndexOutOfBoundsException {
        i = base = start;
        ** GOTO lbl13
        {
            ++i;
            do {
                if (i < bound && equalator.equal(array[i], e)) continue block0;
                moveOffset = i;
                while (i < bound && !equalator.equal(array[i], e)) {
                    ++i;
                }
                moveLength = i - moveOffset;
                System.arraycopy(array, moveOffset, array, base, moveLength);
                base += moveLength;
lbl13:
                // 2 sources

            } while (i < bound);
        }
        i = base;
        while (i < bound) {
            array[i] = null;
            ++i;
        }
        return bound - base;
    }

    /*
     * Unable to fully structure code
     */
    public static <E> int removeAllFromArray(E[] array, int start, int bound, XGettingCollection<? extends E> elements, Equalator<? super E> equalator) throws ArrayIndexOutOfBoundsException {
        currentMoveTargetIndex = start;
        while (currentMoveTargetIndex < bound && !elements.containsSearched(XFunc.predicate(array[currentMoveTargetIndex], equalator))) {
            ++currentMoveTargetIndex;
        }
        currentMoveSourceIndex = 0;
        currentMoveLength = 0;
        seekIndex = currentMoveTargetIndex;
        ** GOTO lbl19
        {
            ++seekIndex;
            do {
                if (seekIndex < bound && elements.containsSearched(XFunc.predicate(array[seekIndex], equalator))) continue block1;
                currentMoveSourceIndex = seekIndex;
                while (seekIndex < bound && !elements.containsSearched(XFunc.predicate(array[seekIndex], equalator))) {
                    ++seekIndex;
                }
                currentMoveLength = seekIndex - currentMoveSourceIndex;
                System.arraycopy(array, currentMoveSourceIndex, array, currentMoveTargetIndex, currentMoveLength);
                currentMoveTargetIndex += currentMoveLength;
lbl19:
                // 2 sources

            } while (seekIndex < bound);
        }
        i = currentMoveTargetIndex;
        while (i < bound) {
            array[i] = null;
            ++i;
        }
        return bound - currentMoveTargetIndex;
    }

    public static final <T> T[] reverse(T[] array) {
        int halfSize = array.length >> 1;
        int i = 0;
        int j = array.length - 1;
        while (i < halfSize) {
            T e = array[i];
            array[i] = array[j];
            array[j] = e;
            ++i;
            --j;
        }
        return array;
    }

    public static final <T> T[] toReversed(T[] array) {
        int len = array.length;
        T[] rArray = X.ArrayOfSameType(array, len);
        int i = 0;
        int r = len;
        while (i < len) {
            rArray[--r] = array[i];
            ++i;
        }
        return rArray;
    }

    public static final <T> T[] toReversed(T[] array, int offset, int length) {
        return length < 0 ? XArrays.reverseArraycopy(array, offset, X.ArrayOfSameType(array, -length), 0, -length) : XArrays.reverseArraycopy(array, offset + length - 1, X.ArrayOfSameType(array, length), 0, length);
    }

    public static final <T> T[] copy(T[] array) {
        T[] newArray = X.ArrayOfSameType(array, array.length);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static final <T, E extends T> T[] copyTo(XGettingCollection<E> source, T[] target) throws IndexBoundsException {
        return XArrays.copyTo(source, target, 0);
    }

    public static final <T, E extends T> T[] copyTo(XGettingCollection<E> source, T[] target, int targetOffset) throws IndexBoundsException {
        if (source.size() + (long)targetOffset > (long)target.length) {
            throw new IndexBoundsException((long)targetOffset, (long)target.length, source.size() + (long)targetOffset);
        }
        if (source instanceof AbstractSimpleArrayCollection) {
            E[] data = ((AbstractSimpleArrayCollection)((Object)source)).internalGetStorageArray();
            int size = ((AbstractSimpleArrayCollection)((Object)source)).internalSize();
            System.arraycopy(((AbstractSimpleArrayCollection)((Object)source)).internalGetStorageArray(), 0, data, targetOffset, size);
        } else {
            int t = targetOffset - 1;
            for (E e : source) {
                target[++t] = e;
            }
        }
        return target;
    }

    @SafeVarargs
    public static final <T> T[] shuffle(T ... data) {
        FastRandom random = new FastRandom();
        int i = data.length;
        while (i > 1) {
            T t = data[i - 1];
            int j = random.nextInt(i);
            data[i - 1] = data[j];
            data[j] = t;
            --i;
        }
        return data;
    }

    public static final <E> E[] shuffle(E[] array, int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex >= array.length || startIndex > endIndex) {
            throw new IndexOutOfBoundsException("Range [" + startIndex + ';' + endIndex + "] not in [0;" + (array.length - 1) + "].");
        }
        FastRandom random = new FastRandom();
        int i = endIndex;
        while (i > startIndex) {
            E t = array[i - 1];
            int j = random.nextInt(i);
            array[i - 1] = array[j];
            array[j] = t;
            --i;
        }
        return array;
    }

    public static final int[] shuffle(int ... data) {
        return XArrays.shuffle(new FastRandom(), data);
    }

    public static final int[] shuffle(FastRandom random, int ... data) {
        int i = data.length;
        while (i > 1) {
            int t = data[i - 1];
            int j = random.nextInt(i);
            data[i - 1] = data[j];
            data[j] = t;
            --i;
        }
        return data;
    }

    public static final long[] shuffle(long ... data) {
        return XArrays.shuffle(new FastRandom(), data);
    }

    public static final long[] shuffle(FastRandom random, long ... data) {
        int i = data.length;
        while (i > 1) {
            long t = data[i - 1];
            int j = random.nextInt(i);
            data[i - 1] = data[j];
            data[j] = t;
            --i;
        }
        return data;
    }

    public static <D, S extends D> D[] arraycopy(S[] src, int srcPos, D[] dest, int destPos, int length) {
        if (length < 0) {
            return XArrays.reverseArraycopy(src, srcPos, dest, destPos, -length);
        }
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static <T> T[] enlarge(T[] array, int newLength) {
        if (newLength <= array.length) {
            if (newLength == array.length) {
                return array;
            }
            throw new IllegalArgumentException();
        }
        T[] newArray = X.ArrayOfSameType(array, newLength);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static <T> T[] shrink(T[] array, int newLength) {
        if (newLength >= array.length) {
            if (newLength == array.length) {
                return array;
            }
            throw new IllegalArgumentException();
        }
        T[] newArray = X.ArrayOfSameType(array, newLength);
        System.arraycopy(array, 0, newArray, 0, newLength);
        return newArray;
    }

    public static <T> T removeFromIndex(T[] elements, int size, int i) {
        T removed = elements[i];
        if (i + 1 == size) {
            elements[i] = null;
        } else {
            System.arraycopy(elements, i + 1, elements, i, size - i - 1);
            elements[size - 1] = null;
        }
        return removed;
    }

    public static final boolean containsNull(Object[] data, int offset, int length) {
        int d;
        int endIndex;
        if (length >= 0) {
            if (offset < 0 || (endIndex = offset + length - 1) >= data.length) {
                throw new IndexOutOfBoundsException(XArrays.exceptionRange(data.length, offset, length));
            }
            if (length == 0) {
                return false;
            }
            d = 1;
        } else if (length < 0) {
            endIndex = offset + length + 1;
            if (endIndex < 0 || offset >= data.length) {
                throw new IndexOutOfBoundsException(XArrays.exceptionRange(data.length, offset, length));
            }
            d = -1;
        } else {
            if (offset < 0 || offset >= data.length) {
                throw new IndexOutOfBoundsException(XArrays.exceptionIndexOutOfBounds(data.length, offset));
            }
            return false;
        }
        int i = offset - d;
        while (i != endIndex) {
            if (data[i += d] != null) continue;
            return true;
        }
        return false;
    }

    public static <E> E[] copyRange(E[] elements, int offset, int length) {
        E[] copy = X.ArrayOfSameType(elements, length);
        System.arraycopy(elements, offset, copy, 0, length);
        return copy;
    }

    public static <E> E[] filter(E[] elements, Predicate<? super E> predicate) {
        return XArrays.filterTo(elements, new BulkList(), predicate).toArray(XArrays.componentType(elements));
    }

    public static <E, C extends Consumer<? super E>> C filterTo(E[] elements, C target, Predicate<? super E> predicate) {
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            if (predicate.test(e)) {
                target.accept(e);
            }
            ++n2;
        }
        return target;
    }

    public static <E> int replaceAllInArray(E[] data, int startLow, int boundHigh, E oldElement, E newElement) {
        int replaceCount = 0;
        int i = startLow;
        while (i < boundHigh) {
            if (data[i] == oldElement) {
                data[i] = newElement;
                ++replaceCount;
            }
            ++i;
        }
        return replaceCount;
    }

    public static <E> int replaceAllInArray(E[] data, int startLow, int boundHigh, E sample, Equalator<? super E> equalator, E newElement) {
        int replaceCount = 0;
        int i = startLow;
        while (i < boundHigh) {
            if (equalator.equal(data[i], sample)) {
                data[i] = newElement;
                ++replaceCount;
            }
            ++i;
        }
        return replaceCount;
    }

    public static <T> T[] and(T[] a1, T[] a2) {
        int length = XArrays.min(a1.length, a2.length);
        T[] target = X.ArrayOfSameType(a1, length);
        int i = 0;
        while (i < length) {
            target[i] = a1[i] != null && a2[i] != null ? a1[i] : null;
            ++i;
        }
        return target;
    }

    public static <T> T[] or(T[] a1, T[] a2) {
        int length = XArrays.min(a1.length, a2.length);
        T[] target = X.ArrayOfSameType(a1, length);
        int i = 0;
        while (i < length) {
            target[i] = a1[i] != null ? a1[i] : (a2[i] != null ? a2[i] : null);
            ++i;
        }
        return target;
    }

    public static <T> T[] not(T[] a1, T[] a2) {
        int length = XArrays.min(a1.length, a2.length);
        T[] target = X.ArrayOfSameType(a1, length);
        int i = 0;
        while (i < length) {
            target[i] = a2[i] == null ? a1[i] : null;
            ++i;
        }
        return target;
    }

    public static <T, S extends T> T[] orderByIndices(S[] elements, int[] indices, int indicesOffset, T[] target) throws IllegalArgumentException {
        if (indicesOffset < 0) {
            throw new ArrayIndexOutOfBoundsException(indicesOffset);
        }
        int targetLength = target.length;
        if (elements.length + indicesOffset > indices.length) {
            throw new ArrayIndexOutOfBoundsException(elements.length + indicesOffset);
        }
        int indicesBound = indicesOffset + elements.length;
        int i = indicesOffset;
        while (i < indicesBound) {
            if (indices[i] >= targetLength) {
                throw new ArrayIndexOutOfBoundsException(indices[i]);
            }
            ++i;
        }
        i = indicesOffset;
        while (i < indicesBound) {
            if (indices[i] >= 0) {
                target[indices[i]] = elements[i - indicesOffset];
            }
            ++i;
        }
        return target;
    }

    public static final int min(int ... data) {
        if (data.length == 0) {
            return 0;
        }
        int loopMinElement = data[0];
        int i = 1;
        while (i < data.length) {
            if (data[i] < loopMinElement) {
                loopMinElement = data[i];
            }
            ++i;
        }
        return loopMinElement;
    }

    public static final int max(int ... data) {
        if (data.length == 0) {
            return 0;
        }
        int loopMaxElement = data[0];
        int i = 1;
        while (i < data.length) {
            if (data[i] >= loopMaxElement) {
                loopMaxElement = data[i];
            }
            ++i;
        }
        return loopMaxElement;
    }

    public static final <T> boolean applies(T[] array, Predicate<? super T> predicate) {
        if (array.length == 0) {
            return false;
        }
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (predicate.test(t)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final <T> T search(T[] array, Predicate<? super T> predicate) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (predicate.test(t)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public static final <T> int count(T[] array, Predicate<? super T> predicate) {
        int count = 0;
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (predicate.test(t)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public static <D, S extends D> D[] reverseArraycopy(S[] src, int srcPos, D[] dest, int destPos, int length) {
        if (srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException(srcPos);
        }
        if (destPos < 0) {
            throw new ArrayIndexOutOfBoundsException(destPos);
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException(length);
        }
        if (srcPos - length < -1) {
            throw new ArrayIndexOutOfBoundsException(srcPos - length);
        }
        if (destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException(destPos + length);
        }
        int destBound = destPos + length;
        int s = srcPos;
        int d = destPos;
        while (d < destBound) {
            dest[d] = src[s];
            --s;
            ++d;
        }
        return dest;
    }

    public static int[] reverseArraycopy(int[] src, int srcPos, int[] dest, int destPos, int length) {
        if (srcPos >= src.length) {
            throw new ArrayIndexOutOfBoundsException(srcPos);
        }
        if (destPos < 0) {
            throw new ArrayIndexOutOfBoundsException(destPos);
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException(length);
        }
        if (srcPos - length < -1) {
            throw new ArrayIndexOutOfBoundsException(srcPos - length);
        }
        if (destPos + length > dest.length) {
            throw new ArrayIndexOutOfBoundsException(destPos + length);
        }
        int destBound = destPos + length;
        int s = srcPos;
        int d = destPos;
        while (d < destBound) {
            dest[d] = src[s];
            --s;
            ++d;
        }
        return dest;
    }

    public static final <T> T[] convertArray(Object[] objects, Class<T> type) throws ClassCastException {
        Object[] converted = (Object[])Array.newInstance(type, objects.length);
        int i = 0;
        while (i < objects.length) {
            converted[i] = objects[i];
            ++i;
        }
        return converted;
    }

    public static <E> Class<E> componentType(E[] array) {
        return array.getClass().getComponentType();
    }

    public static final int arrayHashCode(Object[] data, int size) {
        int hashCode = 1;
        int i = 0;
        while (i < size) {
            Object obj = data[i];
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            ++i;
        }
        return hashCode;
    }

    static final <E> boolean uncheckedContainsAll(E[] subject, int subjectLowOffset, int subjectHighBound, E[] elements, int elementsLowOffset, int elementsHighBound) {
        int ei = elementsLowOffset;
        while (ei < elementsHighBound) {
            block3: {
                E element = elements[ei];
                int di = subjectLowOffset;
                while (di < subjectHighBound) {
                    if (element != subject[di]) {
                        ++di;
                        continue;
                    }
                    break block3;
                }
                return false;
            }
            ++ei;
        }
        return true;
    }

    static final <E> boolean uncheckedContainsAll(E[] subject, int subjectLowOffset, int subjectHighBound, E[] elements, int elementsLowOffset, int elementsHighBound, Equalator<? super E> equalator) {
        int ei = elementsLowOffset;
        while (ei < elementsHighBound) {
            block3: {
                E element = elements[ei];
                int di = subjectLowOffset;
                while (di < subjectHighBound) {
                    if (!equalator.equal(element, subject[di])) {
                        ++di;
                        continue;
                    }
                    break block3;
                }
                return false;
            }
            ++ei;
        }
        return true;
    }

    public static final boolean contains(int[] values, int value) {
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            if (v == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <E, I extends Consumer<? super E>> I iterate(E[] elements, I iterator) {
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            iterator.accept(e);
            ++n2;
        }
        return iterator;
    }

    public static <E> void iterate(E[] elements, int offset, int length, Consumer<? super E> iterator) {
        AbstractArrayStorage.validateRange0toUpperBound(elements.length, offset, length);
        int i = offset;
        while (i < length) {
            iterator.accept(elements[i]);
            ++i;
        }
    }

    public static void iterate(int[] elements, _intProcedure iterator) {
        int[] nArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            iterator.accept(e);
            ++n2;
        }
    }

    public static void iterate(int[] elements, int offset, int length, _intProcedure iterator) {
        AbstractArrayStorage.validateRange0toUpperBound(elements.length, offset, length);
        int i = offset;
        while (i < length) {
            iterator.accept(elements[i]);
            ++i;
        }
    }

    public static void iterate(long[] elements, _longProcedure iterator) {
        long[] lArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            long e = lArray[n2];
            iterator.accept(e);
            ++n2;
        }
    }

    public static void iterate(long[] elements, int offset, int length, _longProcedure iterator) {
        AbstractArrayStorage.validateRange0toUpperBound(elements.length, offset, length);
        int i = offset;
        while (i < length) {
            iterator.accept(elements[i]);
            ++i;
        }
    }

    public static final <T, S> int indexOf(S sample, T[] array, BiPredicate<T, S> predicate) {
        int i = 0;
        while (i < array.length) {
            if (predicate.test(array[i], sample)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final <T> int indexOf(T element, T[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(byte value, byte[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(boolean value, boolean[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(short value, short[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(char value, char[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(int value, int[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(float value, float[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(long value, long[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(double value, double[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final int indexOf(byte[] data, byte[] subject) {
        return XArrays.indexOf(data, subject, 0);
    }

    public static final int indexOf(byte[] data, byte[] subject, int startIndex) {
        int bound = data.length - subject.length + 1;
        byte firstByte = subject[0];
        int i = startIndex;
        while (i < bound) {
            block4: {
                if (data[i] == firstByte) {
                    int j = 1;
                    while (j < subject.length) {
                        if (data[i + j] == subject[j]) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static final byte[] rebuild(byte[] oldArray, int newLength) {
        byte[] newArray = new byte[newLength];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newLength));
        return newArray;
    }

    public static final boolean[] rebuild(boolean[] oldArray, int newLength) {
        boolean[] newArray = new boolean[newLength];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newLength));
        return newArray;
    }

    public static final short[] rebuild(short[] oldArray, int newLength) {
        short[] newArray = new short[newLength];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newLength));
        return newArray;
    }

    public static final char[] rebuild(char[] oldArray, int newLength) {
        char[] newArray = new char[newLength];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newLength));
        return newArray;
    }

    public static final int[] rebuild(int[] oldArray, int newLength) {
        int[] newArray = new int[newLength];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newLength));
        return newArray;
    }

    public static final float[] rebuild(float[] oldArray, int newLength) {
        float[] newArray = new float[newLength];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newLength));
        return newArray;
    }

    public static final long[] rebuild(long[] oldArray, int newLength) {
        long[] newArray = new long[newLength];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newLength));
        return newArray;
    }

    public static final double[] rebuild(double[] oldArray, int newLength) {
        double[] newArray = new double[newLength];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newLength));
        return newArray;
    }

    public static final <E> E[] rebuild(E[] oldArray, int newLength) {
        E[] newArray = X.ArrayOfSameType(oldArray, newLength);
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newLength));
        return newArray;
    }

    public static final void set_byteInBytes(byte[] bytes, int index, byte value) {
        bytes[index] = value;
    }

    public static final void set_booleanInBytes(byte[] bytes, int index, boolean value) {
        bytes[index] = XTypes.to_byte(value);
    }

    public static final void set_shortInBytes(byte[] bytes, int index, short value) {
        XArrays.validateArrayIndex(bytes.length, index + 1);
        bytes[index] = (byte)(value >>> 0);
        bytes[index + 1] = (byte)(value >>> 8);
    }

    public static final void set_charInBytes(byte[] bytes, int index, char value) {
        XArrays.validateArrayIndex(bytes.length, index + 1);
        bytes[index] = (byte)(value >>> 0);
        bytes[index + 1] = (byte)(value >>> 8);
    }

    public static final void set_intInBytes(byte[] bytes, int index, int value) {
        XArrays.validateArrayIndex(bytes.length, index + 3);
        bytes[index + 0] = (byte)(value >>> 0);
        bytes[index + 1] = (byte)(value >>> 8);
        bytes[index + 2] = (byte)(value >>> 16);
        bytes[index + 3] = (byte)(value >>> 24);
    }

    public static final void set_floatInBytes(byte[] bytes, int index, float value) {
        XArrays.set_intInBytes(bytes, index, Float.floatToRawIntBits(value));
    }

    public static final void set_longInBytes(byte[] bytes, int index, long value) {
        XArrays.validateArrayIndex(bytes.length, index + 7);
        bytes[index + 0] = (byte)(value >>> 0);
        bytes[index + 1] = (byte)(value >>> 8);
        bytes[index + 2] = (byte)(value >>> 16);
        bytes[index + 3] = (byte)(value >>> 24);
        bytes[index + 4] = (byte)(value >>> 32);
        bytes[index + 5] = (byte)(value >>> 40);
        bytes[index + 6] = (byte)(value >>> 48);
        bytes[index + 7] = (byte)(value >>> 56);
    }

    public static final void set_doubleInBytes(byte[] bytes, int index, double value) {
        XArrays.set_longInBytes(bytes, index, Double.doubleToRawLongBits(value));
    }

    public static final int smoothCapacityIncrease(int oldCapacity) {
        return oldCapacity < 333 ? oldCapacity + 16 : (oldCapacity < 0x78787879 ? oldCapacity + (oldCapacity >> 4) : Integer.MAX_VALUE);
    }

    public static final int smoothCapacityDecrease(int oldCapacity) {
        return oldCapacity >= 333 ? oldCapacity - (oldCapacity >> 4) : (oldCapacity >= 16 ? oldCapacity - 16 : 0);
    }

    private XArrays() {
        throw new UnsupportedOperationException();
    }

    static final class ArrayElementRemover<E>
    implements Consumer<E> {
        private final E marker;
        private final E[] array;
        private final int start;
        private final int bound;

        public ArrayElementRemover(E[] array, int start, int bound, E removeMarker) {
            this.array = array;
            this.start = start;
            this.bound = bound;
            this.marker = removeMarker;
        }

        @Override
        public void accept(E e) {
            E marker = this.marker;
            E[] array = this.array;
            int bound = this.bound;
            int i = this.start;
            while (i < bound) {
                if (array[i] == e) {
                    array[i] = marker;
                }
                ++i;
            }
        }
    }
}

