/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.SubListView;
import org.eclipse.serializer.collections.XUtilsCollection;
import org.eclipse.serializer.collections.types.XDecreasingList;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XProcessingList;
import org.eclipse.serializer.collections.types.XSortableSequence;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.meta.NotImplementedYetError;
import org.eclipse.serializer.typing.XTypes;

public class SubListProcessor<E>
extends SubListView<E>
implements XDecreasingList<E> {
    public SubListProcessor(XProcessingList<E> list, long fromIndex, long toIndex) {
        super(list, fromIndex, toIndex);
    }

    private void internalClear() {
        this.size = 0L;
        this.length = 0L;
        this.d = 1;
    }

    private void decrement() {
        --this.size;
        this.length -= (long)this.d;
    }

    private void decrement(long amount) {
        this.size -= amount;
        this.length -= amount * (long)this.d;
    }

    @Override
    public final void clear() {
        ((XProcessingList)this.list).removeRange(this.startIndex, this.length);
        this.internalClear();
    }

    @Override
    public final <P extends Consumer<? super E>> P process(P procedure) {
        long oldListSize = ((XProcessingList)this.list).size();
        this.decrement(oldListSize - ((XProcessingList)this.list).size());
        return procedure;
    }

    @Override
    public final long removeDuplicates(Equalator<? super E> equalator) {
        long oldListSize = ((XProcessingList)this.list).size();
        long removeCount = oldListSize - ((XProcessingList)this.list).size();
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final long remove(E element) {
        long oldListSize = ((XProcessingList)this.list).size();
        long removeCount = oldListSize - ((XProcessingList)this.list).size();
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final long removeAll(XGettingCollection<? extends E> samples) {
        long oldListSize = ((XProcessingList)this.list).size();
        long removeCount = oldListSize - ((XProcessingList)this.list).size();
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final long removeDuplicates() {
        long oldListSize = ((XProcessingList)this.list).size();
        long removeCount = oldListSize - ((XProcessingList)this.list).size();
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final E retrieve(E element) {
        int oldListSize = XTypes.to_int(this.list.size());
        E e = XUtilsCollection.rngRetrieve((XProcessingList)this.list, this.startIndex, this.length, element);
        this.decrement(oldListSize - XTypes.to_int(this.list.size()));
        return e;
    }

    @Override
    public final E retrieveBy(Predicate<? super E> predicate) {
        int oldListSize = XTypes.to_int(this.list.size());
        E e = XUtilsCollection.rngRetrieve((XProcessingList)this.list, this.startIndex, this.length, predicate);
        this.decrement(oldListSize - XTypes.to_int(this.list.size()));
        return e;
    }

    @Override
    public final boolean removeOne(E element) {
        if (XUtilsCollection.rngRemoveOne((XProcessingList)this.list, this.startIndex, this.length, element)) {
            this.decrement();
            return true;
        }
        return false;
    }

    @Override
    public final long retainAll(XGettingCollection<? extends E> samples) {
        long oldListSize = ((XProcessingList)this.list).size();
        long removeCount = oldListSize - ((XProcessingList)this.list).size();
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final long removeBy(Predicate<? super E> predicate) {
        long oldListSize = ((XProcessingList)this.list).size();
        long removeCount = oldListSize - ((XProcessingList)this.list).size();
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final void truncate() {
        ((XProcessingList)this.list).removeRange(this.startIndex, this.length);
        this.internalClear();
    }

    @Override
    public final SubListProcessor<E> range(long fromIndex, long toIndex) {
        this.checkRange(fromIndex, toIndex);
        return new SubListProcessor<E>((XProcessingList)this.list, this.startIndex + fromIndex * (long)this.d, this.startIndex + toIndex * (long)this.d);
    }

    @Override
    public final long consolidate() {
        return ((XProcessingList)this.list).consolidate() > 0L ? 1 : 0;
    }

    @Override
    public final <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        long oldListSize = ((XProcessingList)this.list).size();
        this.decrement(oldListSize - ((XProcessingList)this.list).size());
        return target;
    }

    @Override
    public final long optimize() {
        return ((XProcessingList)this.list).optimize();
    }

    @Override
    public final <C extends Consumer<? super E>> C moveSelection(C target, long ... indices) {
        long oldListSize = ((XProcessingList)this.list).size();
        ((XProcessingList)this.list).moveSelection(target, this.shiftIndices(indices));
        this.decrement(oldListSize - ((XProcessingList)this.list).size());
        return target;
    }

    @Override
    public final E removeAt(long index) throws UnsupportedOperationException {
        this.checkIndex(index);
        Object element = ((XProcessingList)this.list).removeAt(index);
        this.decrement();
        return element;
    }

    @Override
    public final E fetch() {
        return this.removeAt(0L);
    }

    @Override
    public final E pop() {
        return this.removeAt(this.getEndIndex());
    }

    @Override
    public final E pinch() {
        return this.size == 0L ? null : (E)this.removeAt(0L);
    }

    @Override
    public final E pick() {
        return this.size == 0L ? null : (E)this.removeAt(this.getEndIndex());
    }

    @Override
    public final SubListProcessor<E> removeRange(long startIndex, long length) {
        this.checkVector(startIndex, length);
        int oldListSize = XTypes.to_int(this.list.size());
        ((XProcessingList)this.list).removeRange(this.startIndex + startIndex * (long)this.d, length * (long)this.d);
        this.decrement(oldListSize - XTypes.to_int(this.list.size()));
        return this;
    }

    @Override
    public final SubListProcessor<E> retainRange(long startIndex, long length) {
        this.checkVector(startIndex, length);
        int oldListSize = XTypes.to_int(this.list.size());
        ((XProcessingList)this.list).retainRange(this.startIndex + startIndex * (long)this.d, length * (long)this.d);
        this.decrement(oldListSize - XTypes.to_int(this.list.size()));
        return this;
    }

    @Override
    public final long removeSelection(long[] indices) {
        int oldListSize = XTypes.to_int(this.list.size());
        ((XProcessingList)this.list).removeSelection(this.shiftIndices(indices));
        int removeCount = oldListSize - XTypes.to_int(this.list.size());
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final SubListProcessor<E> toReversed() {
        return new SubListProcessor<E>((XProcessingList)this.list, this.getEndIndex(), this.startIndex);
    }

    @Override
    public final SubListProcessor<E> copy() {
        return new SubListProcessor<E>((XProcessingList)this.list, this.startIndex, this.getEndIndex());
    }

    @Override
    public final long nullRemove() {
        long oldListSize = ((XProcessingList)this.list).size();
        long removeCount = oldListSize - ((XProcessingList)this.list).size();
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final SubListView<E> view(long fromIndex, long toIndex) {
        this.checkRange(fromIndex, toIndex);
        return new SubListView(this.list, this.startIndex + fromIndex * (long)this.d, this.startIndex + toIndex * (long)this.d);
    }

    @Override
    public final OldSubListProcessor<E> old() {
        return new OldSubListProcessor(this);
    }

    @Override
    public final boolean replaceOne(E element, E replacement) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long replace(E element, E replacement) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long replaceAll(XGettingCollection<? extends E> elements, E replacement) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean replaceOne(Predicate<? super E> predicate, E substitute) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long replace(Predicate<? super E> predicate, E substitute) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long substitute(Function<? super E, ? extends E> mapper) {
        throw new NotImplementedYetError();
    }

    @Override
    public final long substitute(Predicate<? super E> predicate, Function<E, E> mapper) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean set(long index, E element) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        throw new NotImplementedYetError();
    }

    @Override
    public final E setGet(long index, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void setFirst(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void setLast(E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XSortableSequence<E> shiftTo(long sourceIndex, long targetIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XSortableSequence<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XSortableSequence<E> shiftBy(long sourceIndex, long distance) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XSortableSequence<E> shiftBy(long sourceIndex, long distance, long length) {
        throw new NotImplementedYetError();
    }

    @Override
    @SafeVarargs
    public final XDecreasingList<E> setAll(long index, E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XDecreasingList<E> set(long index, E[] elements, int offset, int length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XDecreasingList<E> set(long index, XGettingSequence<? extends E> elements, long offset, long length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XDecreasingList<E> swap(long indexA, long indexB) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XDecreasingList<E> swap(long indexA, long indexB, long length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XDecreasingList<E> reverse() {
        throw new NotImplementedYetError();
    }

    @Override
    public final XDecreasingList<E> fill(long offset, long length, E element) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XDecreasingList<E> sort(Comparator<? super E> comparator) {
        throw new NotImplementedYetError();
    }

    static class OldSubListProcessor<E>
    extends SubListView.OldSubListView<E> {
        OldSubListProcessor(SubListProcessor<E> list) {
            super(list);
        }

        @Override
        public final SubListProcessor<E> parent() {
            return (SubListProcessor)super.parent();
        }
    }
}

