/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import org.eclipse.serializer.collections.interfaces.OptimizableCollection;
import org.eclipse.serializer.functional._longIterable;
import org.eclipse.serializer.functional._longPredicate;
import org.eclipse.serializer.functional._longProcedure;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.typing.Composition;

public interface Set_long
extends OptimizableCollection,
Composition,
_longIterable {
    public boolean add(long var1);

    public boolean contains(long var1);

    public void clear();

    public void truncate();

    public Set_long filter(_longPredicate var1);

    public static Set_long New() {
        return new Default(Default.defaultSlotLength(), Default.defaultChainLength(), Default.defaultChainGrowthFactor());
    }

    public static Set_long New(int slotSize) {
        return new Default(slotSize, Default.defaultChainLength(), Default.defaultChainGrowthFactor());
    }

    public static Set_long New(int slotSize, int chainDefaultLength, float chainGrowthFactor) {
        return new Default(slotSize, chainDefaultLength, chainGrowthFactor);
    }

    public static final class Default
    implements Set_long {
        private long[][] hashSlots;
        private int hashRange;
        private int size;
        private final int chainInitialLength;
        private final float chainGrowthFactor;

        public static final int defaultSlotLength() {
            return 1;
        }

        public static final int defaultChainLength() {
            return 1;
        }

        public static final float defaultChainGrowthFactor() {
            return 1.1f;
        }

        Default(int slotSize, int chainDefaultLength, float chainGrowthFactor) {
            this.hashRange = XMath.pow2BoundCapped(slotSize) - 1;
            this.hashSlots = new long[this.hashRange + 1][];
            this.chainInitialLength = XMath.positive(chainDefaultLength);
            this.chainGrowthFactor = XMath.positive(chainGrowthFactor);
        }

        @Override
        public final long size() {
            return this.size;
        }

        @Override
        public final boolean isEmpty() {
            return this.size == 0;
        }

        private void rebuild(int newLength) {
            if (this.hashSlots.length >= newLength || newLength <= 0) {
                return;
            }
            int newRange = newLength - 1;
            long[][] oldSlots = this.hashSlots;
            long[][] newSlots = new long[newLength][];
            int i = 0;
            while (i < oldSlots.length) {
                if (oldSlots[i] != null) {
                    this.redistributeElements(newSlots, newRange, oldSlots[i]);
                }
                ++i;
            }
            this.hashSlots = newSlots;
            this.hashRange = newRange;
        }

        private void redistributeElements(long[][] newSlots, int newRange, long[] oldChain) {
            long[] lArray = oldChain;
            int n = oldChain.length;
            int n2 = 0;
            while (n2 < n) {
                long element = lArray[n2];
                this.addElement(newSlots, Default.hash(element, newRange), element);
                ++n2;
            }
        }

        private static int hash(long element, int hashRange) {
            return (int)(element & (long)hashRange);
        }

        private boolean addElement(long[][] hashSlots, int hashIndex, long element) {
            long[] chain = hashSlots[hashIndex];
            if (chain != null) {
                int n = 0;
                while (n < chain.length) {
                    if (chain[n] == 0L) {
                        chain[n] = element;
                        return true;
                    }
                    if (chain[n] == element) {
                        return false;
                    }
                    ++n;
                }
                hashSlots[hashIndex] = this.enlargeChain(chain, element);
                return true;
            }
            long[] lArray = new long[this.chainInitialLength];
            hashSlots[hashIndex] = lArray;
            lArray[0] = element;
            return true;
        }

        private long[] enlargeChain(long[] array, long newElement) {
            int newLength = (int)((float)array.length * this.chainGrowthFactor);
            long[] newArray = new long[Math.max(newLength, array.length + 1)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            newArray[array.length] = newElement;
            return newArray;
        }

        @Override
        public final boolean add(long element) {
            if (!this.addElement(this.hashSlots, Default.hash(element, this.hashRange), element)) {
                return false;
            }
            if (++this.size >= this.hashRange) {
                this.rebuild((int)((float)this.hashSlots.length * 2.0f));
            }
            return true;
        }

        @Override
        public final boolean contains(long element) {
            if (element != 0L) {
                long[] lArray = this.hashSlots[Default.hash(element, this.hashRange)];
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    long e = lArray[n2];
                    if (e == element) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        @Override
        public void iterate(_longProcedure procedure) {
            long[][] hashSlots = this.hashSlots;
            int i = 0;
            while (i < hashSlots.length) {
                if (hashSlots[i] != null) {
                    long[] lArray = hashSlots[i];
                    int n = lArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        long e = lArray[n2];
                        if (e == 0L) break;
                        procedure.accept(e);
                        ++n2;
                    }
                }
                ++i;
            }
        }

        @Override
        public long optimize() {
            this.rebuild(XMath.pow2BoundCapped(this.size));
            return this.size;
        }

        @Override
        public void clear() {
            long[][] slots = this.hashSlots;
            int i = 0;
            int len = slots.length;
            while (i < len) {
                slots[i] = null;
                ++i;
            }
            this.size = 0;
        }

        @Override
        public void truncate() {
            this.hashSlots = new long[1][];
            this.size = 0;
        }

        @Override
        public Default filter(_longPredicate selector) {
            Default result = new Default(1, this.chainInitialLength, this.chainGrowthFactor);
            this.iterate(e -> {
                if (selector.test(e)) {
                    result.add(e);
                }
            });
            return result;
        }
    }
}

