/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.ListView;
import org.eclipse.serializer.collections.old.AbstractBridgeXList;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingList;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XImmutableList;
import org.eclipse.serializer.collections.types.XList;
import org.eclipse.serializer.concurrency.Synchronized;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.iterables.SynchronizedIterator;
import org.eclipse.serializer.util.iterables.SynchronizedListIterator;

public final class LockedList<E>
implements XList<E>,
Synchronized {
    private final XList<E> subject;
    private final Object lock;

    public LockedList(XList<E> list) {
        this.subject = list;
        this.lock = list;
    }

    public LockedList(XList<E> list, Object lock) {
        this.subject = list;
        this.lock = lock;
    }

    @Override
    public final E get() {
        return this.subject.get();
    }

    @Override
    public final Equalator<? super E> equality() {
        return this.subject.equality();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void accept(E e) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.accept(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean add(E e) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SafeVarargs
    public final LockedList<E> addAll(E ... elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.addAll((Object[])elements);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> addAll(E[] elements, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.addAll((Object[])elements, offset, length);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> addAll(XGettingCollection<? extends E> elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.addAll((XGettingCollection)elements);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullAdd() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullAdd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean put(E e) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.put(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SafeVarargs
    public final LockedList<E> putAll(E ... elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.putAll((Object[])elements);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> putAll(E[] elements, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.putAll((Object[])elements, offset, length);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> putAll(XGettingCollection<? extends E> elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.putAll((XGettingCollection)elements);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullPut() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullPut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean prepend(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.prepend(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SafeVarargs
    public final LockedList<E> prependAll(E ... elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.prependAll((Object[])elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> prependAll(E[] elements, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.prependAll((Object[])elements, offset, length);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> prependAll(XGettingCollection<? extends E> elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.prependAll((XGettingCollection)elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullPrepend() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullPrepend();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean preput(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.preput(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SafeVarargs
    public final LockedList<E> preputAll(E ... elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.preputAll((Object[])elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> preputAll(E[] elements, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.preputAll((Object[])elements, offset, length);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> preputAll(XGettingCollection<? extends E> elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.preputAll((XGettingCollection)elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullPreput() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullPreput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean insert(long index, E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.insert(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SafeVarargs
    public final long insertAll(long index, E ... elements) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.insertAll(index, elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long insertAll(long index, E[] elements, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.insertAll(index, elements, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long insertAll(long index, XGettingCollection<? extends E> elements) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.insertAll(index, elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullInsert(long index) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullInsert(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean input(long index, E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.input(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SafeVarargs
    public final long inputAll(long index, E ... elements) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.inputAll(index, elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long inputAll(long index, E[] elements, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.inputAll(index, elements, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long inputAll(long index, XGettingCollection<? extends E> elements) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.inputAll(index, elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullInput(long index) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullInput(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean containsSearched(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.containsSearched(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean applies(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.applies(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.subject.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long consolidate() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.consolidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean contains(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.contains(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean containsAll(XGettingCollection<? extends E> elements) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.containsAll(elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean containsId(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.containsId(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> copy() {
        Object object = this.lock;
        synchronized (object) {
            return new LockedList<E>(this.subject.copy(), new Object());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final XImmutableList<E> immure() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.immure();
        }
    }

    @Override
    public final ListView<E> view() {
        return new ListView(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.copySelection(target, indices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.filterTo(target, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C copyTo(C target) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.copyTo(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long count(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.count(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long countBy(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.countBy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.distinct(target, equalator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C distinct(C target) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.distinct(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> ensureFreeCapacity(long minimalFreeCapacity) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.ensureFreeCapacity(minimalFreeCapacity);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> ensureCapacity(long minimalCapacity) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.ensureCapacity(minimalCapacity);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public final boolean equals(Object o) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.equals(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.equals(samples, equalator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.equalsContent(samples, equalator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.except(other, equalator, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.iterate(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.join(joiner, aggregate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.iterateIndexed(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> fill(long offset, long length, E element) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.fill(offset, length, (Object)element);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E at(long index) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.at(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E first() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E last() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.last();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E poll() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E peek() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public final int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasVolatileElements() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.hasVolatileElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long indexOf(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.indexOf(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long indexBy(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.indexBy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.intersect(other, equalator, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isSorted(Comparator<? super E> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.isSorted(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterator<E> iterator() {
        Object object = this.lock;
        synchronized (object) {
            return new SynchronizedIterator(this.subject.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long lastIndexBy(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.lastIndexBy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long lastIndexOf(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.lastIndexOf(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ListIterator<E> listIterator() {
        Object object = this.lock;
        synchronized (object) {
            return new SynchronizedListIterator(this.subject.listIterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ListIterator<E> listIterator(long index) {
        Object object = this.lock;
        synchronized (object) {
            return new SynchronizedListIterator(this.subject.listIterator(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E max(Comparator<? super E> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.max(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long maxIndex(Comparator<? super E> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.maxIndex(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E min(Comparator<? super E> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.min(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long minIndex(Comparator<? super E> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.minIndex(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C moveSelection(C target, long ... indices) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.moveSelection(target, indices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.moveTo(target, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <P extends Consumer<? super E>> P process(P procedure) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.process(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long removeBy(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.removeBy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long remove(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E removeAt(long index) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.removeAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long removeAll(XGettingCollection<? extends E> elements) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.removeAll(elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long removeDuplicates(Equalator<? super E> equalator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.removeDuplicates(equalator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long removeDuplicates() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.removeDuplicates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E fetch() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.fetch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E pop() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E pinch() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.pinch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E pick() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.pick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E retrieveBy(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.retrieveBy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E retrieve(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.retrieve(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeOne(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.removeOne(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> removeRange(long startIndex, long length) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.removeRange(startIndex, length);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> retainRange(long startIndex, long length) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.retainRange(startIndex, length);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long removeSelection(long[] indices) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.removeSelection(indices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long replace(E element, E replacement) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.replace(element, replacement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long replace(Predicate<? super E> predicate, E substitute) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.replace(predicate, (E)substitute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long substitute(Function<? super E, ? extends E> mapper) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.substitute(mapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long substitute(Predicate<? super E> predicate, Function<E, E> mapper) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.substitute(predicate, mapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long replaceAll(XGettingCollection<? extends E> elements, E replacement) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.replaceAll(elements, (E)replacement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean replaceOne(E element, E replacement) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.replaceOne(element, replacement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean replaceOne(Predicate<? super E> predicate, E substitute) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.replaceOne(predicate, (E)substitute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long retainAll(XGettingCollection<? extends E> elements) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.retainAll(elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> reverse() {
        Object object = this.lock;
        synchronized (object) {
            this.subject.reverse();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long scan(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.scan(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E seek(E sample) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.seek(sample);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E search(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.search(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SafeVarargs
    public final LockedList<E> setAll(long offset, E ... elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.setAll(offset, (Object[])elements);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean set(long index, E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E setGet(long index, E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.setGet(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> set(long offset, E[] src, int srcIndex, int srcLength) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.set(offset, (Object[])src, srcIndex, srcLength);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> set(long offset, XGettingSequence<? extends E> elements, long elementsOffset, long elementsLength) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.set(offset, (XGettingSequence)elements, elementsOffset, elementsLength);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setFirst(E element) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.setFirst(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setLast(E element) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.setLast(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long optimize() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.optimize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long size() {
        Object object = this.lock;
        synchronized (object) {
            return XTypes.to_int(this.subject.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> sort(Comparator<? super E> comparator) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.sort(comparator);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final XList<E> range(long fromIndex, long toIndex) {
        Object object = this.lock;
        synchronized (object) {
            return new LockedList<E>(this.subject.range(fromIndex, toIndex), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> swap(long indexA, long indexB, long length) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.swap(indexA, indexB, length);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> swap(long indexA, long indexB) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.swap(indexA, indexB);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E[] toArray(Class<E> type) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.toArray(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> toReversed() {
        Object object = this.lock;
        synchronized (object) {
            this.subject.toReversed();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void truncate() {
        Object object = this.lock;
        synchronized (object) {
            this.subject.truncate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.union(other, equalator, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long currentCapacity() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.currentCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long maximumCapacity() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.maximumCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isFull() {
        Object object = this.lock;
        synchronized (object) {
            return (long)XTypes.to_int(this.subject.size()) >= this.subject.maximumCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long remainingCapacity() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.remainingCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullAllowed() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullAllowed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullContained() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullContained();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long nullRemove() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullRemove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final XGettingList<E> view(long fromIndex, long toIndex) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.view(fromIndex, toIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> shiftTo(long sourceIndex, long targetIndex) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.shiftTo(sourceIndex, targetIndex);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.shiftTo(sourceIndex, targetIndex, length);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> shiftBy(long sourceIndex, long distance) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.shiftTo(sourceIndex, distance);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedList<E> shiftBy(long sourceIndex, long distance, long length) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.shiftTo(sourceIndex, distance, length);
        }
        return this;
    }

    @Override
    public final OldMutexList<E> old() {
        return new OldMutexList(this);
    }

    public static final class OldMutexList<E>
    extends AbstractBridgeXList<E> {
        OldMutexList(LockedList<E> list) {
            super(list);
        }

        @Override
        public final LockedList<E> parent() {
            return (LockedList)super.parent();
        }
    }
}

