/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import org.eclipse.serializer.collections.types.XAddingCollection;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.concurrency.Synchronized;
import org.eclipse.serializer.typing.XTypes;

public final class LockedAdder<E>
implements XAddingCollection<E>,
Synchronized {
    private final XAddingCollection<E> subject;
    private final Object lock;

    public LockedAdder(XAddingCollection<E> collection) {
        this.subject = collection;
        this.lock = collection;
    }

    public LockedAdder(XAddingCollection<E> collection, Object lock) {
        this.subject = collection;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullAdd() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullAdd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean add(E e) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SafeVarargs
    public final LockedAdder<E> addAll(E ... elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.addAll(elements);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedAdder<E> addAll(E[] elements, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.addAll(elements, offset, length);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedAdder<E> addAll(XGettingCollection<? extends E> elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.addAll(elements);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void accept(E e) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.accept(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedAdder<E> ensureFreeCapacity(long minimalFreeCapacity) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.ensureFreeCapacity(minimalFreeCapacity);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedAdder<E> ensureCapacity(long minimalCapacity) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.ensureCapacity(minimalCapacity);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long currentCapacity() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.currentCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long maximumCapacity() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.maximumCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isFull() {
        Object object = this.lock;
        synchronized (object) {
            return (long)XTypes.to_int(this.subject.size()) >= this.subject.maximumCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long remainingCapacity() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.remainingCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long optimize() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.optimize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasVolatileElements() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.hasVolatileElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullAllowed() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullAllowed();
        }
    }

    @Override
    public final boolean isEmpty() throws UnsupportedOperationException {
        Object object = this.lock;
        synchronized (object) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final long size() throws UnsupportedOperationException {
        Object object = this.lock;
        synchronized (object) {
            throw new UnsupportedOperationException();
        }
    }
}

