/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.serializer.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.serializer.collections.AbstractArrayStorage;
import org.eclipse.serializer.collections.AbstractSimpleArrayCollection;
import org.eclipse.serializer.collections.ConstList;
import org.eclipse.serializer.collections.IndexExceededException;
import org.eclipse.serializer.collections.ListView;
import org.eclipse.serializer.collections.SubListAccessor;
import org.eclipse.serializer.collections.SubListView;
import org.eclipse.serializer.collections.XArrays;
import org.eclipse.serializer.collections.XSort;
import org.eclipse.serializer.collections.old.AbstractOldSettingList;
import org.eclipse.serializer.collections.types.XGettingCollection;
import org.eclipse.serializer.collections.types.XGettingSequence;
import org.eclipse.serializer.collections.types.XSettingList;
import org.eclipse.serializer.equality.Equalator;
import org.eclipse.serializer.exceptions.IndexBoundsException;
import org.eclipse.serializer.functional.IndexedAcceptor;
import org.eclipse.serializer.math.XMath;
import org.eclipse.serializer.typing.Composition;
import org.eclipse.serializer.typing.XTypes;
import org.eclipse.serializer.util.X;
import org.eclipse.serializer.util.iterables.ReadOnlyListIterator;

public final class FixedList<E>
extends AbstractSimpleArrayCollection<E>
implements XSettingList<E>,
Composition {
    final Object[] data;

    private static String exceptionStringRange(long size, long startIndex, long length) {
        return "Range [" + (length < 0L ? String.valueOf(startIndex + length + 1L) + ";" + startIndex : String.valueOf(startIndex) + ";" + (startIndex + length - 1L)) + "] not in [0;" + (size - 1L) + "]";
    }

    public FixedList(int initialCapacity) {
        this.data = new Object[initialCapacity];
    }

    public FixedList(FixedList<? extends E> original) throws NullPointerException {
        this.data = (Object[])original.data.clone();
    }

    public FixedList(Collection<? extends E> elements) throws NullPointerException {
        this.data = elements.toArray();
    }

    public FixedList(XGettingCollection<? extends E> elements) throws NullPointerException {
        this.data = elements.toArray();
    }

    @SafeVarargs
    public FixedList(E ... elements) throws NullPointerException {
        this.data = (Object[])elements.clone();
    }

    public FixedList(E[] src, int srcStart, int srcLength) {
        this.data = new Object[srcLength];
        System.arraycopy(src, srcStart, this.data, 0, srcLength);
    }

    FixedList(Object[] internalData, int size) {
        this.data = internalData;
    }

    @Override
    protected E[] internalGetStorageArray() {
        return this.data;
    }

    @Override
    protected int internalSize() {
        return this.data.length;
    }

    @Override
    protected int[] internalGetSectionIndices() {
        int[] nArray = new int[2];
        nArray[1] = this.data.length;
        return nArray;
    }

    @Override
    public Equalator<? super E> equality() {
        return Equalator.identity();
    }

    @Override
    protected int internalCountingAddAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FixedList<E> copy() {
        return new FixedList<E>(this);
    }

    @Override
    public ConstList<E> immure() {
        return ConstList.New(this);
    }

    @Override
    public FixedList<E> toReversed() {
        Object[] rData = new Object[this.data.length];
        Object[] data = this.data;
        int i = data.length;
        int r = 0;
        while (i-- > 0) {
            rData[r++] = data[i];
        }
        return new FixedList<E>(rData, data.length);
    }

    @Override
    public E[] toArray(Class<E> type) {
        E[] array = X.Array(type, this.data.length);
        System.arraycopy(this.data, 0, array, 0, this.data.length);
        return array;
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.data.length, procedure);
        return procedure;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        AbstractArrayStorage.iterate(this.data, this.data.length, procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        AbstractArrayStorage.join(this.data, this.data.length, joiner, aggregate);
        return aggregate;
    }

    @Override
    public long count(E element) {
        return AbstractArrayStorage.forwardCount(this.data, 0, this.data.length, element);
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalCount(this.data, 0, this.data.length, predicate);
    }

    @Override
    public long indexOf(E element) {
        return AbstractArrayStorage.forwardIndexOf(this.data, 0, this.data.length, element);
    }

    @Override
    public long indexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardConditionalIndexOf(this.data, 0, this.data.length, predicate);
    }

    @Override
    public long lastIndexOf(E element) {
        return AbstractArrayStorage.rangedIndexOF(this.data, this.data.length, this.data.length - 1, -this.data.length, element);
    }

    @Override
    public long lastIndexBy(Predicate<? super E> predicate) {
        return AbstractArrayStorage.lastIndexOf(this.data, this.data.length, predicate);
    }

    @Override
    public long maxIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.maxIndex(this.data, this.data.length, comparator);
    }

    @Override
    public long minIndex(Comparator<? super E> comparator) {
        return AbstractArrayStorage.minIndex(this.data, this.data.length, comparator);
    }

    @Override
    public long scan(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardScan(this.data, 0, this.data.length, predicate);
    }

    @Override
    public E get() {
        return (E)this.data[0];
    }

    @Override
    public E first() {
        return (E)this.data[0];
    }

    @Override
    public E last() {
        return (E)this.data[this.data.length - 1];
    }

    @Override
    public E poll() {
        return (E)(this.data.length == 0 ? null : this.data[0]);
    }

    @Override
    public E peek() {
        return (E)(this.data.length == 0 ? null : this.data[this.data.length - 1]);
    }

    @Override
    public E seek(E sample) {
        return (E)(AbstractArrayStorage.forwardContainsSame(this.data, 0, this.data.length, sample) ? sample : null);
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardQueryElement(this.data, 0, this.data.length, predicate, null);
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        return AbstractArrayStorage.max(this.data, this.data.length, comparator);
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        return AbstractArrayStorage.min(this.data, this.data.length, comparator);
    }

    @Override
    public boolean hasVolatileElements() {
        return false;
    }

    @Override
    public boolean nullAllowed() {
        return true;
    }

    @Override
    public boolean isSorted(Comparator<? super E> comparator) {
        return AbstractArrayStorage.isSorted(this.data, this.data.length, comparator);
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardContains(this.data, 0, this.data.length, predicate);
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardApplies(this.data, 0, this.data.length, predicate);
    }

    @Override
    public boolean nullContained() {
        return AbstractArrayStorage.forwardNullContained(this.data, 0, this.data.length);
    }

    @Override
    public boolean containsId(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.data.length, element);
    }

    @Override
    public boolean contains(E element) {
        return AbstractArrayStorage.forwardContainsSame(this.data, 0, this.data.length, element);
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        return AbstractArrayStorage.containsAll(this.data, this.data.length, elements);
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || !(samples instanceof FixedList) || XTypes.to_int(samples.size()) != this.data.length) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return XArrays.equals(this.data, 0, ((FixedList)samples).data, 0, this.data.length, equalator);
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || XTypes.to_int(samples.size()) != this.data.length) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return AbstractArrayStorage.equalsContent(this.data, this.data.length, samples, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.intersect(this.data, this.data.length, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.except(this.data, this.data.length, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        return AbstractArrayStorage.union(this.data, this.data.length, samples, equalator, target);
    }

    @Override
    public <C extends Consumer<? super E>> C copyTo(C target) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.data.length, target);
    }

    @Override
    public <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return AbstractArrayStorage.forwardCopyTo(this.data, 0, this.data.length, target, predicate);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target) {
        return AbstractArrayStorage.distinct(this.data, this.data.length, target);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return AbstractArrayStorage.distinct(this.data, this.data.length, target, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        return AbstractArrayStorage.copySelection(this.data, this.data.length, indices, target);
    }

    @Override
    public SubListView<E> view(long fromIndex, long toIndex) {
        return new SubListView(this, fromIndex, toIndex);
    }

    @Override
    public FixedList<E> swap(long indexA, long indexB) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (indexA >= (long)this.data.length) {
            throw new IndexBoundsException((long)this.data.length, indexA);
        }
        if (indexB >= (long)this.data.length) {
            throw new IndexBoundsException((long)this.data.length, indexB);
        }
        Object t = this.data[(int)indexA];
        this.data[(int)indexA] = this.data[(int)indexB];
        this.data[(int)indexB] = t;
        return this;
    }

    @Override
    public FixedList<E> swap(long indexA, long indexB, long length) {
        AbstractArrayStorage.swap(this.data, this.data.length, X.checkArrayRange(indexA), X.checkArrayRange(indexB), X.checkArrayRange(length));
        return this;
    }

    @Override
    public FixedList<E> reverse() {
        AbstractArrayStorage.reverse(this.data, this.data.length);
        return this;
    }

    @Override
    public void setFirst(E element) {
        this.data[0] = element;
    }

    @Override
    public void setLast(E element) {
        this.data[this.data.length - 1] = element;
    }

    @Override
    public FixedList<E> setAll(long offset, E ... elements) {
        if (offset < 0L || offset + (long)elements.length > (long)this.data.length) {
            throw new IndexOutOfBoundsException(FixedList.exceptionStringRange(this.data.length, offset, offset + (long)elements.length - 1L));
        }
        System.arraycopy(elements, 0, this.data, X.checkArrayRange(offset), elements.length);
        return this;
    }

    @Override
    public FixedList<E> set(long offset, E[] src, int srcIndex, int srcLength) {
        AbstractArrayStorage.set(this.data, this.data.length, X.checkArrayRange(offset), src, srcIndex, srcLength);
        return this;
    }

    @Override
    public FixedList<E> set(long offset, XGettingSequence<? extends E> elements, long elementsOffset, long elementsLength) {
        AbstractArrayStorage.set(this.data, this.data.length, X.checkArrayRange(offset), elements, elementsOffset, elementsLength);
        return this;
    }

    @Override
    public FixedList<E> fill(long offset, long length, E element) {
        AbstractArrayStorage.fill(this.data, this.data.length, X.checkArrayRange(offset), X.checkArrayRange(length), element);
        return this;
    }

    @Override
    public FixedList<E> sort(Comparator<? super E> comparator) {
        XSort.mergesort(this.data, 0, this.data.length, comparator);
        return this;
    }

    @Override
    public boolean replaceOne(E element, E replacement) {
        return AbstractArrayStorage.replaceOne(this.data, this.data.length, element, replacement);
    }

    @Override
    public boolean replaceOne(Predicate<? super E> predicate, E substitute) {
        return AbstractArrayStorage.substituteOne(this.data, this.data.length, predicate, substitute);
    }

    @Override
    public long replace(E element, E replacement) {
        return AbstractArrayStorage.replace(this.data, this.data.length, element, replacement);
    }

    @Override
    public long replace(Predicate<? super E> predicate, E substitute) {
        return AbstractArrayStorage.substitute(this.data, this.data.length, predicate, substitute);
    }

    @Override
    public long replaceAll(XGettingCollection<? extends E> elements, E replacement) {
        return AbstractArrayStorage.replaceAll(this.data, this.data.length, elements, replacement, FixedList.marker());
    }

    @Override
    public long substitute(Function<? super E, ? extends E> mapper) {
        return AbstractArrayStorage.substitute(this.data, this.data.length, mapper);
    }

    @Override
    public long substitute(Predicate<? super E> predicate, Function<E, E> mapper) {
        return AbstractArrayStorage.substitute(this.data, this.data.length, predicate, mapper);
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(long index) {
        FixedList.validateIndex(this.data.length, index);
        return new ReadOnlyListIterator(this, (int)index);
    }

    @Override
    public boolean set(long index, E element) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= (long)this.data.length) {
            throw new IndexBoundsException((long)this.data.length, index);
        }
        this.data[(int)index] = element;
        return false;
    }

    @Override
    public E setGet(long index, E element) throws IndexOutOfBoundsException, ArrayIndexOutOfBoundsException {
        if (index >= (long)this.data.length) {
            throw new IndexBoundsException((long)this.data.length, index);
        }
        Object old = this.data[(int)index];
        this.data[(int)index] = element;
        return (E)old;
    }

    @Override
    public long size() {
        return this.data.length;
    }

    @Override
    public long maximumCapacity() {
        return this.data.length;
    }

    @Override
    public boolean isFull() {
        return true;
    }

    @Override
    public long remainingCapacity() {
        return 0L;
    }

    @Override
    public ListView<E> view() {
        return new ListView(this);
    }

    @Override
    public FixedList<E> shiftTo(long sourceIndex, long targetIndex) {
        if (sourceIndex >= (long)this.data.length) {
            throw new IndexExceededException(this.data.length, sourceIndex);
        }
        if (targetIndex >= (long)this.data.length) {
            throw new IndexExceededException(this.data.length, targetIndex);
        }
        if (sourceIndex == targetIndex) {
            if (sourceIndex < 0L) {
                throw new IndexExceededException(this.data.length, sourceIndex);
            }
            return this;
        }
        Object shiftling = this.data[(int)sourceIndex];
        if (sourceIndex < targetIndex) {
            System.arraycopy(this.data, (int)sourceIndex + 1, this.data, (int)sourceIndex, (int)targetIndex - (int)sourceIndex);
        } else {
            System.arraycopy(this.data, (int)targetIndex, this.data, (int)targetIndex + 1, (int)sourceIndex - (int)targetIndex);
        }
        this.data[(int)targetIndex] = shiftling;
        return this;
    }

    @Override
    public FixedList<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        if (sourceIndex + length >= (long)this.data.length) {
            throw new IndexExceededException(this.data.length, sourceIndex);
        }
        if (targetIndex + length >= (long)this.data.length) {
            throw new IndexExceededException(this.data.length, targetIndex);
        }
        if (sourceIndex == targetIndex) {
            if (sourceIndex < 0L) {
                throw new IndexExceededException(this.data.length, sourceIndex);
            }
            return this;
        }
        E[] shiftlings = FixedList.newArray((int)length);
        System.arraycopy(this.data, (int)sourceIndex, shiftlings, 0, (int)length);
        if (sourceIndex < targetIndex) {
            System.arraycopy(this.data, (int)(sourceIndex + length), this.data, (int)sourceIndex, (int)(targetIndex - sourceIndex));
        } else {
            System.arraycopy(this.data, (int)targetIndex, this.data, (int)(targetIndex + length), (int)(sourceIndex - targetIndex));
        }
        System.arraycopy(shiftlings, 0, this.data, (int)targetIndex, (int)length);
        return this;
    }

    @Override
    public FixedList<E> shiftBy(long sourceIndex, long distance) {
        return this.shiftTo(sourceIndex, sourceIndex + distance);
    }

    @Override
    public FixedList<E> shiftBy(long sourceIndex, long distance, long length) {
        return this.shiftTo(sourceIndex, sourceIndex + distance, length);
    }

    @Override
    public SubListAccessor<E> range(long fromIndex, long toIndex) {
        return new SubListAccessor(this, fromIndex, toIndex);
    }

    public String toString() {
        return AbstractArrayStorage.toString(this.data, this.data.length);
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.data.clone();
    }

    @Override
    public E at(long index) throws ArrayIndexOutOfBoundsException {
        if (index >= (long)this.data.length) {
            throw new IndexBoundsException((long)this.data.length, index);
        }
        return (E)this.data[(int)index];
    }

    @Override
    @Deprecated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        if (this.data.length != list.size()) {
            return false;
        }
        Object[] data = this.data;
        int i = 0;
        for (Object e2 : list) {
            Object e1;
            if (!((e1 = data[i++]) == null ? e2 != null : !e1.equals(e2))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public int hashCode() {
        return XArrays.arrayHashCode(this.data, this.data.length);
    }

    @Override
    public OldFixedList<E> old() {
        return new OldFixedList(this);
    }

    public static class Creator<E>
    implements XSettingList.Creator<E> {
        private final int initialCapacity;

        public Creator(int initialCapacity) {
            this.initialCapacity = XMath.pow2BoundMaxed(initialCapacity);
        }

        public int getInitialCapacity() {
            return this.initialCapacity;
        }

        @Override
        public FixedList<E> newInstance() {
            return new FixedList(new Object[this.initialCapacity], this.initialCapacity);
        }
    }

    public static final class OldFixedList<E>
    extends AbstractOldSettingList<E> {
        OldFixedList(FixedList<E> list) {
            super(list);
        }

        @Override
        public FixedList<E> parent() {
            return (FixedList)super.parent();
        }
    }
}

